/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.Version;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.VariantType;
import com.android.repository.Revision;
import com.android.tools.lint.gradle.api.LintExecutionRequest;
import com.android.tools.lint.gradle.api.ReflectiveLintRunner;
import com.android.utils.Pair;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class LintBaseTask
extends DefaultTask {
    public static final String LINT_CLASS_PATH = "lintClassPath";
    protected static final Logger LOG = Logging.getLogger(LintBaseTask.class);
    FileCollection lintClassPath;
    protected Provider<Revision> buildToolsRevisionProvider;
    protected LintOptions lintOptions;
    protected File sdkHome;
    protected ToolingModelBuilderRegistry toolingRegistry;
    protected File reportsDir;

    @InputFiles
    public FileCollection getLintClassPath() {
        return this.lintClassPath;
    }

    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    protected void runLint(LintBaseTaskDescriptor descriptor) {
        FileCollection lintClassPath = this.getLintClassPath();
        if (lintClassPath != null) {
            new ReflectiveLintRunner().runLint(this.getProject().getGradle(), (LintExecutionRequest)descriptor, lintClassPath.getFiles());
        }
    }

    private Revision getBuildToolsRevision() {
        return (Revision)this.buildToolsRevisionProvider.get();
    }

    protected static void addJarArtifactsToInputs(ConfigurableFileCollection inputs, VariantScope variantScope) {
        inputs.from(new Object[]{ArtifactUtils.computeArtifactList(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR)});
        inputs.from(new Object[]{ArtifactUtils.computeArtifactList(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR)});
        if (variantScope.getVariantData() instanceof TestedVariantData) {
            for (VariantType variantType : VariantType.Companion.getTestComponents()) {
                TestVariantData testVariantData = ((TestedVariantData)((Object)variantScope.getVariantData())).getTestVariantData(variantType);
                if (testVariantData == null) continue;
                inputs.from(new Object[]{() -> ArtifactUtils.computeArtifactList(testVariantData.getScope(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR)});
                inputs.from(new Object[]{() -> ArtifactUtils.computeArtifactList(testVariantData.getScope(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR)});
            }
        }
    }

    public static abstract class BaseCreationAction<T extends LintBaseTask>
    extends TaskCreationAction<T> {
        private final GlobalScope globalScope;

        public BaseCreationAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        protected GlobalScope getGlobalScope() {
            return this.globalScope;
        }

        @Override
        public void configure(T lintTask) {
            lintTask.setGroup("verification");
            ((LintBaseTask)((Object)lintTask)).lintOptions = this.globalScope.getExtension().getLintOptions();
            File sdkFolder2 = this.globalScope.getSdkComponents().getSdkFolder();
            if (sdkFolder2 != null) {
                ((LintBaseTask)((Object)lintTask)).sdkHome = sdkFolder2;
            }
            ((LintBaseTask)((Object)lintTask)).toolingRegistry = this.globalScope.getToolingRegistry();
            ((LintBaseTask)((Object)lintTask)).reportsDir = this.globalScope.getReportsDir();
            ((LintBaseTask)((Object)lintTask)).buildToolsRevisionProvider = this.globalScope.getSdkComponents().getBuildToolsRevisionProvider();
            ((LintBaseTask)((Object)lintTask)).lintClassPath = this.globalScope.getProject().getConfigurations().getByName(LintBaseTask.LINT_CLASS_PATH);
        }
    }

    public static class VariantInputs
    implements com.android.tools.lint.gradle.api.VariantInputs {
        private final String name;
        private final Provider<? extends FileSystemLocation> mergedManifest;
        private final Provider<RegularFile> mergedManifestReport;
        private final FileCollection lintRuleJars;
        private final ConfigurableFileCollection allInputs;

        public VariantInputs(VariantScope variantScope) {
            this.name = variantScope.getFullVariantName();
            this.allInputs = variantScope.getGlobalScope().getProject().files(new Object[0]);
            Provider<RegularFile> localLintJarCollection = variantScope.getGlobalScope().getArtifacts().getFinalProduct(InternalArtifactType.LINT_JAR.INSTANCE);
            this.allInputs.from(new Object[]{localLintJarCollection});
            Object[] objectArray = new Object[1];
            FileCollection dependencyLintJarCollection = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT);
            objectArray[0] = dependencyLintJarCollection;
            this.allInputs.from(objectArray);
            this.lintRuleJars = variantScope.getGlobalScope().getProject().files(new Object[]{localLintJarCollection, dependencyLintJarCollection});
            BuildArtifactsHolder artifacts2 = variantScope.getArtifacts();
            Provider<Directory> tmpMergedManifest = artifacts2.getFinalProduct(InternalArtifactType.MERGED_MANIFESTS.INSTANCE);
            if (!tmpMergedManifest.isPresent()) {
                tmpMergedManifest = artifacts2.getFinalProduct(InternalArtifactType.LIBRARY_MANIFEST.INSTANCE);
            }
            if (!tmpMergedManifest.isPresent()) {
                throw new RuntimeException("VariantInputs initialized with no merged manifest on: " + variantScope.getVariantConfiguration().getType());
            }
            this.mergedManifest = tmpMergedManifest;
            this.allInputs.from(new Object[]{this.mergedManifest});
            this.mergedManifestReport = artifacts2.getFinalProduct(InternalArtifactType.MANIFEST_MERGE_REPORT.INSTANCE);
            if (!this.mergedManifest.isPresent()) {
                throw new RuntimeException("VariantInputs initialized with no merged manifest report on: " + variantScope.getVariantConfiguration().getType());
            }
            this.allInputs.from(new Object[]{this.mergedManifestReport});
            this.allInputs.from(new Object[]{artifacts2.getAllClasses()});
            LintBaseTask.addJarArtifactsToInputs(this.allInputs, variantScope);
        }

        public FileCollection getAllInputs() {
            return this.allInputs;
        }

        public String getName() {
            return this.name;
        }

        public FileCollection getRuleJars() {
            return this.lintRuleJars;
        }

        public File getMergedManifest() {
            File file = ((FileSystemLocation)this.mergedManifest.get()).getAsFile();
            if (file.isFile()) {
                return file;
            }
            BuildElements manifests = ExistingBuildElements.from((ArtifactType<Directory>)InternalArtifactType.MERGED_MANIFESTS.INSTANCE, file);
            if (manifests.isEmpty()) {
                throw new RuntimeException("Can't find any manifest in folder: " + file);
            }
            Optional<File> mainManifest = manifests.stream().filter(buildOutput -> buildOutput.getApkData().getType() == VariantOutput.OutputType.MAIN).map(BuildOutput::getOutputFile).findFirst();
            if (mainManifest.isPresent()) {
                return mainManifest.get();
            }
            Optional<File> universalSplit = manifests.stream().filter(output2 -> output2.getApkData().getType() == VariantOutput.OutputType.FULL_SPLIT && output2.getFilters().isEmpty()).map(BuildOutput::getOutputFile).findFirst();
            return universalSplit.orElseGet(() -> manifests.iterator().next().getOutputFile());
        }

        public File getManifestMergeReport() {
            if (this.mergedManifestReport.isPresent()) {
                return ((RegularFile)this.mergedManifestReport.get()).getAsFile();
            }
            return null;
        }
    }

    protected abstract class LintBaseTaskDescriptor
    extends LintExecutionRequest {
        private final Cache<Pair<String, String>, List<File>> kotlinSourceFoldersCache = CacheBuilder.newBuilder().build();

        protected LintBaseTaskDescriptor() {
        }

        public File getSdkHome() {
            return LintBaseTask.this.sdkHome;
        }

        public ToolingModelBuilderRegistry getToolingRegistry() {
            return LintBaseTask.this.toolingRegistry;
        }

        public LintOptions getLintOptions() {
            return LintBaseTask.this.lintOptions;
        }

        public File getReportsDir() {
            return LintBaseTask.this.reportsDir;
        }

        public Project getProject() {
            return LintBaseTask.this.getProject();
        }

        public Revision getBuildToolsRevision() {
            return LintBaseTask.this.getBuildToolsRevision();
        }

        public void warn(String message, Object ... args2) {
            LOG.warn(message, args2);
        }

        public String getGradlePluginVersion() {
            return Version.ANDROID_GRADLE_PLUGIN_VERSION;
        }

        private List<File> doFetchKotlinSourceFolders(String sourceSetName, Project project2) throws Exception {
            BaseExtension extension = (BaseExtension)project2.getExtensions().getByName("android");
            Object kotlinSourceSet = ((HasConvention)extension.getSourceSets().getByName(sourceSetName)).getConvention().getPlugins().get("kotlin");
            Method getSourceDirectorySet = kotlinSourceSet.getClass().getDeclaredMethod("getKotlin", new Class[0]);
            SourceDirectorySet sourceDirectorySet = (SourceDirectorySet)getSourceDirectorySet.invoke(kotlinSourceSet, new Object[0]);
            return sourceDirectorySet.getSrcDirs().stream().filter(File::exists).collect(Collectors.toList());
        }

        private List<File> fetchKotlinSourceFolders(String sourceSetName, Project project2) {
            try {
                return (List)this.kotlinSourceFoldersCache.get((Object)Pair.of((Object)sourceSetName, (Object)project2.getPath()), () -> this.doFetchKotlinSourceFolders(sourceSetName, project2));
            }
            catch (Throwable e) {
                LintBaseTask.this.getLogger().warn("Unable to fetch kotlin source folders for source set " + sourceSetName, e);
                return Collections.emptyList();
            }
        }

        public List<File> getKotlinSourceFolders(String variantName, Project project2) {
            DomainObjectSet<ApplicationVariant> variants;
            if (project2 == null || !project2.getPlugins().hasPlugin("kotlin-android")) {
                return Collections.emptyList();
            }
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            BaseExtension extension = (BaseExtension)project2.getExtensions().getByName("android");
            if (extension instanceof AppExtension) {
                variants = ((AppExtension)extension).getApplicationVariants();
            } else if (extension instanceof LibraryExtension) {
                variants = ((LibraryExtension)extension).getLibraryVariants();
            } else {
                return Collections.emptyList();
            }
            variants.matching(it -> it.getName().equals(variantName)).forEach(variant2 -> variant2.getSourceSets().forEach(sourceProvider -> builder.addAll(this.fetchKotlinSourceFolders(sourceProvider.getName(), project2))));
            return builder.build().asList();
        }
    }
}

