/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.manifest.ManifestHelperKt;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ProductFlavor;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.tools.ant.BuildException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class ProcessLibraryManifest
extends ManifestProcessorTask {
    private Supplier<String> minSdkVersion;
    private Supplier<String> targetSdkVersion;
    private Supplier<Integer> maxSdkVersion;
    private OutputScope outputScope;
    private final RegularFileProperty manifestOutputFile;
    private final Property<String> packageOverride;
    private final Property<Integer> versionCode;
    private final Property<String> versionName;
    private final ListProperty<File> manifestOverlays;
    private final MapProperty<String, Object> manifestPlaceholders;
    private boolean isNamespaced;

    @Inject
    public ProcessLibraryManifest(ObjectFactory objectFactory) {
        super(objectFactory);
        this.manifestOutputFile = objectFactory.fileProperty();
        this.packageOverride = objectFactory.property(String.class);
        this.versionCode = objectFactory.property(Integer.class);
        this.versionName = objectFactory.property(String.class);
        this.manifestOverlays = objectFactory.listProperty(File.class);
        this.manifestPlaceholders = objectFactory.mapProperty(String.class, Object.class);
    }

    @OutputFile
    public RegularFileProperty getManifestOutputFile() {
        return this.manifestOutputFile;
    }

    @Override
    protected void doFullTaskAction() {
        try (WorkerExecutorFacade workers = this.getWorkerFacadeWithWorkers();){
            DirectoryProperty manifestOutputDirectory = this.getManifestOutputDirectory();
            DirectoryProperty aaptFriendlyManifestOutputDirectory = this.getAaptFriendlyManifestOutputDirectory();
            workers.submit(ProcessLibRunnable.class, (Serializable)new ProcessLibParams(this.getAaptFriendlyManifestOutputFile(), this.isNamespaced, (File)this.getMainManifest().get(), (List)this.manifestOverlays.get(), (String)this.packageOverride.getOrNull(), (Integer)this.versionCode.get(), (String)this.versionName.getOrNull(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getMaxSdkVersion(), ((RegularFile)this.manifestOutputFile.get()).getAsFile(), (Map)this.manifestPlaceholders.get(), ((RegularFile)this.getReportFile().get()).getAsFile(), ((RegularFile)this.getMergeBlameFile().get()).getAsFile(), manifestOutputDirectory.isPresent() ? ((Directory)manifestOutputDirectory.get()).getAsFile() : null, aaptFriendlyManifestOutputDirectory.isPresent() ? ((Directory)aaptFriendlyManifestOutputDirectory.get()).getAsFile() : null, this.outputScope.getMainSplit()));
        }
    }

    @Override
    @Internal
    public File getAaptFriendlyManifestOutputFile() {
        Preconditions.checkNotNull((Object)this.outputScope.getMainSplit());
        return this.getAaptFriendlyManifestOutputDirectory().isPresent() ? FileUtils.join((File)((Directory)this.getAaptFriendlyManifestOutputDirectory().get()).getAsFile(), (String[])new String[]{this.outputScope.getMainSplit().getDirName(), "AndroidManifest.xml"}) : null;
    }

    @Input
    @Optional
    public String getMinSdkVersion() {
        return this.minSdkVersion.get();
    }

    @Input
    @Optional
    public String getTargetSdkVersion() {
        return this.targetSdkVersion.get();
    }

    @Input
    @Optional
    public Integer getMaxSdkVersion() {
        return this.maxSdkVersion.get();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract Property<File> getMainManifest();

    @Input
    @Optional
    public Property<String> getPackageOverride() {
        return this.packageOverride;
    }

    @Input
    public Property<Integer> getVersionCode() {
        return this.versionCode;
    }

    @Input
    @Optional
    public Property<String> getVersionName() {
        return this.versionName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ListProperty<File> getManifestOverlays() {
        return this.manifestOverlays;
    }

    @Input
    @Optional
    public MapProperty<String, Object> getManifestPlaceholders() {
        return this.manifestPlaceholders;
    }

    @Input
    public String getMainSplitFullName() {
        return this.outputScope.getMainSplit().getFullName();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ProcessLibraryManifest> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("process", "Manifest");
        }

        @Override
        public Class<ProcessLibraryManifest> getType() {
            return ProcessLibraryManifest.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends ProcessLibraryManifest> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setProcessManifestTask(taskProvider);
            BuildArtifactsHolder artifacts2 = this.getVariantScope().getArtifacts();
            artifacts2.producesDir(InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS.INSTANCE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, ManifestProcessorTask::getAaptFriendlyManifestOutputDirectory, "aapt");
            artifacts2.producesDir(InternalArtifactType.MERGED_MANIFESTS.INSTANCE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, ManifestProcessorTask::getManifestOutputDirectory, "");
            artifacts2.producesFile(InternalArtifactType.LIBRARY_MANIFEST.INSTANCE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, ProcessLibraryManifest::getManifestOutputFile, "AndroidManifest.xml");
            artifacts2.producesFile(InternalArtifactType.MANIFEST_MERGE_BLAME_FILE.INSTANCE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, ManifestProcessorTask::getMergeBlameFile, "manifest-merger-blame-" + this.getVariantScope().getVariantConfiguration().getBaseName() + "-report.txt");
            artifacts2.producesFile(InternalArtifactType.MANIFEST_MERGE_REPORT.INSTANCE, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, ManifestProcessorTask::getReportFile, FileUtils.join((File)this.getVariantScope().getGlobalScope().getOutputsDir(), (String[])new String[]{"logs"}).getAbsolutePath(), "manifest-merger-" + this.getVariantScope().getVariantConfiguration().getBaseName() + "-report.txt");
        }

        @Override
        public void configure(ProcessLibraryManifest task) {
            super.configure(task);
            GradleVariantConfiguration config2 = this.getVariantScope().getVariantConfiguration();
            ProductFlavor mergedFlavor = config2.getMergedFlavor();
            task.minSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion minSdkVersion1 = mergedFlavor.getMinSdkVersion();
                if (minSdkVersion1 == null) {
                    return null;
                }
                return minSdkVersion1.getApiString();
            });
            task.targetSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion targetSdkVersion = mergedFlavor.getTargetSdkVersion();
                if (targetSdkVersion == null) {
                    return null;
                }
                return targetSdkVersion.getApiString();
            });
            task.maxSdkVersion = TaskInputHelper.memoize(() -> ((ProductFlavor)mergedFlavor).getMaxSdkVersion());
            task.outputScope = this.getVariantScope().getOutputScope();
            task.isNamespaced = this.getVariantScope().getGlobalScope().getExtension().getAaptOptions().getNamespaced();
            task.versionName.set(task.getProject().provider(config2::getVersionName));
            task.versionCode.set(task.getProject().provider(config2::getVersionCode));
            task.packageOverride.set(task.getProject().provider(config2::getApplicationId));
            task.manifestPlaceholders.set(task.getProject().provider(config2::getManifestPlaceholders));
            task.getMainManifest().set(TaskInputHelper.memoizeToProvider(task.getProject(), config2::getMainManifestFilePath));
            task.manifestOverlays.set(task.getProject().provider(config2::getManifestOverlays));
        }
    }

    public static class ProcessLibRunnable
    implements Runnable {
        private final ProcessLibParams params;

        @Inject
        public ProcessLibRunnable(ProcessLibParams params) {
            this.params = params;
        }

        @Override
        public void run() {
            List<Object> optionalFeatures = this.params.isNamespaced ? Collections.singletonList(ManifestMerger2.Invoker.Feature.FULLY_NAMESPACE_LOCAL_RESOURCES) : Collections.emptyList();
            MergingReport mergingReport = ManifestHelperKt.mergeManifestsForApplication(this.params.mainManifest, this.params.manifestOverlays, Collections.emptyList(), Collections.emptyList(), null, this.params.packageOverride, this.params.versionCode, this.params.versionName, this.params.minSdkVersion, this.params.targetSdkVersion, this.params.maxSdkVersion, this.params.manifestOutputFile.getAbsolutePath(), this.params.aaptFriendlyManifestOutputFile != null ? this.params.aaptFriendlyManifestOutputFile.getAbsolutePath() : null, null, null, null, ManifestMerger2.MergeType.LIBRARY, this.params.manifestPlaceholders, optionalFeatures, this.params.reportFile, LoggerWrapper.getLogger(ProcessLibraryManifest.class));
            XmlDocument mergedXmlDocument = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            try {
                ManifestProcessorTask.outputMergeBlameContents(mergingReport, this.params.mergeBlameFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ImmutableMap properties = mergedXmlDocument != null ? ImmutableMap.of((Object)"packageId", (Object)mergedXmlDocument.getPackageName(), (Object)"split", (Object)mergedXmlDocument.getSplitName()) : ImmutableMap.of();
            try {
                if (this.params.manifestOutputDirectory != null) {
                    new BuildOutput((ArtifactType)InternalArtifactType.MERGED_MANIFESTS.INSTANCE, this.params.mainSplit, this.params.manifestOutputFile, (Map<String, String>)properties).save(this.params.manifestOutputDirectory);
                }
                if (this.params.aaptFriendlyManifestOutputDirectory != null) {
                    new BuildOutput((ArtifactType)InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS.INSTANCE, this.params.mainSplit, this.params.aaptFriendlyManifestOutputFile, (Map<String, String>)properties).save(this.params.aaptFriendlyManifestOutputDirectory);
                }
            }
            catch (IOException e) {
                throw new BuildException("Exception while saving build metadata : ", (Throwable)e);
            }
        }
    }

    private static class ProcessLibParams
    implements Serializable {
        private final File aaptFriendlyManifestOutputFile;
        private final boolean isNamespaced;
        private final File mainManifest;
        private final List<File> manifestOverlays;
        private final String packageOverride;
        private final int versionCode;
        private final String versionName;
        private final String minSdkVersion;
        private final String targetSdkVersion;
        private final Integer maxSdkVersion;
        private final File manifestOutputFile;
        private final Map<String, Object> manifestPlaceholders;
        private final File reportFile;
        private final File mergeBlameFile;
        private final File manifestOutputDirectory;
        private final File aaptFriendlyManifestOutputDirectory;
        private final ApkData mainSplit;

        private ProcessLibParams(File aaptFriendlyManifestOutputFile, boolean isNamespaced, File mainManifest, List<File> manifestOverlays, String packageOverride, int versionCode, String versionName, String minSdkVersion, String targetSdkVersion, Integer maxSdkVersion, File manifestOutputFile, Map<String, Object> manifestPlaceholders, File reportFile, File mergeBlameFile, File manifestOutputDirectory, File aaptFriendlyManifestOutputDirectory, ApkData mainSplit) {
            this.aaptFriendlyManifestOutputFile = aaptFriendlyManifestOutputFile;
            this.isNamespaced = isNamespaced;
            this.mainManifest = mainManifest;
            this.manifestOverlays = manifestOverlays;
            this.packageOverride = packageOverride;
            this.versionCode = versionCode;
            this.versionName = versionName;
            this.minSdkVersion = minSdkVersion;
            this.targetSdkVersion = targetSdkVersion;
            this.maxSdkVersion = maxSdkVersion;
            this.manifestOutputFile = manifestOutputFile;
            this.manifestPlaceholders = manifestPlaceholders;
            this.reportFile = reportFile;
            this.mergeBlameFile = mergeBlameFile;
            this.manifestOutputDirectory = manifestOutputDirectory;
            this.aaptFriendlyManifestOutputDirectory = aaptFriendlyManifestOutputDirectory;
            this.mainSplit = mainSplit;
        }
    }
}

