/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.compiling.ResValueGenerator;
import com.android.builder.model.ClassField;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004H\u0007R0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u00020\u000e8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/tasks/GenerateResValues;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "value", "", "", "items", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "itemsSupplier", "Ljava/util/function/Supplier;", "resOutputDir", "Ljava/io/File;", "getResOutputDir", "()Ljava/io/File;", "setResOutputDir", "(Ljava/io/File;)V", "doTaskAction", "", "getItemValues", "", "CreationAction", "gradle"})
public abstract class GenerateResValues
extends NonIncrementalTask {
    @NotNull
    public File resOutputDir;
    private Supplier<List<Object>> itemsSupplier;

    @OutputDirectory
    @NotNull
    public final File getResOutputDir() {
        File file = this.resOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resOutputDir");
        }
        return file;
    }

    public final void setResOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.resOutputDir = file;
    }

    @Internal
    @NotNull
    public final List<Object> getItems() {
        Supplier<List<Object>> supplier = this.itemsSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemsSupplier");
        }
        List<Object> list = supplier.get();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"itemsSupplier.get()");
        return list;
    }

    public final void setItems(@NotNull List<? extends Object> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.itemsSupplier = new Supplier<List<? extends Object>>(value){
            final /* synthetic */ List $value;

            @NotNull
            public final List<Object> get() {
                return this.$value;
            }
            {
                this.$value = list;
            }
        };
    }

    @Input
    @NotNull
    public final List<String> getItemValues() {
        List<Object> resolvedItems = this.getItems();
        ArrayList list = Lists.newArrayListWithCapacity((int)(resolvedItems.size() * 3));
        for (Object item : resolvedItems) {
            if (item instanceof String) {
                list.add(item);
                continue;
            }
            if (!(item instanceof ClassField)) continue;
            list.add(((ClassField)item).getType());
            list.add(((ClassField)item).getName());
            list.add(((ClassField)item).getValue());
        }
        ArrayList arrayList = list;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"list");
        return arrayList;
    }

    @Override
    protected void doTaskAction() {
        File file = this.resOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resOutputDir");
        }
        File folder = file;
        List<Object> resolvedItems = this.getItems();
        FileUtils.cleanOutputDir((File)folder);
        Collection collection = resolvedItems;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ResValueGenerator generator = new ResValueGenerator(folder);
            generator.addItems((Collection)resolvedItems);
            generator.generate();
        }
    }

    public static final /* synthetic */ Supplier access$getItemsSupplier$p(GenerateResValues $this) {
        Supplier<List<Object>> supplier = $this.itemsSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemsSupplier");
        }
        return supplier;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/tasks/GenerateResValues$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/GenerateResValues;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateResValues> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<GenerateResValues> type;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<GenerateResValues> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends GenerateResValues> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setGenerateResValuesTask(taskProvider);
        }

        @Override
        public void configure(@NotNull GenerateResValues task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            Supplier supplier = TaskInputHelper.memoize(new Supplier<T>(this){
                final /* synthetic */ CreationAction this$0;

                @NotNull
                public final List<Object> get() {
                    GradleVariantConfiguration gradleVariantConfiguration = CreationAction.access$getVariantScope$p(this.this$0).getVariantConfiguration();
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
                    return gradleVariantConfiguration.getResValues();
                }
                {
                    this.this$0 = creationAction;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(supplier, (String)"TaskInputHelper.memoize \u2026Configuration.resValues }");
            task.itemsSupplier = supplier;
            File file = this.getVariantScope().getGeneratedResOutputDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"variantScope.generatedResOutputDir");
            task.setResOutputDir(file);
        }

        public CreationAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            super(scope);
            String string = scope.getTaskName("generate", "ResValues");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scope.getTaskName(\"generate\", \"ResValues\")");
            this.name = string;
            this.type = GenerateResValues.class;
        }

        public static final /* synthetic */ VariantScope access$getVariantScope$p(CreationAction $this) {
            return $this.getVariantScope();
        }
    }
}

