/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.PackageBundleTaskKt;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.packaging.PackagingUtils;
import com.android.bundle.Config;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0005-./01B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010+\u001a\u00020,H\u0014R,\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00138G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u00178G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u001b8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0010R \u0010%\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020$8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0010R\u0014\u0010)\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010\u00a8\u00062"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "<set-?>", "", "", "aaptOptionsNoCompress", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "baseModuleZip", "Lorg/gradle/api/file/DirectoryProperty;", "getBaseModuleZip", "()Lorg/gradle/api/file/DirectoryProperty;", "bundleDeps", "Lorg/gradle/api/file/RegularFileProperty;", "getBundleDeps", "()Lorg/gradle/api/file/RegularFileProperty;", "bundleFile", "getBundleFile", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "bundleFlags", "getBundleFlags", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "bundleOptions", "getBundleOptions", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "Lorg/gradle/api/file/FileCollection;", "featureZips", "getFeatureZips", "()Lorg/gradle/api/file/FileCollection;", "fileName", "getFileName", "()Ljava/lang/String;", "integrityConfigFile", "getIntegrityConfigFile", "", "isDebugBuild", "()Z", "mainDexList", "getMainDexList", "obsfuscationMappingFile", "getObsfuscationMappingFile", "doTaskAction", "", "BundleFlags", "BundleOptions", "BundleToolRunnable", "CreationAction", "Params", "gradle"})
public abstract class PackageBundleTask
extends NonIncrementalTask {
    @NotNull
    private FileCollection featureZips;
    @NotNull
    private Collection<String> aaptOptionsNoCompress;
    @NotNull
    private BundleOptions bundleOptions;
    @NotNull
    private BundleFlags bundleFlags;
    private boolean isDebugBuild;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract DirectoryProperty getBaseModuleZip();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final FileCollection getFeatureZips() {
        FileCollection fileCollection2 = this.featureZips;
        if (fileCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection2;
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getBundleDeps();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getMainDexList();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getObsfuscationMappingFile();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getIntegrityConfigFile();

    @Input
    @NotNull
    public final Collection<String> getAaptOptionsNoCompress() {
        Collection<String> collection = this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    @Nested
    @NotNull
    public final BundleOptions getBundleOptions() {
        BundleOptions bundleOptions = this.bundleOptions;
        if (bundleOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
        }
        return bundleOptions;
    }

    @Nested
    @NotNull
    public final BundleFlags getBundleFlags() {
        BundleFlags bundleFlags = this.bundleFlags;
        if (bundleFlags == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFlags");
        }
        return bundleFlags;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getBundleFile();

    @Input
    @NotNull
    public final String getFileName() {
        Object object = this.getBundleFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"bundleFile.get().asFile");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundleFile.get().asFile.name");
        return string;
    }

    @Input
    public final boolean isDebugBuild() {
        return this.isDebugBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        Closeable closeable = (Closeable)this.getWorkerFacadeWithWorkers();
        boolean bl = false;
        Throwable throwable = null;
        try {
            File file;
            File file2;
            File file3;
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl2 = false;
            Object object = this.getBaseModuleZip().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"baseModuleZip.get()");
            FileTree fileTree = ((Directory)object).getAsFileTree();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"baseModuleZip.get().asFileTree");
            File file4 = fileTree.getSingleFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"baseModuleZip.get().asFileTree.singleFile");
            FileCollection fileCollection2 = this.featureZips;
            if (fileCollection2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
            }
            Set set = fileCollection2.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureZips.files");
            RegularFile regularFile = (RegularFile)this.getMainDexList().getOrNull();
            File file5 = regularFile != null ? regularFile.getAsFile() : null;
            if (this.getObsfuscationMappingFile().isPresent()) {
                Object object2 = this.getObsfuscationMappingFile().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"obsfuscationMappingFile.get()");
                file3 = ((RegularFile)object2).getAsFile();
            } else {
                file3 = null;
            }
            if (this.getIntegrityConfigFile().isPresent()) {
                Object object3 = this.getIntegrityConfigFile().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"integrityConfigFile.get()");
                file2 = ((RegularFile)object3).getAsFile();
            } else {
                file2 = null;
            }
            Collection<String> collection = this.aaptOptionsNoCompress;
            if (collection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
            }
            BundleOptions bundleOptions = this.bundleOptions;
            if (bundleOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
            }
            BundleFlags bundleFlags = this.bundleFlags;
            if (bundleFlags == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFlags");
            }
            Object object4 = this.getBundleFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"bundleFile.get()");
            File file6 = ((RegularFile)object4).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"bundleFile.get().asFile");
            if (this.getBundleDeps().isPresent()) {
                Object object5 = this.getBundleDeps().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"bundleDeps.get()");
                file = ((RegularFile)object5).getAsFile();
            } else {
                file = null;
            }
            it.submit(BundleToolRunnable.class, (Serializable)new Params(file4, set, file5, file3, file2, collection, bundleOptions, bundleFlags, file6, file, this.isDebugBuild));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ FileCollection access$getFeatureZips$p(PackageBundleTask $this) {
        FileCollection fileCollection2 = $this.featureZips;
        if (fileCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection2;
    }

    public static final /* synthetic */ Collection access$getAaptOptionsNoCompress$p(PackageBundleTask $this) {
        Collection<String> collection = $this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    public static final /* synthetic */ BundleOptions access$getBundleOptions$p(PackageBundleTask $this) {
        BundleOptions bundleOptions = $this.bundleOptions;
        if (bundleOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
        }
        return bundleOptions;
    }

    public static final /* synthetic */ BundleFlags access$getBundleFlags$p(PackageBundleTask $this) {
        BundleFlags bundleFlags = $this.bundleFlags;
        if (bundleFlags == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFlags");
        }
        return bundleFlags;
    }

    public static final /* synthetic */ boolean access$isDebugBuild$p(PackageBundleTask $this) {
        return $this.isDebugBuild;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0013H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010.\u001a\u00020\rH\u00c6\u0003J\t\u0010/\u001a\u00020\u000fH\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\u008b\u0001\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u00102\u001a\u00020\u00132\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u000206H\u00d6\u0001J\t\u00107\u001a\u00020\u000bH\u00d6\u0001R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0018R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00068"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;", "Ljava/io/Serializable;", "baseModuleFile", "Ljava/io/File;", "featureFiles", "", "mainDexList", "obfuscationMappingFile", "integrityConfigFile", "aaptOptionsNoCompress", "", "", "bundleOptions", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "bundleFlags", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "bundleFile", "bundleDeps", "uncompressBundle", "", "(Ljava/io/File;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/util/Collection;Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;Ljava/io/File;Ljava/io/File;Z)V", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "getBaseModuleFile", "()Ljava/io/File;", "getBundleDeps", "getBundleFile", "getBundleFlags", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "getBundleOptions", "()Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "getFeatureFiles", "()Ljava/util/Set;", "getIntegrityConfigFile", "getMainDexList", "getObfuscationMappingFile", "getUncompressBundle", "()Z", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "toString", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File baseModuleFile;
        @NotNull
        private final Set<File> featureFiles;
        @Nullable
        private final File mainDexList;
        @Nullable
        private final File obfuscationMappingFile;
        @Nullable
        private final File integrityConfigFile;
        @NotNull
        private final Collection<String> aaptOptionsNoCompress;
        @NotNull
        private final BundleOptions bundleOptions;
        @NotNull
        private final BundleFlags bundleFlags;
        @NotNull
        private final File bundleFile;
        @Nullable
        private final File bundleDeps;
        private final boolean uncompressBundle;

        @NotNull
        public final File getBaseModuleFile() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> getFeatureFiles() {
            return this.featureFiles;
        }

        @Nullable
        public final File getMainDexList() {
            return this.mainDexList;
        }

        @Nullable
        public final File getObfuscationMappingFile() {
            return this.obfuscationMappingFile;
        }

        @Nullable
        public final File getIntegrityConfigFile() {
            return this.integrityConfigFile;
        }

        @NotNull
        public final Collection<String> getAaptOptionsNoCompress() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final BundleOptions getBundleOptions() {
            return this.bundleOptions;
        }

        @NotNull
        public final BundleFlags getBundleFlags() {
            return this.bundleFlags;
        }

        @NotNull
        public final File getBundleFile() {
            return this.bundleFile;
        }

        @Nullable
        public final File getBundleDeps() {
            return this.bundleDeps;
        }

        public final boolean getUncompressBundle() {
            return this.uncompressBundle;
        }

        public Params(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @Nullable File mainDexList, @Nullable File obfuscationMappingFile, @Nullable File integrityConfigFile, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull BundleOptions bundleOptions, @NotNull BundleFlags bundleFlags, @NotNull File bundleFile, @Nullable File bundleDeps, boolean uncompressBundle) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleOptions, (String)"bundleOptions");
            Intrinsics.checkParameterIsNotNull((Object)bundleFlags, (String)"bundleFlags");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            this.baseModuleFile = baseModuleFile;
            this.featureFiles = featureFiles;
            this.mainDexList = mainDexList;
            this.obfuscationMappingFile = obfuscationMappingFile;
            this.integrityConfigFile = integrityConfigFile;
            this.aaptOptionsNoCompress = aaptOptionsNoCompress;
            this.bundleOptions = bundleOptions;
            this.bundleFlags = bundleFlags;
            this.bundleFile = bundleFile;
            this.bundleDeps = bundleDeps;
            this.uncompressBundle = uncompressBundle;
        }

        @NotNull
        public final File component1() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> component2() {
            return this.featureFiles;
        }

        @Nullable
        public final File component3() {
            return this.mainDexList;
        }

        @Nullable
        public final File component4() {
            return this.obfuscationMappingFile;
        }

        @Nullable
        public final File component5() {
            return this.integrityConfigFile;
        }

        @NotNull
        public final Collection<String> component6() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final BundleOptions component7() {
            return this.bundleOptions;
        }

        @NotNull
        public final BundleFlags component8() {
            return this.bundleFlags;
        }

        @NotNull
        public final File component9() {
            return this.bundleFile;
        }

        @Nullable
        public final File component10() {
            return this.bundleDeps;
        }

        public final boolean component11() {
            return this.uncompressBundle;
        }

        @NotNull
        public final Params copy(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @Nullable File mainDexList, @Nullable File obfuscationMappingFile, @Nullable File integrityConfigFile, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull BundleOptions bundleOptions, @NotNull BundleFlags bundleFlags, @NotNull File bundleFile, @Nullable File bundleDeps, boolean uncompressBundle) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleOptions, (String)"bundleOptions");
            Intrinsics.checkParameterIsNotNull((Object)bundleFlags, (String)"bundleFlags");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            return new Params(baseModuleFile, featureFiles, mainDexList, obfuscationMappingFile, integrityConfigFile, aaptOptionsNoCompress, bundleOptions, bundleFlags, bundleFile, bundleDeps, uncompressBundle);
        }

        public static /* synthetic */ Params copy$default(Params params, File file, Set set, File file2, File file3, File file4, Collection collection, BundleOptions bundleOptions, BundleFlags bundleFlags, File file5, File file6, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.baseModuleFile;
            }
            if ((n & 2) != 0) {
                set = params.featureFiles;
            }
            if ((n & 4) != 0) {
                file2 = params.mainDexList;
            }
            if ((n & 8) != 0) {
                file3 = params.obfuscationMappingFile;
            }
            if ((n & 0x10) != 0) {
                file4 = params.integrityConfigFile;
            }
            if ((n & 0x20) != 0) {
                collection = params.aaptOptionsNoCompress;
            }
            if ((n & 0x40) != 0) {
                bundleOptions = params.bundleOptions;
            }
            if ((n & 0x80) != 0) {
                bundleFlags = params.bundleFlags;
            }
            if ((n & 0x100) != 0) {
                file5 = params.bundleFile;
            }
            if ((n & 0x200) != 0) {
                file6 = params.bundleDeps;
            }
            if ((n & 0x400) != 0) {
                bl = params.uncompressBundle;
            }
            return params.copy(file, set, file2, file3, file4, collection, bundleOptions, bundleFlags, file5, file6, bl);
        }

        @NotNull
        public String toString() {
            return "Params(baseModuleFile=" + this.baseModuleFile + ", featureFiles=" + this.featureFiles + ", mainDexList=" + this.mainDexList + ", obfuscationMappingFile=" + this.obfuscationMappingFile + ", integrityConfigFile=" + this.integrityConfigFile + ", aaptOptionsNoCompress=" + this.aaptOptionsNoCompress + ", bundleOptions=" + this.bundleOptions + ", bundleFlags=" + this.bundleFlags + ", bundleFile=" + this.bundleFile + ", bundleDeps=" + this.bundleDeps + ", uncompressBundle=" + this.uncompressBundle + ")";
        }

        public int hashCode() {
            File file = this.baseModuleFile;
            Set<File> set = this.featureFiles;
            File file2 = this.mainDexList;
            File file3 = this.obfuscationMappingFile;
            File file4 = this.integrityConfigFile;
            Collection<String> collection = this.aaptOptionsNoCompress;
            BundleOptions bundleOptions = this.bundleOptions;
            BundleFlags bundleFlags = this.bundleFlags;
            File file5 = this.bundleFile;
            File file6 = this.bundleDeps;
            int n = ((((((((((file != null ? ((Object)file).hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (file4 != null ? ((Object)file4).hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + (bundleOptions != null ? ((Object)bundleOptions).hashCode() : 0)) * 31 + (bundleFlags != null ? ((Object)bundleFlags).hashCode() : 0)) * 31 + (file5 != null ? ((Object)file5).hashCode() : 0)) * 31 + (file6 != null ? ((Object)file6).hashCode() : 0)) * 31;
            int n2 = this.uncompressBundle ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.baseModuleFile, (Object)params.baseModuleFile) || !Intrinsics.areEqual(this.featureFiles, params.featureFiles) || !Intrinsics.areEqual((Object)this.mainDexList, (Object)params.mainDexList) || !Intrinsics.areEqual((Object)this.obfuscationMappingFile, (Object)params.obfuscationMappingFile) || !Intrinsics.areEqual((Object)this.integrityConfigFile, (Object)params.integrityConfigFile) || !Intrinsics.areEqual(this.aaptOptionsNoCompress, params.aaptOptionsNoCompress) || !Intrinsics.areEqual((Object)this.bundleOptions, (Object)params.bundleOptions) || !Intrinsics.areEqual((Object)this.bundleFlags, (Object)params.bundleFlags) || !Intrinsics.areEqual((Object)this.bundleFile, (Object)params.bundleFile) || !Intrinsics.areEqual((Object)this.bundleDeps, (Object)params.bundleDeps) || this.uncompressBundle != params.uncompressBundle) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;", "(Lcom/android/build/gradle/internal/tasks/PackageBundleTask$Params;)V", "getBundlePath", "Ljava/nio/file/Path;", "folder", "Ljava/io/File;", "run", "", "gradle"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            File it;
            boolean bl;
            boolean bl2;
            File bundleFile = this.params.getBundleFile();
            FileUtils.cleanOutputDir((File)bundleFile.getParentFile());
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.params.getBaseModuleFile().toPath());
            Iterable $this$forEach$iv = this.params.getFeatureFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it2 = (File)element$iv;
                boolean bl3 = false;
                builder.add((Object)this.getBundlePath(it2));
            }
            List noCompressGlobsForBundle = PackagingUtils.getNoCompressGlobsForBundle(this.params.getAaptOptionsNoCompress());
            Config.SplitsConfig.Builder builder2 = Config.SplitsConfig.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"Config.SplitsConfig.newBuilder()");
            Config.SplitsConfig.Builder splitsConfig = PackageBundleTaskKt.access$splitBy(PackageBundleTaskKt.access$splitBy(PackageBundleTaskKt.access$splitBy(PackageBundleTaskKt.access$splitBy(builder2, Config.SplitDimension.Value.ABI, this.params.getBundleOptions().getEnableAbi()), Config.SplitDimension.Value.SCREEN_DENSITY, this.params.getBundleOptions().getEnableDensity()), Config.SplitDimension.Value.LANGUAGE, this.params.getBundleOptions().getEnableLanguage()), Config.SplitDimension.Value.TEXTURE_COMPRESSION_FORMAT, this.params.getBundleOptions().getEnableTexture());
            Config.UncompressNativeLibraries.Builder uncompressNativeLibrariesConfig = Config.UncompressNativeLibraries.newBuilder().setEnabled(this.params.getBundleFlags().getEnableUncompressedNativeLibs());
            Config.BundleConfig.Builder bundleConfig = Config.BundleConfig.newBuilder().setCompression(Config.Compression.newBuilder().addAllUncompressedGlob((Iterable)noCompressGlobsForBundle)).setOptimizations(Config.Optimizations.newBuilder().setSplitsConfig(splitsConfig).setUncompressNativeLibraries(uncompressNativeLibrariesConfig));
            BuildBundleCommand.Builder command = BuildBundleCommand.builder().setUncompressedBundle(this.params.getUncompressBundle()).setBundleConfig(bundleConfig.build()).setOutputPath(bundleFile.toPath()).setModulesPaths(builder.build());
            File file = this.params.getBundleDeps();
            if (file != null) {
                File file2 = file;
                bl2 = false;
                bl = false;
                it = file2;
                boolean bl4 = false;
                command.addMetadataFile("com.android.tools.build.libraries", "dependencies.pb", it.toPath());
            }
            File file3 = this.params.getMainDexList();
            if (file3 != null) {
                File file4 = file3;
                bl2 = false;
                bl = false;
                it = file4;
                boolean bl5 = false;
                command.setMainDexListFile(it.toPath());
            }
            File file5 = this.params.getObfuscationMappingFile();
            if (file5 != null) {
                File file6 = file5;
                bl2 = false;
                bl = false;
                it = file6;
                boolean bl6 = false;
                command.addMetadataFile("com.android.tools.build.obfuscation", "proguard.map", it.toPath());
            }
            File file7 = this.params.getIntegrityConfigFile();
            if (file7 != null) {
                File file8 = file7;
                bl2 = false;
                bl = false;
                it = file8;
                boolean bl7 = false;
                if (it.isFile()) {
                    command.addMetadataFile("com.google.play.apps.integrity", "AppIntegrityConfig.pb", it.toPath());
                }
            }
            command.build().execute();
        }

        private final Path getBundlePath(File folder) {
            File[] children2 = folder.listFiles();
            Preconditions.checkNotNull((Object)children2);
            Preconditions.checkState((children2.length == 1 ? 1 : 0) != 0);
            Path path = children2[0].toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"children[0].toPath()");
            return path;
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ>\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\f\u0010\tR\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "Ljava/io/Serializable;", "enableAbi", "", "enableDensity", "enableLanguage", "enableTexture", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getEnableAbi", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getEnableDensity", "getEnableLanguage", "getEnableTexture", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleOptions;", "equals", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class BundleOptions
    implements Serializable {
        @Nullable
        private final Boolean enableAbi;
        @Nullable
        private final Boolean enableDensity;
        @Nullable
        private final Boolean enableLanguage;
        @Nullable
        private final Boolean enableTexture;

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableAbi() {
            return this.enableAbi;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableDensity() {
            return this.enableDensity;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableLanguage() {
            return this.enableLanguage;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableTexture() {
            return this.enableTexture;
        }

        public BundleOptions(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage, @Nullable Boolean enableTexture) {
            this.enableAbi = enableAbi;
            this.enableDensity = enableDensity;
            this.enableLanguage = enableLanguage;
            this.enableTexture = enableTexture;
        }

        @Nullable
        public final Boolean component1() {
            return this.enableAbi;
        }

        @Nullable
        public final Boolean component2() {
            return this.enableDensity;
        }

        @Nullable
        public final Boolean component3() {
            return this.enableLanguage;
        }

        @Nullable
        public final Boolean component4() {
            return this.enableTexture;
        }

        @NotNull
        public final BundleOptions copy(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage, @Nullable Boolean enableTexture) {
            return new BundleOptions(enableAbi, enableDensity, enableLanguage, enableTexture);
        }

        public static /* synthetic */ BundleOptions copy$default(BundleOptions bundleOptions, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bundleOptions.enableAbi;
            }
            if ((n & 2) != 0) {
                bl2 = bundleOptions.enableDensity;
            }
            if ((n & 4) != 0) {
                bl3 = bundleOptions.enableLanguage;
            }
            if ((n & 8) != 0) {
                bl4 = bundleOptions.enableTexture;
            }
            return bundleOptions.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "BundleOptions(enableAbi=" + this.enableAbi + ", enableDensity=" + this.enableDensity + ", enableLanguage=" + this.enableLanguage + ", enableTexture=" + this.enableTexture + ")";
        }

        public int hashCode() {
            Boolean bl = this.enableAbi;
            Boolean bl2 = this.enableDensity;
            Boolean bl3 = this.enableLanguage;
            Boolean bl4 = this.enableTexture;
            return (((bl != null ? ((Object)bl).hashCode() : 0) * 31 + (bl2 != null ? ((Object)bl2).hashCode() : 0)) * 31 + (bl3 != null ? ((Object)bl3).hashCode() : 0)) * 31 + (bl4 != null ? ((Object)bl4).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleOptions)) break block3;
                    BundleOptions bundleOptions = (BundleOptions)object;
                    if (!Intrinsics.areEqual((Object)this.enableAbi, (Object)bundleOptions.enableAbi) || !Intrinsics.areEqual((Object)this.enableDensity, (Object)bundleOptions.enableDensity) || !Intrinsics.areEqual((Object)this.enableLanguage, (Object)bundleOptions.enableLanguage) || !Intrinsics.areEqual((Object)this.enableTexture, (Object)bundleOptions.enableTexture)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$BundleFlags;", "Ljava/io/Serializable;", "enableUncompressedNativeLibs", "", "(Z)V", "getEnableUncompressedNativeLibs", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class BundleFlags
    implements Serializable {
        private final boolean enableUncompressedNativeLibs;

        @Input
        public final boolean getEnableUncompressedNativeLibs() {
            return this.enableUncompressedNativeLibs;
        }

        public BundleFlags(boolean enableUncompressedNativeLibs) {
            this.enableUncompressedNativeLibs = enableUncompressedNativeLibs;
        }

        public final boolean component1() {
            return this.enableUncompressedNativeLibs;
        }

        @NotNull
        public final BundleFlags copy(boolean enableUncompressedNativeLibs) {
            return new BundleFlags(enableUncompressedNativeLibs);
        }

        public static /* synthetic */ BundleFlags copy$default(BundleFlags bundleFlags, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bundleFlags.enableUncompressedNativeLibs;
            }
            return bundleFlags.copy(bl);
        }

        @NotNull
        public String toString() {
            return "BundleFlags(enableUncompressedNativeLibs=" + this.enableUncompressedNativeLibs + ")";
        }

        public int hashCode() {
            int n = this.enableUncompressedNativeLibs ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleFlags)) break block3;
                    BundleFlags bundleFlags = (BundleFlags)object;
                    if (this.enableUncompressedNativeLibs != bundleFlags.enableUncompressedNativeLibs) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PackageBundleTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PackageBundleTask> {
        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("package", "Bundle");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"package\", \"Bundle\")");
            return string;
        }

        @Override
        @NotNull
        public Class<PackageBundleTask> getType() {
            return PackageBundleTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends PackageBundleTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            StringBuilder stringBuilder = new StringBuilder();
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            StringBuilder stringBuilder2 = stringBuilder.append(globalScope.getProjectBaseName()).append('-');
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            String bundleName = stringBuilder2.append(gradleVariantConfiguration.getBaseName()).append(".aab").toString();
            this.getVariantScope().getArtifacts().producesFile((ArtifactType)InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE, taskProvider, (Function1)PackageBundleTask$CreationAction$handleProvider$1.INSTANCE, bundleName);
        }

        @Override
        public void configure(@NotNull PackageBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            this.getVariantScope().getArtifacts().setTaskInputToFinalProduct((ArtifactType)InternalArtifactType.MODULE_BUNDLE.INSTANCE, (Property)task.getBaseModuleZip());
            FileCollection fileCollection2 = this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MODULE_BUNDLE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"variantScope.getArtifact\u2026DULE_BUNDLE\n            )");
            task.featureZips = fileCollection2;
            if (this.getVariantScope().getArtifacts().hasFinalProduct((ArtifactType)InternalArtifactType.BUNDLE_DEPENDENCY_REPORT.INSTANCE)) {
                this.getVariantScope().getArtifacts().setTaskInputToFinalProduct((ArtifactType)InternalArtifactType.BUNDLE_DEPENDENCY_REPORT.INSTANCE, (Property)task.getBundleDeps());
            }
            if (this.getVariantScope().getArtifacts().hasFinalProduct((ArtifactType)InternalArtifactType.APP_INTEGRITY_CONFIG.INSTANCE)) {
                this.getVariantScope().getArtifacts().setTaskInputToFinalProduct((ArtifactType)InternalArtifactType.APP_INTEGRITY_CONFIG.INSTANCE, (Property)task.getIntegrityConfigFile());
            }
            PackageBundleTask packageBundleTask = task;
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            BaseExtension baseExtension = globalScope.getExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseExtension, (String)"variantScope.globalScope.extension");
            AaptOptions aaptOptions = baseExtension.getAaptOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)aaptOptions, (String)"variantScope.globalScope.extension.aaptOptions");
            Collection collection = aaptOptions.getNoCompress();
            if (collection == null) {
                PackageBundleTask packageBundleTask2 = packageBundleTask;
                boolean bl = false;
                List list = CollectionsKt.emptyList();
                packageBundleTask = packageBundleTask2;
                collection = list;
            }
            packageBundleTask.aaptOptionsNoCompress = collection;
            GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
            BaseExtension baseExtension2 = globalScope2.getExtension();
            if (baseExtension2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.dsl.BaseAppModuleExtension");
            }
            task.bundleOptions = PackageBundleTaskKt.access$convert(((BaseAppModuleExtension)baseExtension2).getBundle());
            GlobalScope globalScope3 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"variantScope.globalScope");
            task.bundleFlags = new BundleFlags(globalScope3.getProjectOptions().get(BooleanOption.ENABLE_UNCOMPRESSED_NATIVE_LIBS_IN_BUNDLE));
            if (this.getVariantScope().getNeedsMainDexListForBundle()) {
                this.getVariantScope().getArtifacts().setTaskInputToFinalProduct((ArtifactType)InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE.INSTANCE, (Property)task.getMainDexList());
            }
            if (this.getVariantScope().getArtifacts().hasFinalProduct((ArtifactType)InternalArtifactType.APK_MAPPING.INSTANCE)) {
                this.getVariantScope().getArtifacts().setTaskInputToFinalProduct((ArtifactType)InternalArtifactType.APK_MAPPING.INSTANCE, (Property)task.getObsfuscationMappingFile());
            }
            GradleVariantConfiguration gradleVariantConfiguration = this.getVariantScope().getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            CoreBuildType coreBuildType = (CoreBuildType)gradleVariantConfiguration.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)coreBuildType, (String)"variantScope.variantConfiguration.buildType");
            task.isDebugBuild = coreBuildType.isDebuggable();
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

