/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.process.ProcessException;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;

public class TestApplicationTestData
extends AbstractTestDataImpl {
    private final Supplier<String> testApplicationId;
    private final Map<String, String> testedProperties;
    private final GradleVariantConfiguration variantConfiguration;

    public TestApplicationTestData(GradleVariantConfiguration variantConfiguration, Supplier<String> testApplicationId, Provider<Directory> testApkDir, FileCollection testedApksDir) {
        super(variantConfiguration, testApkDir, testedApksDir);
        this.variantConfiguration = variantConfiguration;
        this.testedProperties = new HashMap<String, String>();
        this.testApplicationId = testApplicationId;
    }

    public void loadFromMetadataFile(File metadataFile) {
        BuildElements testedManifests = ExistingBuildElements.from((ArtifactType<Directory>)InternalArtifactType.MERGED_MANIFESTS.INSTANCE, metadataFile.getParentFile());
        Optional<BuildOutput> splitOutput = testedManifests.stream().findFirst();
        if (!splitOutput.isPresent()) {
            throw new RuntimeException("No merged manifest metadata at " + metadataFile.getAbsolutePath());
        }
        this.testedProperties.putAll(splitOutput.get().getProperties());
    }

    public String getApplicationId() {
        return this.testApplicationId.get();
    }

    public String getTestedApplicationId() {
        return this.testedProperties.get("packageId");
    }

    public boolean isLibrary() {
        return false;
    }

    public List<File> getTestedApks(DeviceConfigProvider deviceConfigProvider, ILogger logger) throws ProcessException {
        if (this.testedApksDir == null) {
            return ImmutableList.of();
        }
        BuildElements testedApkFiles = ExistingBuildElements.from((ArtifactType<Directory>)InternalArtifactType.APK.INSTANCE, this.testedApksDir);
        return testedApkFiles.stream().map(BuildOutput::getOutputFile).collect(Collectors.toList());
    }
}

