/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class InstantAppOutputScope {
    private static final String PERSISTED_FILE_NAME = "instant-app.json";
    private final String applicationId;
    private final File instantAppBundle;
    private final List<File> apkDirectories;

    public InstantAppOutputScope(String applicationId, File instantAppBundle, List<File> apkDirectories) {
        this.applicationId = applicationId;
        this.instantAppBundle = instantAppBundle;
        this.apkDirectories = apkDirectories;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public File getInstantAppBundle() {
        return this.instantAppBundle;
    }

    public List<File> getApkDirectories() {
        return this.apkDirectories;
    }

    public void save(File outputDirectory) throws IOException {
        File outputFile = new File(outputDirectory, PERSISTED_FILE_NAME);
        Gson gson = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).create();
        FileUtils.write((File)outputFile, (CharSequence)gson.toJson((Object)this));
    }

    public static InstantAppOutputScope load(File directory2) throws IOException {
        File input = new File(directory2, PERSISTED_FILE_NAME);
        if (!input.exists()) {
            return null;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).create();
        try (FileReader fr = new FileReader(input);){
            InstantAppOutputScope instantAppOutputScope = (InstantAppOutputScope)gson.fromJson((Reader)fr, InstantAppOutputScope.class);
            return instantAppOutputScope;
        }
    }
}

