/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.builder.core.ApkInfoParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

public abstract class GenerateApkDataTask
extends NonIncrementalTask {
    private FileCollection apkDirectoryFileCollection;
    private File resOutputDir;
    private File manifestFile;
    private int minSdkVersion;
    private int targetSdkVersion;
    private String aapt2Version;

    @Internal
    public abstract ConfigurableFileCollection getAapt2Executable();

    @Override
    protected void doTaskAction() throws IOException, ProcessException {
        File apkDirectory = null;
        if (this.apkDirectoryFileCollection != null) {
            Set files = this.apkDirectoryFileCollection.getFiles();
            if (files.isEmpty()) {
                return;
            }
            if (files.size() > 1) {
                throw new IllegalStateException("Wear App dependency resolve to more than one file: " + files);
            }
            apkDirectory = (File)Iterables.getOnlyElement((Iterable)files);
            if (!apkDirectory.isDirectory()) {
                throw new IllegalStateException("Wear App dependency does not resolve to a directory: " + files);
            }
        }
        File outDir = this.getResOutputDir();
        FileUtils.cleanOutputDir((File)outDir);
        if (apkDirectory != null) {
            BuildElements apks = ExistingBuildElements.from((ArtifactType<Directory>)InternalArtifactType.APK.INSTANCE, apkDirectory);
            if (apks.isEmpty()) {
                throw new IllegalStateException("Wear App dependency resolve to zero APK");
            }
            if (apks.size() > 1) {
                throw new IllegalStateException("Wear App dependency resolve to more than one APK: " + apks.stream().map(BuildOutput::getOutputFile).collect(Collectors.toList()));
            }
            File apk = ((BuildOutput)Iterables.getOnlyElement((Iterable)apks)).getOutputFile();
            File rawDir = new File(outDir, "raw");
            FileUtils.mkdirs((File)rawDir);
            File to = new File(rawDir, "android_wear_micro_apk.apk");
            Files.copy((File)apk, (File)to);
            this.generateApkData(apk, outDir, (String)this.getMainPkgName().get(), this.getAapt2Executable().getSingleFile());
        } else {
            GenerateApkDataTask.generateUnbundledWearApkData(outDir, (String)this.getMainPkgName().get());
        }
        GenerateApkDataTask.generateApkDataEntryInManifest(this.minSdkVersion, this.targetSdkVersion, this.manifestFile);
    }

    private void generateApkData(File apkFile, File outResFolder, String mainPkgName, File aapt2Executable) throws ProcessException, IOException {
        ApkInfoParser parser = new ApkInfoParser(aapt2Executable, (ProcessExecutor)new GradleProcessExecutor(this.getProject()));
        ApkInfoParser.ApkInfo apkInfo = parser.parseApk(apkFile);
        if (!apkInfo.getPackageName().equals(mainPkgName)) {
            throw new RuntimeException("The main and the micro apps do not have the same package name.");
        }
        String content2 = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<wearableApp package=\"%1$s\">\n    <versionCode>%2$s</versionCode>\n    <versionName>%3$s</versionName>\n    <rawPathResId>%4$s</rawPathResId>\n</wearableApp>", apkInfo.getPackageName(), apkInfo.getVersionCode(), apkInfo.getVersionName(), "android_wear_micro_apk");
        File resXmlFile = new File(outResFolder, "xml");
        FileUtils.mkdirs((File)resXmlFile);
        Files.asCharSink((File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content2);
    }

    private static void generateUnbundledWearApkData(File outResFolder, String mainPkgName) throws IOException {
        String content2 = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<wearableApp package=\"%1$s\">\n    <unbundled />\n</wearableApp>", mainPkgName);
        File resXmlFile = new File(outResFolder, "xml");
        FileUtils.mkdirs((File)resXmlFile);
        Files.asCharSink((File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content2);
    }

    private static void generateApkDataEntryInManifest(int minSdkVersion, int targetSdkVersion, File manifestFile) throws IOException {
        StringBuilder content2 = new StringBuilder();
        content2.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n").append("    package=\"${packageName}\">\n").append("    <uses-sdk android:minSdkVersion=\"").append(minSdkVersion).append("\"");
        if (targetSdkVersion != -1) {
            content2.append(" android:targetSdkVersion=\"").append(targetSdkVersion).append("\"");
        }
        content2.append("/>\n");
        content2.append("    <application>\n").append("        <meta-data android:name=\"com.google.android.wearable.beta.app\"\n").append("                   android:resource=\"@xml/android_wear_micro_apk").append("\" />\n").append("   </application>\n").append("</manifest>\n");
        Files.asCharSink((File)manifestFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content2);
    }

    @OutputDirectory
    public File getResOutputDir() {
        return this.resOutputDir;
    }

    public void setResOutputDir(File resOutputDir) {
        this.resOutputDir = resOutputDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public FileCollection getApkFileCollection() {
        return this.apkDirectoryFileCollection;
    }

    @Input
    public abstract Property<String> getMainPkgName();

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public void setMinSdkVersion(int minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @Input
    public int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    @Input
    public String getAapt2Version() {
        return this.aapt2Version;
    }

    public void setTargetSdkVersion(int targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
    }

    @OutputFile
    public File getManifestFile() {
        return this.manifestFile;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<GenerateApkDataTask> {
        private FileCollection apkFileCollection;

        public CreationAction(VariantScope scope, FileCollection apkFileCollection) {
            super(scope);
            this.apkFileCollection = apkFileCollection;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("handle", "MicroApk");
        }

        @Override
        public Class<GenerateApkDataTask> getType() {
            return GenerateApkDataTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends GenerateApkDataTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setMicroApkTask(taskProvider);
            this.getVariantScope().getTaskContainer().setGenerateApkDataTask(taskProvider);
        }

        @Override
        public void configure(GenerateApkDataTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            ApkVariantData variantData = (ApkVariantData)scope.getVariantData();
            GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
            task.setResOutputDir(scope.getMicroApkResDirectory());
            task.apkDirectoryFileCollection = this.apkFileCollection;
            task.manifestFile = scope.getMicroApkManifestFile();
            task.getMainPkgName().set(scope.getGlobalScope().getProject().provider(variantConfiguration::getApplicationId));
            task.getMainPkgName().disallowChanges();
            task.minSdkVersion = variantConfiguration.getMinSdkVersion().getApiLevel();
            task.targetSdkVersion = variantConfiguration.getTargetSdkVersion().getApiLevel();
            Pair<FileCollection, String> aapt2AndVersion = Aapt2MavenUtils.getAapt2FromMavenAndVersion(scope.getGlobalScope());
            task.getAapt2Executable().from(new Object[]{aapt2AndVersion.getFirst()});
            task.aapt2Version = (String)aapt2AndVersion.getSecond();
        }
    }
}

