/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.VariantOutput;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.internal.api.ApkVariantOutputImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.LibraryVariantOutputImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.api.UnitTestVariantImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.crash.ExternalApiUsageException;
import com.android.build.gradle.internal.dsl.VariantOutputFactory;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import org.gradle.api.model.ObjectFactory;

public class ApiObjectFactory {
    private final BaseExtension extension;
    private final VariantFactory variantFactory;
    private final ObjectFactory objectFactory;
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();

    public ApiObjectFactory(BaseExtension extension, VariantFactory variantFactory, ObjectFactory objectFactory) {
        this.extension = extension;
        this.variantFactory = variantFactory;
        this.objectFactory = objectFactory;
    }

    public BaseVariantImpl create(BaseVariantData variantData) {
        if (variantData.getType().isTestComponent()) {
            this.createVariantOutput(variantData, null);
            return null;
        }
        BaseVariantImpl variantApi = this.variantFactory.createVariantApi(this.objectFactory, variantData, this.readOnlyObjectProvider);
        if (variantApi == null) {
            return null;
        }
        if (this.variantFactory.hasTestScope()) {
            TestVariantData unitTestVariantData;
            TestVariantData androidTestVariantData = ((TestedVariantData)((Object)variantData)).getTestVariantData((VariantType)VariantTypeImpl.ANDROID_TEST);
            if (androidTestVariantData != null) {
                TestVariantImpl androidTestVariant = (TestVariantImpl)this.objectFactory.newInstance(TestVariantImpl.class, new Object[]{androidTestVariantData, variantApi, this.objectFactory, this.readOnlyObjectProvider, variantData.getScope().getGlobalScope().getProject().container(VariantOutput.class)});
                this.createVariantOutput(androidTestVariantData, androidTestVariant);
                ((TestedAndroidConfig)((Object)this.extension)).getTestVariants().add((Object)androidTestVariant);
                ((TestedVariant)((Object)variantApi)).setTestVariant(androidTestVariant);
            }
            if ((unitTestVariantData = ((TestedVariantData)((Object)variantData)).getTestVariantData((VariantType)VariantTypeImpl.UNIT_TEST)) != null) {
                UnitTestVariantImpl unitTestVariant = (UnitTestVariantImpl)this.objectFactory.newInstance(UnitTestVariantImpl.class, new Object[]{unitTestVariantData, variantApi, this.objectFactory, this.readOnlyObjectProvider, variantData.getScope().getGlobalScope().getProject().container(VariantOutput.class)});
                ((TestedAndroidConfig)((Object)this.extension)).getUnitTestVariants().add((Object)unitTestVariant);
                ((TestedVariant)((Object)variantApi)).setUnitTestVariant(unitTestVariant);
            }
        }
        this.createVariantOutput(variantData, variantApi);
        try {
            this.extension.addVariant(variantApi, variantData.getScope());
        }
        catch (Throwable t) {
            throw new ExternalApiUsageException(t);
        }
        return variantApi;
    }

    private void createVariantOutput(BaseVariantData variantData, BaseVariantImpl variantApi) {
        variantData.variantOutputFactory = new VariantOutputFactory(variantData.getType().isAar() ? LibraryVariantOutputImpl.class : ApkVariantOutputImpl.class, this.objectFactory, this.extension, variantApi, variantData.getTaskContainer(), variantData.getScope().getGlobalScope().getDslScope().getDeprecationReporter());
        GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
        variantData.getOutputScope().getApkDatas().forEach(apkData -> {
            VariantOutputImpl variantOutput = variantData.getPublicVariantApi().addVariantOutput((ApkData)apkData);
            apkData.setVariantOutput(variantOutput);
            apkData.setVersionName(config2.getVersionNameSerializableSupplier());
            variantData.variantOutputFactory.create((ApkData)apkData, variantOutput);
        });
    }
}

