/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.gradle.internal.api.ImmutableFlavorList;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import java.util.Collections;
import java.util.List;

public class VariantFilter
implements com.android.build.api.variant.VariantFilter {
    private final ReadOnlyObjectProvider readOnlyObjectProvider;
    private boolean ignore;
    private ProductFlavor defaultConfig;
    private BuildType buildType;
    private List<ProductFlavor> flavors;
    private VariantType type;
    private String name;

    public VariantFilter(ReadOnlyObjectProvider readOnlyObjectProvider) {
        this.readOnlyObjectProvider = readOnlyObjectProvider;
    }

    public void reset(ProductFlavor defaultConfig, BuildType buildType, VariantType type, List<ProductFlavor> flavors) {
        this.ignore = false;
        this.defaultConfig = defaultConfig;
        this.buildType = buildType;
        this.flavors = flavors;
        this.type = type;
        this.name = null;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public ProductFlavor getDefaultConfig() {
        return this.readOnlyObjectProvider.getDefaultConfig(this.defaultConfig);
    }

    public BuildType getBuildType() {
        return this.readOnlyObjectProvider.getBuildType(this.buildType);
    }

    public List<ProductFlavor> getFlavors() {
        return this.flavors != null ? new ImmutableFlavorList(this.flavors, this.readOnlyObjectProvider) : Collections.emptyList();
    }

    public String getName() {
        if (this.name == null) {
            this.name = VariantConfiguration.computeRegularVariantName(VariantConfiguration.computeFlavorName(this.flavors), this.buildType, this.type);
        }
        return this.name;
    }
}

