/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.ide.BuildOutputSupplier;
import com.android.build.gradle.internal.ide.EarlySyncBuildOutput;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BuildOutputsSupplier
implements BuildOutputSupplier<Collection<EarlySyncBuildOutput>> {
    private final List<File> outputFolders;
    private final List<ArtifactType> outputTypes;

    public BuildOutputsSupplier(List<ArtifactType> outputTypes, List<File> outputFolders) {
        this.outputFolders = outputFolders;
        this.outputTypes = outputTypes;
    }

    @Override
    public Collection<EarlySyncBuildOutput> get() {
        ImmutableList.Builder outputs = ImmutableList.builder();
        this.outputFolders.forEach(outputFolder -> {
            if (!outputFolder.exists()) {
                return;
            }
            Collection previous = EarlySyncBuildOutput.load(outputFolder).stream().filter(buildOutput -> this.outputTypes.contains(buildOutput.getType())).collect(Collectors.toList());
            if (previous.isEmpty()) {
                this.outputTypes.forEach(taskOutputType -> {
                    File[] files = outputFolder.listFiles();
                    if (files != null && files.length > 0) {
                        for (File file : files) {
                            BuildOutputsSupplier.processFile(taskOutputType, file, (ImmutableList.Builder<EarlySyncBuildOutput>)outputs);
                        }
                    }
                });
            } else {
                outputs.addAll((Iterable)previous);
            }
        });
        return outputs.build();
    }

    @Override
    public File guessOutputFile(String relativeFileName) {
        return this.outputFolders.isEmpty() ? new File(relativeFileName) : new File(this.outputFolders.get(0), relativeFileName);
    }

    private static void processFile(ArtifactType taskOutputType, File file, ImmutableList.Builder<EarlySyncBuildOutput> outputs) {
        if (taskOutputType == InternalArtifactType.MERGED_MANIFESTS.INSTANCE) {
            if (file.getName().equals("AndroidManifest.xml")) {
                outputs.add((Object)new EarlySyncBuildOutput(taskOutputType, VariantOutput.OutputType.MAIN, (Collection<? extends FilterData>)ImmutableList.of(), 0, file));
            }
        } else {
            outputs.add((Object)new EarlySyncBuildOutput(taskOutputType, VariantOutput.OutputType.MAIN, (Collection<? extends FilterData>)ImmutableList.of(), 0, file));
        }
    }

    public int hashCode() {
        return Objects.hash(this.outputFolders, this.outputTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildOutputsSupplier that = (BuildOutputsSupplier)o;
        return Objects.equals(this.outputFolders, that.outputFolders) && Objects.equals(this.outputTypes, that.outputTypes);
    }
}

