/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.errors.EvalIssueReporter;
import org.gradle.api.Project;

public abstract class BaseVariantFactory
implements VariantFactory {
    protected final GlobalScope globalScope;

    public BaseVariantFactory(GlobalScope globalScope) {
        this.globalScope = globalScope;
    }

    @Override
    public void preVariantWork(Project project2) {
        if (project2.getPluginManager().hasPlugin("com.neenbedankt.android-apt")) {
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.INCOMPATIBLE_PLUGIN, "android-apt plugin is incompatible with the Android Gradle plugin.  Please use 'annotationProcessor' configuration instead.", "android-apt");
        }
    }

    @Override
    public void validateModel(VariantModel model2) {
        if (!this.globalScope.getBuildFeatures().getBuildConfig()) {
            SyncIssueHandler issueReporter = this.globalScope.getErrorHandler();
            if (!model2.getDefaultConfig().getProductFlavor().getBuildConfigFields().isEmpty()) {
                issueReporter.reportError(EvalIssueReporter.Type.GENERIC, "defaultConfig contains custom BuildConfig fields, but the feature is disabled.");
            }
            for (BuildTypeData buildTypeData : model2.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getBuildConfigFields().isEmpty()) continue;
                issueReporter.reportError(EvalIssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom BuildConfig fields, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
                if (productFlavorData.getProductFlavor().getBuildConfigFields().isEmpty()) continue;
                issueReporter.reportError(EvalIssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom BuildConfig fields, but the feature is disabled.", productFlavorData.getProductFlavor().getName()));
            }
        }
    }
}

