/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponents;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.internal.compiler.AidlProcessor;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.builder.internal.incremental.DependencyData;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

@CacheableTask
public abstract class AidlCompile
extends NonIncrementalTask {
    private static final PatternSet PATTERN_SET = new PatternSet().include(new String[]{"**/*.aidl"});
    private Collection<String> packageWhitelist;
    private FileCollection importDirs;
    private String javaEncoding;

    @Internal
    public abstract ListProperty<File> getSourceDirs();

    @Internal
    public abstract Property<File> getAidlExecutableProvider();

    @Internal
    public abstract Property<Revision> getBuildToolsRevisionProvider();

    @Input
    public String getAidlVersion() {
        Revision buildToolsRevision = (Revision)this.getBuildToolsRevisionProvider().getOrNull();
        Preconditions.checkState((buildToolsRevision != null ? 1 : 0) != 0, (Object)"Build Tools not present");
        File aidlExecutable = (File)this.getAidlExecutableProvider().getOrNull();
        Preconditions.checkState((aidlExecutable != null ? 1 : 0) != 0, (Object)("AIDL executable not present in Build Tools " + buildToolsRevision.toString()));
        Preconditions.checkState((boolean)aidlExecutable.exists(), (Object)("AIDL executable does not exist: " + aidlExecutable.getPath()));
        return buildToolsRevision.toString();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract Property<File> getAidlFrameworkProvider();

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract Property<FileTree> getSourceFiles();

    @Override
    protected void doTaskAction() throws IOException {
        File destinationDir = ((Directory)this.getSourceOutputDir().get()).getAsFile();
        Directory parcelableDir = (Directory)this.getPackagedDir().getOrNull();
        FileUtils.cleanOutputDir((File)destinationDir);
        if (parcelableDir != null) {
            FileUtils.cleanOutputDir((File)parcelableDir.getAsFile());
        }
        try (WorkerExecutorFacade workers = this.getWorkerFacadeWithThreads(false);){
            Collection sourceFolders = (Collection)this.getSourceDirs().get();
            Set importFolders2 = this.getImportDirs().getFiles();
            ArrayList fullImportList = Lists.newArrayListWithCapacity((int)(sourceFolders.size() + importFolders2.size()));
            fullImportList.addAll(sourceFolders);
            fullImportList.addAll(importFolders2);
            AidlProcessor processor = new AidlProcessor(((File)this.getAidlExecutableProvider().get()).getAbsolutePath(), ((File)this.getAidlFrameworkProvider().get()).getAbsolutePath(), (Iterable)fullImportList, destinationDir, parcelableDir != null ? parcelableDir.getAsFile() : null, this.packageWhitelist, (DependencyFileProcessor)new DepFileProcessor(), (ProcessExecutor)new GradleProcessExecutor(this.getProject()), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new LoggerWrapper(this.getLogger())), this.javaEncoding);
            for (File dir : sourceFolders) {
                workers.submit(AidlCompileRunnable.class, (Serializable)new AidlCompileParams(dir, processor));
            }
        }
    }

    @OutputDirectory
    public abstract DirectoryProperty getSourceOutputDir();

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getPackagedDir();

    @Input
    @Optional
    public Collection<String> getPackageWhitelist() {
        return this.packageWhitelist;
    }

    public void setPackageWhitelist(Collection<String> packageWhitelist) {
        this.packageWhitelist = packageWhitelist;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getImportDirs() {
        return this.importDirs;
    }

    static class AidlCompileParams
    implements Serializable {
        private final File dir;
        private final AidlProcessor processor;

        AidlCompileParams(File dir, AidlProcessor processor) {
            this.dir = dir;
            this.processor = processor;
        }
    }

    static class AidlCompileRunnable
    implements Runnable {
        private final AidlCompileParams params;

        @Inject
        AidlCompileRunnable(AidlCompileParams params) {
            this.params = params;
        }

        @Override
        public void run() {
            try {
                DirectoryWalker.builder().root(this.params.dir.toPath()).extensions(new String[]{"aidl"}).action((DirectoryWalker.FileAction)this.params.processor).build().walk();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<AidlCompile> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("compile", "Aidl");
        }

        @Override
        public Class<AidlCompile> getType() {
            return AidlCompile.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends AidlCompile> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setAidlCompileTask(taskProvider);
            this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.AIDL_SOURCE_OUTPUT_DIR.INSTANCE, taskProvider, AidlCompile::getSourceOutputDir, "out");
            if (this.getVariantScope().getVariantConfiguration().getType().isAar()) {
                this.getVariantScope().getArtifacts().producesDir(InternalArtifactType.AIDL_PARCELABLE.INSTANCE, taskProvider, AidlCompile::getPackagedDir, "out");
            }
        }

        @Override
        public void configure(AidlCompile compileTask) {
            super.configure(compileTask);
            VariantScope scope = this.getVariantScope();
            GlobalScope globalScope = scope.getGlobalScope();
            Project project2 = globalScope.getProject();
            GradleVariantConfiguration variantConfiguration = scope.getVariantConfiguration();
            SdkComponents sdkComponents = globalScope.getSdkComponents();
            compileTask.getAidlExecutableProvider().set(sdkComponents.getAidlExecutableProvider());
            compileTask.getBuildToolsRevisionProvider().set(sdkComponents.getBuildToolsRevisionProvider());
            compileTask.getAidlFrameworkProvider().set(sdkComponents.getAidlFrameworkProvider());
            compileTask.getSourceDirs().set(project2.provider(variantConfiguration::getAidlSourceList));
            compileTask.getSourceDirs().disallowChanges();
            compileTask.getSourceFiles().set(project2.provider(() -> project2.getLayout().files(new Object[]{compileTask.getSourceDirs()}).getAsFileTree().matching((PatternFilterable)PATTERN_SET)));
            compileTask.getSourceFiles().disallowChanges();
            compileTask.importDirs = scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.AIDL);
            if (variantConfiguration.getType().isAar()) {
                compileTask.setPackageWhitelist(globalScope.getExtension().getAidlPackageWhiteList());
            }
            compileTask.javaEncoding = scope.getGlobalScope().getExtension().getCompileOptions().getEncoding();
        }
    }

    private static class DepFileProcessor
    implements DependencyFileProcessor {
        private DepFileProcessor() {
        }

        public DependencyData processFile(File dependencyFile) throws IOException {
            return DependencyData.parseDependencyFile((File)dependencyFile);
        }
    }
}

