/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.tasks.InstantAppProvisioner;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.instantapp.provision.ProvisionException;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class InstantAppProvisionTask
extends DefaultTask {
    private Provider<File> adbExecutableProvider;

    @TaskAction
    public void provisionDevices() throws ProvisionException, DeviceException, ExecutionException {
        File instantAppSdk = ((Directory)this.getInstantAppSdk().get()).getAsFile();
        if (instantAppSdk == null) {
            throw new GradleException("No Instant App Sdk found.");
        }
        if (!this.adbExecutableProvider.isPresent()) {
            throw new GradleException("No adb file found.");
        }
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider((File)this.adbExecutableProvider.get(), 0, (ILogger)new LoggerWrapper(this.getLogger()));
        InstantAppProvisioner provisioner = new InstantAppProvisioner(instantAppSdk, (DeviceProvider)deviceProvider, this.getLogger());
        provisioner.provisionDevices();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public Provider<File> getAdbExe() {
        return this.adbExecutableProvider;
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getInstantAppSdk();

    public static class CreationAction
    extends TaskCreationAction<InstantAppProvisionTask> {
        private final GlobalScope globalScope;

        public CreationAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        @Override
        public String getName() {
            return "provisionInstantApp";
        }

        @Override
        public Class<InstantAppProvisionTask> getType() {
            return InstantAppProvisionTask.class;
        }

        @Override
        public void configure(InstantAppProvisionTask task) {
            task.setDescription("Provision all connected devices for Instant App.");
            task.adbExecutableProvider = this.globalScope.getSdkComponents().getAdbExecutableProvider();
            task.getInstantAppSdk().set(this.globalScope.getProject().provider(() -> {
                File sdkFolder2 = this.globalScope.getSdkComponents().getSdkDirectory();
                LocalPackage instantAppSdk = AndroidSdkHandler.getInstance((File)sdkFolder2).getLocalPackage("extras;google;instantapps", (ProgressIndicator)new ConsoleProgressIndicator());
                if (instantAppSdk != null) {
                    return (Directory)this.globalScope.getProject().getObjects().directoryProperty().dir(instantAppSdk.getLocation().getAbsolutePath()).get();
                }
                return null;
            }));
            task.getInstantAppSdk().disallowChanges();
        }
    }
}

