/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.VariantOutput;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.resources.Density;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.NamedDomainObjectContainer;

public class ApplicationVariantFactory
extends BaseVariantFactory
implements VariantFactory {
    public ApplicationVariantFactory(GlobalScope globalScope) {
        super(globalScope);
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager, Recorder recorder) {
        ApplicationVariantData variant2 = new ApplicationVariantData(this.globalScope, taskManager, variantConfiguration, recorder);
        this.computeOutputs(variantConfiguration, variant2, true);
        return variant2;
    }

    protected void computeOutputs(GradleVariantConfiguration variantConfiguration, ApplicationVariantData variant2, boolean includeMainApk) {
        BaseExtension extension = this.globalScope.getExtension();
        variant2.calculateFilters(extension.getSplits());
        Set<String> densities = variant2.getFilters(VariantOutput.FilterType.DENSITY);
        Set<String> abis = variant2.getFilters(VariantOutput.FilterType.ABI);
        this.checkSplitsConflicts(variant2, abis);
        if (!densities.isEmpty()) {
            variant2.setCompatibleScreens(extension.getSplits().getDensity().getCompatibleScreens());
        }
        OutputFactory outputFactory = variant2.getOutputFactory();
        this.populateMultiApkOutputs(abis, densities, outputFactory, includeMainApk);
        this.restrictEnabledOutputs(variantConfiguration, variant2.getOutputScope().getApkDatas());
    }

    private void populateMultiApkOutputs(Set<String> abis, Set<String> densities, OutputFactory outputFactory, boolean includeMainApk) {
        boolean universalApkForAbi;
        if (densities.isEmpty() && abis.isEmpty()) {
            if (includeMainApk) {
                outputFactory.addMainApk();
            }
            return;
        }
        boolean bl = universalApkForAbi = this.globalScope.getExtension().getSplits().getAbi().isEnable() && this.globalScope.getExtension().getSplits().getAbi().isUniversalApk();
        if (universalApkForAbi) {
            outputFactory.addUniversalApk();
        } else if (abis.isEmpty() && includeMainApk) {
            outputFactory.addUniversalApk();
        }
        if (!abis.isEmpty()) {
            abis.forEach(abi -> outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi))));
        }
        for (String density : densities) {
            if (!abis.isEmpty()) {
                for (String abi2 : abis) {
                    outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi2), (Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
                }
                continue;
            }
            outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
        }
    }

    private void checkSplitsConflicts(ApplicationVariantData variantData, Set<String> abiFilters) {
        if (abiFilters.isEmpty()) {
            return;
        }
        if (this.globalScope.getExtension().getSplits().getAbi().isUniversalApk()) {
            return;
        }
        Set<String> ndkConfigAbiFilters = ((GradleVariantConfiguration)variantData.getVariantConfiguration()).getNdkConfig().getAbiFilters();
        if (ndkConfigAbiFilters == null || ndkConfigAbiFilters.isEmpty()) {
            return;
        }
        SyncIssueHandler issueReporter = this.globalScope.getErrorHandler();
        issueReporter.reportError(EvalIssueReporter.Type.GENERIC, String.format("Conflicting configuration : '%1$s' in ndk abiFilters cannot be present when splits abi filters are set : %2$s", Joiner.on((String)",").join(ndkConfigAbiFilters), Joiner.on((String)",").join(abiFilters)));
    }

    private void restrictEnabledOutputs(GradleVariantConfiguration configuration2, List<ApkData> apkDataList) {
        String buildTargetAbi;
        Set<String> supportedAbis2 = configuration2.getSupportedAbis();
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        String string = buildTargetAbi = projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) || this.globalScope.getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
        if (buildTargetAbi == null) {
            return;
        }
        String buildTargetDensity = projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY);
        Density density = Density.getEnum((String)buildTargetDensity);
        List apksToGenerate = SplitOutputMatcher.computeBestOutput(apkDataList, supportedAbis2, (int)(density == null ? -1 : density.getDpiValue()), Arrays.asList(Strings.nullToEmpty((String)buildTargetAbi).split(",")));
        if (apksToGenerate.isEmpty()) {
            List splits = apkDataList.stream().map(ApkData::getFilterName).filter(Objects::nonNull).collect(Collectors.toList());
            this.globalScope.getErrorHandler().reportWarning(EvalIssueReporter.Type.GENERIC, String.format("Cannot build selected target ABI: %1$s, " + (splits.isEmpty() ? "no suitable splits configured: %2$s;" : "supported ABIs are: %2$s"), buildTargetAbi, supportedAbis2 == null ? Joiner.on((String)", ").join(splits) : Joiner.on((String)", ").join(supportedAbis2)));
            return;
        }
        apkDataList.forEach(apkData -> {
            if (!apksToGenerate.contains(apkData)) {
                apkData.disable();
            }
        });
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return ApplicationVariantImpl.class;
    }

    @Override
    public Collection<VariantType> getVariantConfigurationTypes() {
        if (this.globalScope.getExtension().getBaseFeature().booleanValue()) {
            return ImmutableList.of((Object)VariantTypeImpl.BASE_APK);
        }
        return ImmutableList.of((Object)VariantTypeImpl.OPTIONAL_APK);
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model2) {
        super.validateModel(model2);
        this.validateVersionCodes(model2);
        if (this.getVariantConfigurationTypes().stream().noneMatch(VariantType::isDynamicFeature)) {
            return;
        }
        SyncIssueHandler issueReporter = this.globalScope.getErrorHandler();
        for (BuildTypeData buildType : model2.getBuildTypes().values()) {
            if (!buildType.getBuildType().isMinifyEnabled()) continue;
            issueReporter.reportError(EvalIssueReporter.Type.GENERIC, "Dynamic feature modules cannot set minifyEnabled to true. minifyEnabled is set to true in build type '" + buildType.getBuildType().getName() + "'.\nTo enable minification for a dynamic feature module, set minifyEnabled to true in the base module.");
        }
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }

    private void validateVersionCodes(VariantModel model2) {
        SyncIssueHandler issueReporter = this.globalScope.getErrorHandler();
        Integer versionCode = model2.getDefaultConfig().getProductFlavor().getVersionCode();
        if (versionCode != null && versionCode < 1) {
            issueReporter.reportError(EvalIssueReporter.Type.GENERIC, "android.defaultConfig.versionCode is set to " + versionCode + ", but it should be a positive integer.\nSee https://developer.android.com/studio/publish/versioning#appversioning for more information.");
            return;
        }
        for (ProductFlavorData<CoreProductFlavor> flavorData : model2.getProductFlavors().values()) {
            Integer flavorVersionCode = flavorData.getProductFlavor().getVersionCode();
            if (flavorVersionCode == null || flavorVersionCode > 0) {
                return;
            }
            issueReporter.reportError(EvalIssueReporter.Type.GENERIC, "versionCode is set to " + flavorVersionCode + " in product flavor " + flavorData.getProductFlavor().getName() + ", but it should be a positive integer.\nSee https://developer.android.com/studio/publish/versioning#appversioning for more information.");
        }
    }
}

