/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;

public abstract class FilterableStreamCollection {
    abstract Project getProject();

    abstract Collection<TransformStream> getStreams();

    public ImmutableList<TransformStream> getStreams(StreamFilter streamFilter) {
        ImmutableList.Builder streamsByType = ImmutableList.builder();
        for (TransformStream s : this.getStreams()) {
            if (!streamFilter.accept(s.getContentTypes(), s.getScopes())) continue;
            streamsByType.add((Object)s);
        }
        return streamsByType.build();
    }

    public FileCollection getPipelineOutputAsFileCollection(StreamFilter streamFilter) {
        return this.getPipelineOutputAsFileCollection(streamFilter, streamFilter);
    }

    public FileCollection getPipelineOutputAsFileCollection(StreamFilter streamFilter, StreamFilter contentFilter) {
        Project project2 = this.getProject();
        ImmutableList<TransformStream> streams = this.getStreams(streamFilter);
        if (streams.isEmpty()) {
            return project2.files(new Object[0]);
        }
        if (streams.size() == 1) {
            return ((TransformStream)streams.get(0)).getOutputFileCollection(project2, contentFilter);
        }
        ConfigurableFileCollection collection = project2.files(new Object[0]);
        for (TransformStream stream : streams) {
            collection.from(new Object[]{stream.getOutputFileCollection(project2, contentFilter)});
        }
        return collection;
    }
}

