/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.utils.FileUtils;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.TaskCollection;

class ReportingPlugin
implements Plugin<Project> {
    private final ObjectFactory objectFactory;
    private TestOptions extension;

    @Inject
    public ReportingPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(Project project2) {
        project2.evaluationDependsOnChildren();
        this.extension = (TestOptions)project2.getExtensions().create("android", TestOptions.class, new Object[]{this.objectFactory});
        AndroidReportTask mergeReportsTask = (AndroidReportTask)project2.getTasks().create("mergeAndroidReports", AndroidReportTask.class);
        mergeReportsTask.setGroup("verification");
        mergeReportsTask.setDescription("Merges all the Android test reports from the sub projects.");
        mergeReportsTask.setReportType(ReportType.MULTI_PROJECT);
        mergeReportsTask.getResultsDir().set(project2.provider(() -> {
            String resultsDir = this.extension.getResultsDir();
            if (resultsDir == null) {
                return (Directory)project2.getLayout().getBuildDirectory().dir("androidTest-results").get();
            }
            return project2.getLayout().getProjectDirectory().dir(resultsDir);
        }));
        mergeReportsTask.getReportsDir().set(project2.provider(() -> {
            String reportsDir = this.extension.getReportDir();
            if (reportsDir == null) {
                return (Directory)project2.getLayout().getBuildDirectory().dir(FileUtils.join((String[])new String[]{"reports", "androidTests"})).get();
            }
            return project2.getLayout().getProjectDirectory().dir(reportsDir);
        }));
        project2.afterEvaluate(prj -> {
            for (Project p : prj.getSubprojects()) {
                TaskCollection tasks = p.getTasks().withType(AndroidReportTask.class);
                for (AndroidReportTask task : tasks) {
                    mergeReportsTask.addTask(task);
                }
                TaskCollection tasks2 = p.getTasks().withType(DeviceProviderInstrumentTestTask.class);
                for (DeviceProviderInstrumentTestTask task : tasks2) {
                    mergeReportsTask.addTask(task);
                }
            }
        });
        if (project2.getGradle().getStartParameter().isContinueOnFailure()) {
            project2.getGradle().getTaskGraph().whenReady(taskExecutionGraph -> {
                if (taskExecutionGraph.hasTask((Task)mergeReportsTask)) {
                    mergeReportsTask.setWillRun();
                }
            });
        }
    }
}

