/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import android.databinding.tool.LayoutXmlProcessor;
import com.android.build.VariantOutput;
import com.android.build.api.variant.VariantConfiguration;
import com.android.build.api.variant.impl.VariantConfigurationImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.dsl.VariantOutputFactory;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskContainer;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.scope.VariantScopeImpl;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.core.VariantType;
import com.android.builder.model.SourceProvider;
import com.android.builder.profile.Recorder;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.SourceFile;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.Sync;

public abstract class BaseVariantData {
    protected final TaskManager taskManager;
    private final VariantDslInfo variantDslInfo;
    private final VariantSources variantSources;
    private VariantDependencies variantDependency;
    protected final VariantScope scope;
    private ImmutableList<ConfigurableFileTree> defaultJavaSources;
    private List<File> extraGeneratedSourceFolders = Lists.newArrayList();
    private List<ConfigurableFileTree> extraGeneratedSourceFileTrees;
    private List<ConfigurableFileTree> externalAptJavaOutputFileTrees;
    private final ConfigurableFileCollection extraGeneratedResFolders;
    private Map<Object, FileCollection> preJavacGeneratedBytecodeMap;
    private FileCollection preJavacGeneratedBytecodeLatest;
    private final ConfigurableFileCollection allPreJavacGeneratedBytecode;
    private final ConfigurableFileCollection allPostJavacGeneratedBytecode;
    private FileCollection rawAndroidResources = null;
    private Set<String> densityFilters;
    private Set<String> languageFilters;
    private Set<String> abiFilters;
    private LayoutXmlProcessor layoutXmlProcessor;
    public boolean outputsAreSigned = false;
    private final OutputFactory outputFactory;
    public VariantOutputFactory variantOutputFactory;
    private final MultiOutputPolicy multiOutputPolicy;
    private final MutableTaskContainer taskContainer;
    public TextResource applicationIdTextResource;
    private final VariantConfiguration publicVariantConfiguration;
    private VariantImpl publicVariantAPI;
    private VariantPropertiesImpl publicVariantPropertiesImpl;

    public BaseVariantData(GlobalScope globalScope, TaskManager taskManager, VariantDslInfo variantDslInfo, VariantSources variantSources, Recorder recorder) {
        this.variantDslInfo = variantDslInfo;
        this.variantSources = variantSources;
        this.taskManager = taskManager;
        Splits splits = globalScope.getExtension().getSplits();
        boolean splitsEnabled = splits.getDensity().isEnable() || splits.getAbi().isEnable() || splits.getLanguage().isEnable();
        this.multiOutputPolicy = MultiOutputPolicy.MULTI_APK;
        if (splitsEnabled && globalScope.getExtension().getGeneratePureSplits()) {
            Logging.getLogger(BaseVariantData.class).warn(String.format("Variant %s requested removed pure splits support, reverted to full splits", variantDslInfo.getFullName()));
        }
        Project project2 = globalScope.getProject();
        this.scope = new VariantScopeImpl(globalScope, new TransformManager(globalScope.getProject(), globalScope.getErrorHandler(), recorder), this);
        this.publicVariantConfiguration = new VariantConfigurationImpl(variantDslInfo.getFullName(), variantDslInfo.getBuildType().getName(), variantDslInfo.getFlavorNamesWithDimensionNames());
        this.outputFactory = new OutputFactory(globalScope.getProjectBaseName(), variantDslInfo);
        TaskManager.configureScopeForNdk(this.scope);
        this.extraGeneratedResFolders = globalScope.getProject().files(new Object[0]);
        this.preJavacGeneratedBytecodeLatest = globalScope.getProject().files(new Object[0]);
        this.allPreJavacGeneratedBytecode = project2.files(new Object[0]);
        this.allPostJavacGeneratedBytecode = project2.files(new Object[0]);
        this.taskContainer = this.scope.getTaskContainer();
        this.applicationIdTextResource = project2.getResources().getText().fromString("");
    }

    abstract VariantImpl<?> instantiatePublicVariantObject(VariantConfiguration var1);

    abstract VariantPropertiesImpl instantiatePublicVariantPropertiesObject(VariantConfiguration var1);

    public LayoutXmlProcessor getLayoutXmlProcessor() {
        if (this.layoutXmlProcessor == null) {
            File resourceBlameLogDir = this.scope.getResourceBlameLogDir();
            MergingLog mergingLog = new MergingLog(resourceBlameLogDir);
            this.layoutXmlProcessor = new LayoutXmlProcessor(this.getVariantDslInfo().getOriginalApplicationId(), this.taskManager.getDataBindingBuilder().createJavaFileWriter(this.scope.getClassOutputForDataBinding()), file -> {
                SourceFile input = new SourceFile(file);
                SourceFile original = mergingLog.find(input);
                return original == input ? null : original.getSourceFile();
            }, this.scope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_ANDROID_X));
        }
        return this.layoutXmlProcessor;
    }

    public synchronized VariantImpl<?> getPublicVariantApi() {
        if (this.publicVariantAPI == null) {
            this.publicVariantAPI = this.instantiatePublicVariantObject(this.publicVariantConfiguration);
        }
        return this.publicVariantAPI;
    }

    public synchronized VariantPropertiesImpl getPublicVariantPropertiesApi() {
        if (this.publicVariantPropertiesImpl == null) {
            this.publicVariantPropertiesImpl = this.instantiatePublicVariantPropertiesObject(this.publicVariantConfiguration);
        }
        return this.publicVariantPropertiesImpl;
    }

    public TaskContainer getTaskContainer() {
        return this.taskContainer;
    }

    public OutputScope getOutputScope() {
        return this.outputFactory.getOutput();
    }

    public OutputFactory getOutputFactory() {
        return this.outputFactory;
    }

    public MultiOutputPolicy getMultiOutputPolicy() {
        return this.multiOutputPolicy;
    }

    public VariantDslInfo getVariantDslInfo() {
        return this.variantDslInfo;
    }

    public VariantSources getVariantSources() {
        return this.variantSources;
    }

    public void setVariantDependency(VariantDependencies variantDependency) {
        this.variantDependency = variantDependency;
    }

    public VariantDependencies getVariantDependency() {
        return this.variantDependency;
    }

    public abstract String getDescription();

    public VariantType getType() {
        return this.variantDslInfo.getVariantType();
    }

    public String getName() {
        return this.variantDslInfo.getFullName();
    }

    public String getTaskName(String prefix, String suffix) {
        return StringHelper.appendCapitalized((String)prefix, (String)this.variantDslInfo.getFullName(), (String)suffix);
    }

    public List<File> getExtraGeneratedSourceFolders() {
        return this.extraGeneratedSourceFolders;
    }

    public FileCollection getExtraGeneratedResFolders() {
        return this.extraGeneratedResFolders;
    }

    public FileCollection getAllPreJavacGeneratedBytecode() {
        return this.allPreJavacGeneratedBytecode;
    }

    public FileCollection getAllPostJavacGeneratedBytecode() {
        return this.allPostJavacGeneratedBytecode;
    }

    public FileCollection getGeneratedBytecode(Object generatorKey) {
        if (generatorKey == null) {
            return this.allPreJavacGeneratedBytecode;
        }
        FileCollection result = this.preJavacGeneratedBytecodeMap.get(generatorKey);
        if (result == null) {
            throw new RuntimeException("Bytecode generator key not found");
        }
        return result;
    }

    public void addJavaSourceFoldersToModel(File generatedSourceFolder) {
        this.extraGeneratedSourceFolders.add(generatedSourceFolder);
    }

    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        Collections.addAll(this.extraGeneratedSourceFolders, generatedSourceFolders);
    }

    public void addJavaSourceFoldersToModel(Collection<File> generatedSourceFolders) {
        this.extraGeneratedSourceFolders.addAll(generatedSourceFolders);
    }

    public void registerJavaGeneratingTask(Task task, File ... generatedSourceFolders) {
        this.registerJavaGeneratingTask(task, Arrays.asList(generatedSourceFolders));
    }

    public void registerJavaGeneratingTask(Task task, Collection<File> generatedSourceFolders) {
        TaskFactoryUtils.dependsOn(this.taskContainer.getSourceGenTask(), task);
        if (this.extraGeneratedSourceFileTrees == null) {
            this.extraGeneratedSourceFileTrees = new ArrayList<ConfigurableFileTree>();
        }
        Project project2 = this.scope.getGlobalScope().getProject();
        for (File f : generatedSourceFolders) {
            ConfigurableFileTree fileTree = project2.fileTree((Object)f).builtBy(new Object[]{task});
            this.extraGeneratedSourceFileTrees.add(fileTree);
        }
        this.addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    public void registerExternalAptJavaOutput(ConfigurableFileTree folder) {
        if (this.externalAptJavaOutputFileTrees == null) {
            this.externalAptJavaOutputFileTrees = new ArrayList<ConfigurableFileTree>();
        }
        this.externalAptJavaOutputFileTrees.add(folder);
        this.addJavaSourceFoldersToModel(folder.getDir());
    }

    public void registerGeneratedResFolders(FileCollection folders) {
        this.extraGeneratedResFolders.from(new Object[]{folders});
    }

    @Deprecated
    public void registerResGeneratingTask(Task task, File ... generatedResFolders) {
        this.registerResGeneratingTask(task, Arrays.asList(generatedResFolders));
    }

    @Deprecated
    public void registerResGeneratingTask(Task task, Collection<File> generatedResFolders) {
        System.out.println("registerResGeneratingTask is deprecated, use registerGeneratedResFolders(FileCollection)");
        Project project2 = this.scope.getGlobalScope().getProject();
        this.registerGeneratedResFolders((FileCollection)project2.files(new Object[]{generatedResFolders}).builtBy(new Object[]{task}));
    }

    public Object registerPreJavacGeneratedBytecode(FileCollection fileCollection2) {
        if (this.preJavacGeneratedBytecodeMap == null) {
            this.preJavacGeneratedBytecodeMap = Maps.newHashMap();
        }
        Object key = new Object();
        this.preJavacGeneratedBytecodeMap.put(key, this.preJavacGeneratedBytecodeLatest);
        this.preJavacGeneratedBytecodeLatest = this.preJavacGeneratedBytecodeLatest.plus(fileCollection2);
        this.allPreJavacGeneratedBytecode.from(new Object[]{fileCollection2});
        return key;
    }

    public void registerPostJavacGeneratedBytecode(FileCollection fileCollection2) {
        this.allPostJavacGeneratedBytecode.from(new Object[]{fileCollection2});
    }

    public void calculateFilters(Splits splits) {
        this.densityFilters = BaseVariantData.getFilters(DiscoverableFilterType.DENSITY, splits);
        this.languageFilters = BaseVariantData.getFilters(DiscoverableFilterType.LANGUAGE, splits);
        this.abiFilters = BaseVariantData.getFilters(DiscoverableFilterType.ABI, splits);
    }

    public Set<String> getFilters(VariantOutput.FilterType filterType2) {
        if (this.densityFilters == null || this.languageFilters == null || this.abiFilters == null) {
            throw new IllegalStateException("calculateFilters method not called");
        }
        switch (filterType2) {
            case DENSITY: {
                return this.densityFilters;
            }
            case LANGUAGE: {
                return this.languageFilters;
            }
            case ABI: {
                return this.abiFilters;
            }
        }
        throw new RuntimeException("Unhandled filter type");
    }

    public FileCollection getAllRawAndroidResources() {
        if (this.rawAndroidResources == null) {
            Project project2 = this.scope.getGlobalScope().getProject();
            Iterator builtBy = Lists.newArrayList((Object[])new Object[]{this.taskContainer.getRenderscriptCompileTask(), this.taskContainer.getGenerateResValuesTask(), this.taskContainer.getGenerateApkDataTask(), this.extraGeneratedResFolders.getBuiltBy()}).stream().filter(Objects::nonNull).iterator();
            ConfigurableFileCollection allRes = project2.files(new Object[0]).builtBy(new Object[]{builtBy});
            FileCollection libraries = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_RES).getArtifactFiles();
            allRes = allRes.plus(libraries);
            Iterator<FileCollection> sourceSets = this.getAndroidResources().values().iterator();
            FileCollection mainSourceSet = sourceSets.next();
            ConfigurableFileCollection generated = project2.files(new Object[]{this.scope.getRenderscriptResOutputDir(), this.scope.getGeneratedResOutputDir(), this.scope.getMicroApkResDirectory(), this.extraGeneratedResFolders});
            allRes = allRes.plus(mainSourceSet.plus((FileCollection)generated));
            while (sourceSets.hasNext()) {
                allRes = allRes.plus(sourceSets.next());
            }
            this.rawAndroidResources = allRes;
        }
        return this.rawAndroidResources;
    }

    private static Set<String> getFilters(DiscoverableFilterType filterType2, Splits splits) {
        return new HashSet<String>(filterType2.getConfiguredFilters(splits));
    }

    public List<ConfigurableFileTree> getJavaSources() {
        if (this.extraGeneratedSourceFileTrees == null && this.externalAptJavaOutputFileTrees == null) {
            return this.getDefaultJavaSources();
        }
        ImmutableList.Builder sourceSets = ImmutableList.builder();
        sourceSets.addAll(this.getDefaultJavaSources());
        if (this.extraGeneratedSourceFileTrees != null) {
            sourceSets.addAll(this.extraGeneratedSourceFileTrees);
        }
        if (this.externalAptJavaOutputFileTrees != null) {
            sourceSets.addAll(this.externalAptJavaOutputFileTrees);
        }
        return sourceSets.build();
    }

    public LinkedHashMap<String, FileCollection> getAndroidResources() {
        return this.variantSources.getSortedSourceProviders().stream().collect(Collectors.toMap(SourceProvider::getName, provider -> ((AndroidSourceSet)provider).getRes().getBuildableArtifact(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    private List<ConfigurableFileTree> getDefaultJavaSources() {
        if (this.defaultJavaSources == null) {
            BuildFeatureValues features;
            Provider rClassSource;
            Project project2 = this.scope.getGlobalScope().getProject();
            ImmutableList.Builder sourceSets = ImmutableList.builder();
            List<SourceProvider> providers = this.variantSources.getSortedSourceProviders();
            for (SourceProvider provider : providers) {
                sourceSets.addAll(((AndroidSourceSet)provider).getJava().getSourceDirectoryTrees());
            }
            if (this.scope.getGlobalScope().getProjectOptions().get(BooleanOption.GENERATE_R_JAVA) && (rClassSource = this.scope.getArtifacts().getFinalProduct(InternalArtifactType.NOT_NAMESPACED_R_CLASS_SOURCES.INSTANCE)).isPresent()) {
                sourceSets.add((Object)project2.fileTree(rClassSource).builtBy(new Object[]{rClassSource}));
            }
            if (this.taskContainer.getGenerateBuildConfigTask() != null) {
                sourceSets.add((Object)project2.fileTree((Object)this.scope.getBuildConfigSourceOutputDir()).builtBy(new Object[]{this.taskContainer.getGenerateBuildConfigTask().getName()}));
            }
            if (this.taskContainer.getAidlCompileTask() != null) {
                Provider aidlFC = this.scope.getArtifacts().getFinalProduct(InternalArtifactType.AIDL_SOURCE_OUTPUT_DIR.INSTANCE);
                sourceSets.add((Object)project2.fileTree(aidlFC).builtBy(new Object[]{aidlFC}));
            }
            if ((features = this.scope.getGlobalScope().getBuildFeatures()).getDataBinding() || features.getViewBinding()) {
                if (this.scope.getTaskContainer().getDataBindingExportBuildInfoTask() != null) {
                    sourceSets.add((Object)project2.fileTree((Object)this.scope.getClassOutputForDataBinding()).builtBy(new Object[]{this.scope.getTaskContainer().getDataBindingExportBuildInfoTask()}));
                }
                if (this.scope.getArtifacts().hasFinalProduct(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT.INSTANCE)) {
                    Provider baseClassSource = this.scope.getArtifacts().getFinalProduct(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT.INSTANCE);
                    sourceSets.add((Object)project2.fileTree(baseClassSource).builtBy(new Object[]{baseClassSource}));
                }
            }
            if (!this.variantDslInfo.getRenderscriptNdkModeEnabled() && this.taskContainer.getRenderscriptCompileTask() != null) {
                Provider rsFC = this.scope.getArtifacts().getFinalProduct(InternalArtifactType.RENDERSCRIPT_SOURCE_OUTPUT_DIR.INSTANCE);
                sourceSets.add((Object)project2.fileTree(rsFC).builtBy(new Object[]{rsFC}));
            }
            this.defaultJavaSources = sourceSets.build();
        }
        return this.defaultJavaSources;
    }

    public FileCollection getJavaSourceFoldersForCoverage() {
        ConfigurableFileCollection fc = this.scope.getGlobalScope().getProject().files(new Object[0]);
        List<SourceProvider> providers = this.variantSources.getSortedSourceProviders();
        for (SourceProvider provider : providers) {
            for (File sourceFolder : provider.getJavaDirectories()) {
                if (!sourceFolder.isDirectory()) continue;
                fc.from(new Object[]{sourceFolder});
            }
        }
        fc.from(new Object[]{this.scope.getArtifacts().getFinalProduct(InternalArtifactType.AIDL_SOURCE_OUTPUT_DIR.INSTANCE)});
        if (!this.variantDslInfo.getRenderscriptNdkModeEnabled()) {
            fc.from(new Object[]{this.scope.getArtifacts().getFinalProduct(InternalArtifactType.RENDERSCRIPT_SOURCE_OUTPUT_DIR.INSTANCE)});
        }
        return fc;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.variantDslInfo.getFullName()).toString();
    }

    public VariantScope getScope() {
        return this.scope;
    }

    public File getJavaResourcesForUnitTesting() {
        Sync processJavaResourcesTask = (Sync)this.taskContainer.getProcessJavaResourcesTask().get();
        if (processJavaResourcesTask != null) {
            return processJavaResourcesTask.getOutputs().getFiles().getSingleFile();
        }
        return ((Directory)this.scope.getArtifacts().getFinalProduct(InternalArtifactType.JAVA_RES.INSTANCE).get()).getAsFile();
    }

    private static enum DiscoverableFilterType {
        DENSITY{

            @Override
            Collection<String> getConfiguredFilters(Splits splits) {
                return splits.getDensityFilters();
            }
        }
        ,
        LANGUAGE{

            @Override
            Collection<String> getConfiguredFilters(Splits splits) {
                return splits.getLanguageFilters();
            }
        }
        ,
        ABI{

            @Override
            Collection<String> getConfiguredFilters(Splits splits) {
                return splits.getAbiFilters();
            }
        };


        abstract Collection<String> getConfiguredFilters(Splits var1);
    }
}

