/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.level2.DependencyGraphs;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.file.RegularFile;

abstract class BaseArtifactImpl
implements BaseArtifact,
Serializable {
    private static final String NO_MODEL_FILE = "";
    private final Collection<File> generatedSourceFolders;
    private final String name;
    private final String assembleTaskName;
    private final String assembleTaskOutputListingFile;
    private final String compileTaskName;
    private final File classesFolder;
    private final File javaResourcesFolder;
    private final Dependencies compileDependencies;
    private final DependencyGraphs dependencyGraphs;
    private final Set<File> additionalClassesFolders;
    private final SourceProvider variantSourceProvider;
    private final SourceProvider multiFlavorSourceProviders;

    BaseArtifactImpl(String name2, String assembleTaskName, RegularFile assembleTaskOutputListingFile, String compileTaskName, File classesFolder, Set<File> additionalClassesFolders, File javaResourcesFolder, Dependencies compileDependencies2, DependencyGraphs dependencyGraphs, SourceProvider variantSourceProvider, SourceProvider multiFlavorSourceProviders, Collection<File> generatedSourceFolders) {
        this.name = name2;
        this.assembleTaskName = assembleTaskName;
        this.assembleTaskOutputListingFile = assembleTaskOutputListingFile != null ? assembleTaskOutputListingFile.getAsFile().getAbsolutePath() : NO_MODEL_FILE;
        this.compileTaskName = compileTaskName;
        this.classesFolder = classesFolder;
        this.additionalClassesFolders = additionalClassesFolders;
        this.javaResourcesFolder = javaResourcesFolder;
        this.compileDependencies = compileDependencies2;
        this.dependencyGraphs = dependencyGraphs;
        this.variantSourceProvider = variantSourceProvider;
        this.multiFlavorSourceProviders = multiFlavorSourceProviders;
        this.generatedSourceFolders = generatedSourceFolders;
    }

    public String getName() {
        return this.name;
    }

    public String getCompileTaskName() {
        return this.compileTaskName;
    }

    public String getAssembleTaskName() {
        return this.assembleTaskName;
    }

    public String getAssembleTaskOutputListingFile() {
        return this.assembleTaskOutputListingFile;
    }

    public File getClassesFolder() {
        return this.classesFolder;
    }

    public File getJavaResourcesFolder() {
        return this.javaResourcesFolder;
    }

    public Dependencies getDependencies() {
        return this.compileDependencies;
    }

    public Dependencies getCompileDependencies() {
        return this.getDependencies();
    }

    public DependencyGraphs getDependencyGraphs() {
        return this.dependencyGraphs;
    }

    public SourceProvider getVariantSourceProvider() {
        return this.variantSourceProvider;
    }

    public SourceProvider getMultiFlavorSourceProvider() {
        return this.multiFlavorSourceProviders;
    }

    public Collection<File> getGeneratedSourceFolders() {
        return this.generatedSourceFolders;
    }

    public Set<File> getAdditionalClassesFolders() {
        return this.additionalClassesFolders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseArtifactImpl that = (BaseArtifactImpl)o;
        return Objects.equals(this.generatedSourceFolders, that.generatedSourceFolders) && Objects.equals(this.name, that.name) && Objects.equals(this.assembleTaskName, that.assembleTaskName) && Objects.equals(this.assembleTaskOutputListingFile, that.assembleTaskOutputListingFile) && Objects.equals(this.compileTaskName, that.compileTaskName) && Objects.equals(this.classesFolder, that.classesFolder) && Objects.equals(this.additionalClassesFolders, that.additionalClassesFolders) && Objects.equals(this.javaResourcesFolder, that.javaResourcesFolder) && Objects.equals(this.compileDependencies, that.compileDependencies) && Objects.equals(this.dependencyGraphs, that.dependencyGraphs) && Objects.equals(this.variantSourceProvider, that.variantSourceProvider) && Objects.equals(this.multiFlavorSourceProviders, that.multiFlavorSourceProviders);
    }

    public int hashCode() {
        return Objects.hash(this.generatedSourceFolders, this.name, this.assembleTaskName, this.assembleTaskOutputListingFile, this.compileTaskName, this.classesFolder, this.additionalClassesFolders, this.javaResourcesFolder, this.compileDependencies, this.dependencyGraphs, this.variantSourceProvider, this.multiFlavorSourceProviders);
    }
}

