/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.dependency.RenamedConfigurationAction;
import com.android.build.gradle.internal.dsl.AndroidSourceSetFactory;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.DelayedActionsExecutor;
import com.android.builder.errors.IssueReporter;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001a\u0010!\u001a\u00020\u00182\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130#J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0002J \u0010&\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0006\u0010(\u001a\u00020\u0018J\u001a\u0010)\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u0005H\u0007J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "", "project", "Lorg/gradle/api/Project;", "publishPackage", "", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "buildArtifactActions", "Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;", "(Lorg/gradle/api/Project;ZLcom/android/build/gradle/internal/api/dsl/DslScope;Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;)V", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "configuredSourceSets", "", "", "logger", "Lorg/gradle/api/logging/Logger;", "sourceSetsContainer", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "getSourceSetsContainer", "()Lorg/gradle/api/NamedDomainObjectContainer;", "checkForUnconfiguredSourceSets", "", "createConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "name", "description", "canBeResolved", "createConfigurationsForSourceSet", "sourceSet", "isTestComponent", "executeAction", "action", "Lorg/gradle/api/Action;", "getConfigDesc", "sourceSetName", "getDeprecatedConfigDesc", "replacement", "runBuildableArtifactsActions", "setUpSourceSet", "setUpTestSourceSet", "gradle"})
public final class SourceSetManager {
    @NotNull
    private final NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer;
    private final ConfigurationContainer configurations;
    private final Logger logger;
    private final Set<String> configuredSourceSets;
    private final boolean publishPackage;
    private final DslScope dslScope;
    private final DelayedActionsExecutor buildArtifactActions;

    @NotNull
    public final NamedDomainObjectContainer<AndroidSourceSet> getSourceSetsContainer() {
        return this.sourceSetsContainer;
    }

    @NotNull
    public final AndroidSourceSet setUpTestSourceSet(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return this.setUpSourceSet(name2, true);
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name2, boolean isTestComponent) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        AndroidSourceSet sourceSet = (AndroidSourceSet)this.sourceSetsContainer.maybeCreate(name2);
        if (!this.configuredSourceSets.contains(name2)) {
            AndroidSourceSet androidSourceSet = sourceSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
            this.createConfigurationsForSourceSet(androidSourceSet, isTestComponent);
            this.configuredSourceSets.add(name2);
        }
        AndroidSourceSet androidSourceSet = sourceSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
        return androidSourceSet;
    }

    public static /* synthetic */ AndroidSourceSet setUpSourceSet$default(SourceSetManager sourceSetManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sourceSetManager.setUpSourceSet(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name2) {
        return SourceSetManager.setUpSourceSet$default(this, name2, false, 2, null);
    }

    private final void createConfigurationsForSourceSet(AndroidSourceSet sourceSet, boolean isTestComponent) {
        String string;
        String string2 = sourceSet.getApiConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sourceSet.apiConfigurationName");
        String apiName = string2;
        String string3 = sourceSet.getImplementationConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sourceSet.implementationConfigurationName");
        String implementationName = string3;
        String string4 = sourceSet.getRuntimeOnlyConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sourceSet.runtimeOnlyConfigurationName");
        String runtimeOnlyName = string4;
        String string5 = sourceSet.getCompileOnlyConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sourceSet.compileOnlyConfigurationName");
        String compileOnlyName = string5;
        String string6 = sourceSet.getCompileConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"sourceSet.compileConfigurationName");
        String compileName = string6;
        String string7 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"sourceSet.name");
        Configuration compile2 = this.createConfiguration(compileName, this.getDeprecatedConfigDesc("Compile", string7, implementationName), Intrinsics.areEqual((Object)"compile", (Object)compileName) || Intrinsics.areEqual((Object)"testCompile", (Object)compileName));
        compile2.getDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(isTestComponent ? implementationName : implementationName + "' and '" + apiName, compileName, this.dslScope.getDeprecationReporter(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        String packageConfigDescription = null;
        if (this.publishPackage) {
            String string8 = sourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"sourceSet.name");
            string = this.getDeprecatedConfigDesc("Publish", string8, runtimeOnlyName);
        } else {
            String string9 = sourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"sourceSet.name");
            string = this.getDeprecatedConfigDesc("Apk", string9, runtimeOnlyName);
        }
        packageConfigDescription = string;
        String string10 = sourceSet.getPackageConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"sourceSet.packageConfigurationName");
        String apkName = string10;
        Configuration apk = SourceSetManager.createConfiguration$default(this, apkName, packageConfigDescription, false, 4, null);
        apk.getDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(runtimeOnlyName, apkName, this.dslScope.getDeprecationReporter(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        String string11 = sourceSet.getProvidedConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"sourceSet.providedConfigurationName");
        String providedName = string11;
        String string12 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"sourceSet.name");
        Configuration provided = SourceSetManager.createConfiguration$default(this, providedName, this.getDeprecatedConfigDesc("Provided", string12, compileOnlyName), false, 4, null);
        provided.getDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(compileOnlyName, providedName, this.dslScope.getDeprecationReporter(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        String string13 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"sourceSet.name");
        Configuration api = SourceSetManager.createConfiguration$default(this, apiName, this.getConfigDesc("API", string13), false, 4, null);
        api.extendsFrom(new Configuration[]{compile2});
        if (isTestComponent) {
            api.getDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(implementationName, apiName, this.dslScope.getDeprecationReporter(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        }
        String string14 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"sourceSet.name");
        Configuration implementation = SourceSetManager.createConfiguration$default(this, implementationName, this.getConfigDesc("Implementation only", string14), false, 4, null);
        implementation.extendsFrom(new Configuration[]{api});
        String string15 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"sourceSet.name");
        Configuration runtimeOnly = SourceSetManager.createConfiguration$default(this, runtimeOnlyName, this.getConfigDesc("Runtime only", string15), false, 4, null);
        runtimeOnly.extendsFrom(new Configuration[]{apk});
        String string16 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"sourceSet.name");
        Configuration compileOnly = SourceSetManager.createConfiguration$default(this, compileOnlyName, this.getConfigDesc("Compile only", string16), false, 4, null);
        compileOnly.extendsFrom(new Configuration[]{provided});
        String string17 = sourceSet.getWearAppConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"sourceSet.wearAppConfigurationName");
        Configuration wearConfig = SourceSetManager.createConfiguration$default(this, string17, "Link to a wear app to embed for object '" + sourceSet.getName() + "'.", false, 4, null);
        String string18 = sourceSet.getAnnotationProcessorConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"sourceSet.annotationProcessorConfigurationName");
        SourceSetManager.createConfiguration$default(this, string18, "Classpath for the annotation processor for '" + sourceSet.getName() + "'.", false, 4, null);
    }

    private final Configuration createConfiguration(String name2, String description, boolean canBeResolved) {
        Configuration configuration2;
        this.logger.info("Creating configuration {}", (Object)name2);
        Configuration configuration3 = configuration2 = (Configuration)this.configurations.maybeCreate(name2);
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
        configuration3.setVisible(false);
        configuration2.setDescription(description);
        configuration2.setCanBeConsumed(false);
        configuration2.setCanBeResolved(canBeResolved);
        return configuration2;
    }

    static /* synthetic */ Configuration createConfiguration$default(SourceSetManager sourceSetManager, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return sourceSetManager.createConfiguration(string, string2, bl);
    }

    private final String getConfigDesc(String name2, String sourceSetName) {
        return name2 + " dependencies for '" + sourceSetName + "' sources.";
    }

    private final String getDeprecatedConfigDesc(String name2, String sourceSetName, String replacement) {
        return name2 + " dependencies for '" + sourceSetName + "' sources " + "(deprecated: use '" + replacement + "' instead).";
    }

    public final void checkForUnconfiguredSourceSets() {
        Iterable $this$forEach$iv = (Iterable)this.sourceSetsContainer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidSourceSet sourceSet = (AndroidSourceSet)element$iv;
            boolean bl = false;
            AndroidSourceSet androidSourceSet = sourceSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
            if (this.configuredSourceSets.contains(androidSourceSet.getName())) continue;
            String message = "The SourceSet '" + sourceSet.getName() + "' is not recognized " + "by the Android Gradle Plugin. Perhaps you misspelled something?";
            IssueReporter.reportError$default((IssueReporter)this.dslScope.getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message, null, null, (int)12, null);
        }
    }

    public final void executeAction(@NotNull Action<NamedDomainObjectContainer<AndroidSourceSet>> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        action.execute(this.sourceSetsContainer);
    }

    public final void runBuildableArtifactsActions() {
        this.buildArtifactActions.runAll();
    }

    public SourceSetManager(@NotNull Project project2, boolean publishPackage, @NotNull DslScope dslScope, @NotNull DelayedActionsExecutor buildArtifactActions) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        Intrinsics.checkParameterIsNotNull((Object)buildArtifactActions, (String)"buildArtifactActions");
        this.publishPackage = publishPackage;
        this.dslScope = dslScope;
        this.buildArtifactActions = buildArtifactActions;
        NamedDomainObjectContainer namedDomainObjectContainer = project2.container(AndroidSourceSet.class, (NamedDomainObjectFactory)new AndroidSourceSetFactory(project2, this.publishPackage, this.dslScope));
        Intrinsics.checkExpressionValueIsNotNull((Object)namedDomainObjectContainer, (String)"project.container(\n     \u2026ublishPackage, dslScope))");
        this.sourceSetsContainer = namedDomainObjectContainer;
        ConfigurationContainer configurationContainer = project2.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.configurations");
        this.configurations = configurationContainer;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(this.javaClass)");
        this.logger = logger;
        SourceSetManager sourceSetManager = this;
        boolean bl = false;
        sourceSetManager.configuredSourceSets = set = (Set)new LinkedHashSet();
    }
}

