/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.errors.EvalIssueException;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class MergeConsumerProguardFilesTask
extends MergeFileTask {
    private boolean isDynamicFeature;
    private boolean isBaseModule;

    @Input
    public boolean getIsDynamicFeature() {
        return this.isDynamicFeature;
    }

    @Input
    public boolean getIsBaseModule() {
        return this.isBaseModule;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getConsumerProguardFiles();

    @Override
    public void doTaskAction() throws IOException {
        Project project2 = this.getProject();
        if (!this.isBaseModule) {
            ExportConsumerProguardFilesTask.checkProguardFiles(project2, this.isDynamicFeature, this.getConsumerProguardFiles().getFiles(), errorMessage -> {
                throw new EvalIssueException(errorMessage);
            });
        }
        super.doTaskAction();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<MergeConsumerProguardFilesTask> {
        public CreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("merge", "ConsumerProguardFiles");
        }

        @Override
        public Class<MergeConsumerProguardFilesTask> getType() {
            return MergeConsumerProguardFilesTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends MergeConsumerProguardFilesTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesFile(InternalArtifactType.MERGED_CONSUMER_PROGUARD_FILE.INSTANCE, taskProvider, MergeFileTask::getOutputFile, "proguard.txt");
        }

        @Override
        public void configure(MergeConsumerProguardFilesTask task) {
            super.configure(task);
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Project project2 = globalScope.getProject();
            task.isBaseModule = this.getVariantScope().getType().isBaseModule();
            task.isDynamicFeature = this.getVariantScope().getType().isDynamicFeature();
            task.getConsumerProguardFiles().from(new Object[]{this.getVariantScope().getConsumerProguardFilesForFeatures()});
            ConfigurableFileCollection inputFiles2 = project2.files(new Object[]{task.getConsumerProguardFiles(), this.getVariantScope().getArtifacts().getFinalProduct(InternalArtifactType.GENERATED_PROGUARD_FILE.INSTANCE)});
            task.setInputFiles((FileCollection)inputFiles2);
        }
    }
}

