/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.internal.scope.DefaultApkData;
import com.android.build.gradle.internal.scope.GradleAwareFilterData;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public abstract class ApkData
implements VariantOutput,
Comparable<ApkData>,
Serializable {
    private static final Comparator<ApkData> COMPARATOR = Comparator.nullsLast(Comparator.comparing(ApkData::getType).thenComparingInt(ApkData::getVersionCode).thenComparing(ApkData::getOutputFileName, Comparator.nullsLast(String::compareTo)).thenComparing(ApkData::getVersionName, Comparator.nullsLast(String::compareTo)));
    public transient com.android.build.api.variant.VariantOutput variantOutput;
    private Integer versionCode = 0;
    private String versionName = null;
    private String outputFileName;

    public static ApkData of(VariantOutput.OutputType outputType, Collection<FilterData> filters, int versionCode) {
        return ApkData.of(outputType, filters, versionCode, null, null, null, "", "", "");
    }

    public static ApkData of(VariantOutput.OutputType outputType, Collection<FilterData> filters, int versionCode, String versionName, String filterName, String outputFileName, String fullName, String baseName2, String dirName2) {
        return new DefaultApkData(outputType, filters, versionCode, versionName, filterName, outputFileName, fullName, baseName2, dirName2);
    }

    @Nested
    public Collection<GradleAwareFilterData> getFiltersForGradle() {
        return this.getFilters().stream().map(it -> (GradleAwareFilterData)it).collect(Collectors.toCollection(ArrayList::new));
    }

    @Internal
    public Collection<FilterData> getFilters() {
        return ImmutableList.of();
    }

    @Input
    public Collection<String> getFilterTypes() {
        return this.getFilters().stream().map(FilterData::getFilterType).collect(Collectors.toList());
    }

    public FilterData getFilter(VariantOutput.FilterType filterType2) {
        for (FilterData filter2 : this.getFilters()) {
            if (VariantOutput.FilterType.valueOf((String)filter2.getFilterType()) != filterType2) continue;
            return filter2;
        }
        return null;
    }

    public String getFilter(String filterType2) {
        return ApkData.getFilter(this.getFilters(), VariantOutput.FilterType.valueOf((String)filterType2));
    }

    public boolean requiresAapt() {
        return true;
    }

    @Input
    public abstract String getBaseName();

    @Input
    public abstract String getFullName();

    @Input
    public abstract VariantOutput.OutputType getType();

    @Input
    public boolean isUniversal() {
        return false;
    }

    @Input
    public abstract String getDirName();

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    @Internal
    public int getVersionCode() {
        if (this.variantOutput != null) {
            return (Integer)this.variantOutput.getVersionCode().get();
        }
        return this.versionCode;
    }

    @Input
    @Optional
    public String getVersionName() {
        if (this.variantOutput != null) {
            return (String)this.variantOutput.getVersionName().getOrNull();
        }
        return this.versionName;
    }

    @Input
    @Optional
    public String getOutputFileName() {
        return this.outputFileName;
    }

    @Internal
    public OutputFile getMainOutputFile() {
        throw new UnsupportedOperationException("getMainOutputFile is no longer supported.  Use getOutputFileName if you need to determine the file name of the output.");
    }

    @Internal
    public Collection<? extends OutputFile> getOutputs() {
        throw new UnsupportedOperationException("getOutputs is no longer supported.  Use getOutputFileName if you need to determine the file name of the output.");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("fullName", (Object)this.getFullName()).add("filters", this.getFilters()).add("versionCode", this.getVersionCode()).add("versionName", (Object)this.getVersionName()).toString();
    }

    @Input
    public String getOutputType() {
        return this.getType().name();
    }

    public static String getFilter(Collection<FilterData> filters, VariantOutput.FilterType filterType2) {
        for (FilterData filter2 : filters) {
            if (VariantOutput.FilterType.valueOf((String)filter2.getFilterType()) != filterType2) continue;
            return filter2.getIdentifier();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApkData that = (ApkData)o;
        return this.getVersionCode() == that.getVersionCode() && Objects.equals(this.outputFileName, that.outputFileName) && Objects.equals(this.getVersionName(), that.getVersionName());
    }

    public int hashCode() {
        return Objects.hash(this.getVersionCode(), this.getVersionName(), this.outputFileName);
    }

    @Override
    public int compareTo(ApkData other) {
        return COMPARATOR.compare(this, other);
    }

    @Optional
    @Input
    public abstract String getFilterName();

    public void setVariantOutput(VariantOutputImpl variantOutput) {
        this.variantOutput = variantOutput;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.versionCode = this.getVersionCode();
        this.versionName = this.getVersionName();
        out.defaultWriteObject();
    }
}

