/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.BuiltArtifacts;
import com.android.build.api.variant.FilterConfiguration;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.resources.Density;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\tJ \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J2\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/test/SplitOutputMatcher;", "", "()V", "computeBestOutput", "", "Ljava/io/File;", "outputs", "Lcom/android/build/api/variant/BuiltArtifacts;", "variantAbiFilters", "", "", "deviceDensity", "", "deviceAbis", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "builtArtifacts", "getAbiPreferenceOrder", "builtArtifact", "Lcom/android/build/api/variant/BuiltArtifact;", "deviceAbi", "getFilter", "variantOutput", "filterType", "Lcom/android/build/api/variant/FilterConfiguration$FilterType;", "isMainApkCompatibleWithDevice", "", "mainBuiltArtifact", "gradle"})
public final class SplitOutputMatcher {
    public static final SplitOutputMatcher INSTANCE;

    @NotNull
    public final List<File> computeBestOutput(@NotNull DeviceConfigProvider deviceConfigProvider, @NotNull BuiltArtifacts builtArtifacts, @Nullable Collection<String> variantAbiFilters) {
        Intrinsics.checkParameterIsNotNull((Object)deviceConfigProvider, (String)"deviceConfigProvider");
        Intrinsics.checkParameterIsNotNull((Object)builtArtifacts, (String)"builtArtifacts");
        List apkFiles = new ArrayList();
        int n = deviceConfigProvider.getDensity();
        List list = deviceConfigProvider.getAbis();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"deviceConfigProvider.abis");
        return this.computeBestOutput(builtArtifacts, variantAbiFilters, n, list);
    }

    @NotNull
    public final List<File> computeBestOutput(@NotNull BuiltArtifacts outputs, @Nullable Collection<String> variantAbiFilters, int deviceDensity, @NotNull List<String> deviceAbis) {
        List list;
        BuiltArtifact match2;
        Intrinsics.checkParameterIsNotNull((Object)outputs, (String)"outputs");
        Intrinsics.checkParameterIsNotNull(deviceAbis, (String)"deviceAbis");
        Density densityEnum = Density.getEnum((int)deviceDensity);
        String densityValue = null;
        Density density = densityEnum;
        densityValue = density != null ? density.getResourceValue() : null;
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList()");
        List matches = arrayList;
        for (BuiltArtifact builtArtifact : outputs.getElements()) {
            String densityFilter = this.getFilter(builtArtifact, FilterConfiguration.FilterType.DENSITY);
            String abiFilter = this.getFilter(builtArtifact, FilterConfiguration.FilterType.ABI);
            if (densityFilter != null && Intrinsics.areEqual((Object)densityFilter, (Object)densityValue) ^ true || abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
            matches.add(builtArtifact);
        }
        if (matches.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            return (List)immutableList;
        }
        BuiltArtifact builtArtifact = match2 = (BuiltArtifact)Collections.max(matches, new Comparator<T>(deviceAbis){
            final /* synthetic */ List $deviceAbis;

            public final int compare(@NotNull BuiltArtifact splitOutput, @NotNull BuiltArtifact splitOutput2) {
                Intrinsics.checkParameterIsNotNull((Object)splitOutput, (String)"splitOutput");
                Intrinsics.checkParameterIsNotNull((Object)splitOutput2, (String)"splitOutput2");
                int rc = splitOutput.getVersionCode() - splitOutput2.getVersionCode();
                if (rc != 0) {
                    return rc;
                }
                int abiOrder1 = SplitOutputMatcher.access$getAbiPreferenceOrder(SplitOutputMatcher.INSTANCE, splitOutput, this.$deviceAbis);
                int abiOrder2 = SplitOutputMatcher.access$getAbiPreferenceOrder(SplitOutputMatcher.INSTANCE, splitOutput2, this.$deviceAbis);
                return abiOrder1 - abiOrder2;
            }
            {
                this.$deviceAbis = list;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)builtArtifact, (String)"match");
        if (this.isMainApkCompatibleWithDevice(builtArtifact, variantAbiFilters, (Collection<String>)deviceAbis)) {
            ImmutableList immutableList = ImmutableList.of((Object)match2.getOutputFile().toFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(match.outputFile.toFile())");
            list = (List)immutableList;
        } else {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            list = (List)immutableList;
        }
        return list;
    }

    private final int getAbiPreferenceOrder(BuiltArtifact builtArtifact, List<String> deviceAbi) {
        String abiFilter = this.getFilter(builtArtifact, FilterConfiguration.FilterType.ABI);
        if (Strings.isNullOrEmpty((String)abiFilter)) {
            return deviceAbi.size() - 1;
        }
        int match2 = deviceAbi.indexOf(abiFilter);
        if (match2 == 0) {
            match2 = deviceAbi.size();
        } else if (match2 > 0) {
            match2 = deviceAbi.size() - match2 - 1;
        }
        return match2;
    }

    private final boolean isMainApkCompatibleWithDevice(BuiltArtifact mainBuiltArtifact, Collection<String> variantAbiFilters, Collection<String> deviceAbis) {
        if (this.getFilter(mainBuiltArtifact, FilterConfiguration.FilterType.ABI) == null && variantAbiFilters != null && !variantAbiFilters.isEmpty()) {
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private final String getFilter(BuiltArtifact variantOutput, FilterConfiguration.FilterType filterType2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = variantOutput.getFilters();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FilterConfiguration it = (FilterConfiguration)element$iv;
                boolean bl = false;
                if (!(it.getFilterType() == filterType2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        FilterConfiguration filterConfiguration = v0;
        return filterConfiguration != null ? filterConfiguration.getIdentifier() : null;
    }

    private SplitOutputMatcher() {
    }

    static {
        SplitOutputMatcher splitOutputMatcher;
        INSTANCE = splitOutputMatcher = new SplitOutputMatcher();
    }

    public static final /* synthetic */ int access$getAbiPreferenceOrder(SplitOutputMatcher $this, BuiltArtifact builtArtifact, List deviceAbi) {
        return $this.getAbiPreferenceOrder(builtArtifact, deviceAbi);
    }
}

