/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.core.VariantBuilder;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.google.common.collect.Maps;
import java.util.Map;

public class VariantInputModelImpl
implements VariantInputModel {
    private final BaseExtension extension;
    private final VariantFactory variantFactory;
    private final SourceSetManager sourceSetManager;
    private final ProductFlavorData<DefaultConfig> defaultConfigData;
    private final Map<String, BuildTypeData> buildTypes;
    private final Map<String, ProductFlavorData<ProductFlavor>> productFlavors;
    private final Map<String, SigningConfig> signingConfigs;
    protected final GlobalScope globalScope;

    public VariantInputModelImpl(GlobalScope globalScope, BaseExtension extension, VariantFactory variantFactory, SourceSetManager sourceSetManager) {
        this.globalScope = globalScope;
        this.extension = extension;
        this.variantFactory = variantFactory;
        this.sourceSetManager = sourceSetManager;
        this.buildTypes = Maps.newHashMap();
        this.productFlavors = Maps.newHashMap();
        this.signingConfigs = Maps.newHashMap();
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("main");
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("androidTest");
            unitTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("test");
        }
        this.defaultConfigData = new ProductFlavorData<DefaultConfig>(extension.getDefaultConfig(), mainSourceSet, androidTestSourceSet, unitTestSourceSet);
    }

    @Override
    public ProductFlavorData<DefaultConfig> getDefaultConfig() {
        return this.defaultConfigData;
    }

    @Override
    public Map<String, BuildTypeData> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    public Map<String, ProductFlavorData<ProductFlavor>> getProductFlavors() {
        return this.productFlavors;
    }

    @Override
    public Map<String, SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void addSigningConfig(SigningConfig signingConfig) {
        this.signingConfigs.put(signingConfig.getName(), signingConfig);
    }

    public void addBuildType(BuildType buildType) {
        String name2 = buildType.getName();
        VariantInputModelImpl.checkName(name2, "BuildType");
        if (this.productFlavors.containsKey(name2)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpSourceSet(name2);
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            if (buildType.getName().equals(this.extension.getTestBuildType())) {
                androidTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantBuilder.computeSourceSetName(buildType.getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            }
            unitTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantBuilder.computeSourceSetName(buildType.getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
        }
        BuildTypeData buildTypeData = new BuildTypeData(buildType, mainSourceSet, androidTestSourceSet, unitTestSourceSet);
        this.buildTypes.put(name2, buildTypeData);
    }

    public void addProductFlavor(ProductFlavor productFlavor) {
        String name2 = productFlavor.getName();
        VariantInputModelImpl.checkName(name2, "ProductFlavor");
        if (this.buildTypes.containsKey(name2)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpSourceSet(productFlavor.getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantBuilder.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            unitTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantBuilder.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
        }
        ProductFlavorData<ProductFlavor> productFlavorData = new ProductFlavorData<ProductFlavor>(productFlavor, mainSourceSet, androidTestSourceSet, unitTestSourceSet);
        this.productFlavors.put(productFlavor.getName(), productFlavorData);
    }

    private static void checkName(String name2, String displayName) {
        VariantInputModelImpl.checkPrefix(name2, displayName, "androidTest");
        VariantInputModelImpl.checkPrefix(name2, displayName, "test");
        if ("lint".equals(name2)) {
            throw new RuntimeException(String.format("%1$s names cannot be %2$s", displayName, "lint"));
        }
    }

    private static void checkPrefix(String name2, String displayName, String prefix) {
        if (name2.startsWith(prefix)) {
            throw new RuntimeException(String.format("%1$s names cannot start with '%2$s'", displayName, prefix));
        }
    }
}

