/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;

public final class SigningOptions {
    private final String storeFile;
    private final String storePassword;
    private final String keyAlias;
    private final String keyPassword;
    private final String storeType;
    private final Boolean v1Enabled;
    private final Boolean v2Enabled;
    private final Boolean v1Configured;
    private final Boolean v2Configured;

    public static SigningOptions readSigningOptions(ProjectOptions options) {
        String signingStoreFile = options.get(StringOption.IDE_SIGNING_STORE_FILE);
        String signingStorePassword = options.get(StringOption.IDE_SIGNING_STORE_PASSWORD);
        String signingKeyAlias = options.get(StringOption.IDE_SIGNING_KEY_ALIAS);
        String signingKeyPassword = options.get(StringOption.IDE_SIGNING_KEY_PASSWORD);
        Boolean isV1SigningConfigured = options.get(OptionalBooleanOption.SIGNING_V1_ENABLED) != null;
        Boolean isV2SigningConfigured = options.get(OptionalBooleanOption.SIGNING_V2_ENABLED) != null;
        if (signingStoreFile != null && signingStorePassword != null && signingKeyAlias != null && signingKeyPassword != null) {
            return new SigningOptions(signingStoreFile, signingStorePassword, signingKeyAlias, signingKeyPassword, options.get(StringOption.IDE_SIGNING_STORE_TYPE), options.get(OptionalBooleanOption.SIGNING_V1_ENABLED), options.get(OptionalBooleanOption.SIGNING_V2_ENABLED), isV1SigningConfigured, isV2SigningConfigured);
        }
        return null;
    }

    public SigningOptions(String storeFile, String storePassword, String keyAlias, String keyPassword, String storeType, Boolean v1Enabled, Boolean v2Enabled, Boolean v1Configured, Boolean v2Configured) {
        this.storeFile = storeFile;
        this.storeType = storeType;
        this.storePassword = storePassword;
        this.keyAlias = keyAlias;
        this.keyPassword = keyPassword;
        this.v1Enabled = v1Enabled;
        this.v2Enabled = v2Enabled;
        this.v1Configured = v1Configured;
        this.v2Configured = v2Configured;
    }

    public String getStoreFile() {
        return this.storeFile;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public Boolean getV1Enabled() {
        return this.v1Enabled;
    }

    public Boolean getV2Enabled() {
        return this.v2Enabled;
    }

    public Boolean getV1Configured() {
        return this.v1Configured;
    }

    public Boolean getV2Configured() {
        return this.v2Configured;
    }
}

