/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.LintBaseTask;
import com.android.utils.StringHelper;
import java.util.List;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class LintPerVariantTask
extends LintBaseTask
implements VariantAwareTask {
    private LintBaseTask.VariantInputs variantInputs;
    private ConfigurableFileCollection allInputs;
    private boolean fatalOnly;
    private String variantName;

    @Override
    @Internal
    public String getVariantName() {
        return this.variantName;
    }

    @Override
    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    public FileCollection getAllInputs() {
        return this.allInputs;
    }

    @TaskAction
    public void lint() {
        this.runLint(new LintPerVariantTaskDescriptor());
    }

    public static class VitalCreationAction
    extends LintBaseTask.BaseCreationAction<LintPerVariantTask> {
        private final VariantScope scope;
        private final List<VariantScope> variantScopes;

        public VitalCreationAction(VariantScope scope, List<VariantScope> variantScopes) {
            super(scope.getGlobalScope());
            this.scope = scope;
            this.variantScopes = variantScopes;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lintVital");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void configure(LintPerVariantTask task) {
            super.configure(task);
            task.setVariantName(this.scope.getName());
            task.allInputs = this.scope.getGlobalScope().getProject().files(new Object[0]);
            task.variantInputs = new LintBaseTask.VariantInputs(this.scope);
            task.allInputs.from(new Object[]{task.variantInputs.getAllInputs()});
            for (VariantScope variantScope : this.variantScopes) {
                LintBaseTask.addModelArtifactsToInputs(task.allInputs, variantScope);
            }
            task.fatalOnly = true;
            task.setDescription("Runs lint on just the fatal issues in the " + task.getVariantName() + " build.");
            task.getEnableGradleWorkers().set((Object)this.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_GRADLE_WORKERS));
        }
    }

    public static class CreationAction
    extends LintBaseTask.BaseCreationAction<LintPerVariantTask> {
        private final VariantScope scope;
        private final List<VariantScope> variantScopes;

        public CreationAction(VariantScope scope, List<VariantScope> variantScopes) {
            super(scope.getGlobalScope());
            this.scope = scope;
            this.variantScopes = variantScopes;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lint");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void configure(LintPerVariantTask lint) {
            super.configure(lint);
            lint.setVariantName(this.scope.getName());
            lint.allInputs = this.scope.getGlobalScope().getProject().files(new Object[0]);
            lint.variantInputs = new LintBaseTask.VariantInputs(this.scope);
            lint.allInputs.from(new Object[]{lint.variantInputs.getAllInputs()});
            for (VariantScope variantScope : this.variantScopes) {
                LintBaseTask.addModelArtifactsToInputs(lint.allInputs, variantScope);
            }
            lint.setDescription(StringHelper.appendCapitalized((String)"Runs lint on the ", (String)lint.getVariantName(), (String)" build."));
            lint.getEnableGradleWorkers().set((Object)this.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_GRADLE_WORKERS));
        }
    }

    private class LintPerVariantTaskDescriptor
    extends LintBaseTask.LintBaseTaskDescriptor {
        private LintPerVariantTaskDescriptor() {
            super(LintPerVariantTask.this);
        }

        public String getVariantName() {
            return LintPerVariantTask.this.getVariantName();
        }

        public LintBaseTask.VariantInputs getVariantInputs(String variantName) {
            assert (variantName.equals(this.getVariantName()));
            return LintPerVariantTask.this.variantInputs;
        }

        public boolean isFatalOnly() {
            return LintPerVariantTask.this.fatalOnly;
        }
    }
}

