/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.VariantOutput;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.TaskContainer;
import com.android.build.gradle.internal.services.BaseServices;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class VariantOutputFactory {
    private final Class<? extends BaseVariantOutput> targetClass;
    private final BaseServices services;
    private final BaseVariantImpl deprecatedVariantPublicApi;
    private final TaskContainer taskContainer;
    private final BaseExtension extension;
    private final DeprecationReporter deprecationReporter;

    public VariantOutputFactory(Class<? extends BaseVariantOutput> targetClass, BaseServices services2, BaseExtension extension, BaseVariantImpl deprecatedVariantPublicApi, TaskContainer taskContainer, DeprecationReporter deprecationReporter) {
        this.targetClass = targetClass;
        this.services = services2;
        this.deprecatedVariantPublicApi = deprecatedVariantPublicApi;
        this.taskContainer = taskContainer;
        this.extension = extension;
        this.deprecationReporter = deprecationReporter;
    }

    public VariantOutput create(VariantOutputImpl variantApi) {
        BaseVariantOutput variantOutput = this.services.newInstance(this.targetClass, this.taskContainer, this.deprecationReporter, variantApi);
        this.extension.getBuildOutputs().add((Object)variantOutput);
        if (this.deprecatedVariantPublicApi != null) {
            this.deprecatedVariantPublicApi.addOutputs((List<BaseVariantOutput>)ImmutableList.of((Object)variantOutput));
        }
        return variantOutput;
    }
}

