/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.Version;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonCompositeVisitor;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStatsBuildingVisitor;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStreamingParser;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStreamingVisitor;
import com.android.build.gradle.internal.ide.NativeAndroidProjectImpl;
import com.android.build.gradle.internal.ide.NativeArtifactImpl;
import com.android.build.gradle.internal.ide.NativeFileImpl;
import com.android.build.gradle.internal.ide.NativeSettingsImpl;
import com.android.build.gradle.internal.ide.NativeToolchainImpl;
import com.android.build.gradle.internal.ide.NativeVariantAbiImpl;
import com.android.build.gradle.internal.ide.NativeVariantInfoImpl;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.NativeVariantAbi;
import com.android.builder.model.NativeVariantInfo;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class NativeAndroidProjectBuilder {
    private final String projectName;
    private final String selectedAbiName;
    private final Set<File> buildFiles = Sets.newHashSet();
    private final Map<String, NativeVariantInfo> variantInfos = Maps.newHashMap();
    private final Map<String, String> extensions = Maps.newHashMap();
    private final List<NativeArtifact> artifacts = Lists.newArrayList();
    private final List<NativeToolchain> toolChains = Lists.newArrayList();
    private final Map<List<String>, NativeSettings> settingsMap = Maps.newHashMap();
    private final Set<String> buildSystems = Sets.newHashSet();

    NativeAndroidProjectBuilder(String projectName) {
        this.projectName = projectName;
        this.selectedAbiName = null;
    }

    NativeAndroidProjectBuilder(String projectName, String selectedAbiName) {
        this.projectName = projectName;
        this.selectedAbiName = selectedAbiName;
    }

    void addVariantInfo(String variantName, List<String> abiNames, Map<String, File> buildRootFolderMap) {
        this.variantInfos.put(variantName, new NativeVariantInfoImpl(abiNames, buildRootFolderMap));
    }

    void addBuildSystem(String buildSystem2) {
        this.buildSystems.add(buildSystem2);
    }

    void addJson(JsonReader reader, String variantName, GradleBuildVariant.NativeBuildConfigInfo.Builder config2) throws IOException {
        JsonStreamingVisitor modelBuildingVisitor = new JsonStreamingVisitor(this, variantName, this.selectedAbiName);
        AndroidBuildGradleJsonStatsBuildingVisitor statsVisitor = new AndroidBuildGradleJsonStatsBuildingVisitor(config2);
        AndroidBuildGradleJsonCompositeVisitor composite = new AndroidBuildGradleJsonCompositeVisitor(statsVisitor, modelBuildingVisitor);
        try (AndroidBuildGradleJsonStreamingParser parser2 = new AndroidBuildGradleJsonStreamingParser(reader, composite);){
            parser2.parse();
        }
    }

    void addJson(JsonReader reader, String variantName) throws IOException {
        JsonStreamingVisitor modelBuildingVisitor = new JsonStreamingVisitor(this, variantName, this.selectedAbiName);
        try (AndroidBuildGradleJsonStreamingParser parser2 = new AndroidBuildGradleJsonStreamingParser(reader, modelBuildingVisitor);){
            parser2.parse();
        }
    }

    NativeAndroidProject buildNativeAndroidProject() {
        assert (this.selectedAbiName == null);
        if (this.buildFiles.isEmpty() && this.variantInfos.isEmpty()) {
            return null;
        }
        return new NativeAndroidProjectImpl(Version.ANDROID_GRADLE_PLUGIN_VERSION, this.projectName, this.buildFiles, this.variantInfos, this.artifacts, this.toolChains, (Collection<NativeSettings>)ImmutableList.copyOf(this.settingsMap.values()), this.extensions, this.buildSystems, Version.BUILDER_MODEL_API_VERSION);
    }

    NativeVariantAbi buildNativeVariantAbi(String variantName) {
        assert (this.selectedAbiName != null);
        if (this.buildFiles.isEmpty()) {
            return null;
        }
        return new NativeVariantAbiImpl(variantName, this.selectedAbiName, this.buildFiles, this.artifacts, this.toolChains, (Collection<? extends NativeSettings>)ImmutableList.copyOf(this.settingsMap.values()), this.extensions);
    }

    static class JsonStreamingVisitor
    extends AndroidBuildGradleJsonStreamingVisitor {
        private final NativeAndroidProjectBuilder builder;
        private final String variantName;
        private final String selectedAbiName;
        private final Map<Integer, String> stringTable = Maps.newHashMap();
        private String currentToolchain = null;
        private String currentCExecutable = null;
        private String currentCppExecutable = null;
        private String currentLibraryName = null;
        private String currentLibraryToolchain = null;
        private String currentLibraryOutput = null;
        private String currentLibraryAbi = null;
        private String currentLibraryArtifactName = null;
        private List<File> currentLibraryRuntimeFiles = null;
        private List<NativeFile> currentLibrarySourceFiles = null;
        private String currentLibraryFileSettingsName = null;
        private String currentLibraryFilePath = null;
        private String currentLibraryFileWorkingDirectory = null;

        JsonStreamingVisitor(NativeAndroidProjectBuilder builder, String variantName, String selectedAbiName) {
            this.variantName = variantName;
            this.selectedAbiName = selectedAbiName;
            this.builder = builder;
        }

        @Override
        protected void visitStringTableEntry(int index, String value) {
            this.stringTable.put(index, value);
        }

        @Override
        public void visitBuildFile(String buildFile) {
            this.builder.buildFiles.add(new File(buildFile));
        }

        @Override
        public void beginLibrary(String libraryName) {
            this.currentLibraryName = libraryName;
            this.currentLibraryRuntimeFiles = Lists.newArrayList();
            this.currentLibrarySourceFiles = Lists.newArrayList();
        }

        @Override
        public void endLibrary() {
            Preconditions.checkNotNull((Object)this.currentLibraryName);
            Preconditions.checkNotNull((Object)this.currentLibraryToolchain);
            Preconditions.checkNotNull(this.currentLibrarySourceFiles);
            Preconditions.checkNotNull(this.currentLibraryRuntimeFiles);
            Preconditions.checkNotNull((Object)this.currentLibraryAbi);
            Preconditions.checkNotNull((Object)this.currentLibraryArtifactName);
            if (this.isCurrentAbiAcceptable()) {
                this.builder.artifacts.add(new NativeArtifactImpl(this.currentLibraryName, this.currentLibraryToolchain, this.variantName, "", this.currentLibrarySourceFiles, (Collection<File>)ImmutableList.of(), this.newFileOrNull(this.currentLibraryOutput), this.currentLibraryRuntimeFiles, this.currentLibraryAbi, this.currentLibraryArtifactName));
            }
            this.currentLibraryName = null;
            this.currentLibraryToolchain = null;
            this.currentLibraryOutput = null;
            this.currentLibraryAbi = null;
            this.currentLibraryArtifactName = null;
            this.currentLibraryRuntimeFiles = null;
            this.currentLibrarySourceFiles = null;
        }

        private boolean isCurrentAbiAcceptable() {
            assert (this.currentLibraryAbi != null);
            return this.selectedAbiName == null || this.selectedAbiName.equals(this.currentLibraryAbi);
        }

        @Override
        public void beginToolchain(String toolchain) {
            this.currentToolchain = toolchain;
        }

        @Override
        public void endToolchain() {
            Preconditions.checkNotNull((Object)this.currentToolchain);
            this.builder.toolChains.add(new NativeToolchainImpl(this.currentToolchain, this.newFileOrNull(this.currentCExecutable), this.newFileOrNull(this.currentCppExecutable)));
            this.currentToolchain = null;
            this.currentCExecutable = null;
            this.currentCppExecutable = null;
        }

        private File newFileOrNull(String filename) {
            if (filename == null) {
                return null;
            }
            return new File(filename);
        }

        @Override
        public void visitLibraryAbi(String abi) {
            this.currentLibraryAbi = abi;
        }

        @Override
        public void visitLibraryArtifactName(String artifact) {
            this.currentLibraryArtifactName = artifact;
        }

        @Override
        public void visitLibraryOutput(String output2) {
            this.currentLibraryOutput = output2;
        }

        @Override
        public void visitLibraryToolchain(String toolchain) {
            this.currentLibraryToolchain = toolchain;
        }

        @Override
        public void visitToolchainCCompilerExecutable(String executable) {
            this.currentCExecutable = executable;
        }

        @Override
        public void visitToolchainCppCompilerExecutable(String executable) {
            this.currentCppExecutable = executable;
        }

        @Override
        public void visitLibraryFileFlags(String flags) {
            if (this.isCurrentAbiAcceptable()) {
                this.currentLibraryFileSettingsName = this.getSettingsName(StringHelper.tokenizeCommandLineToEscaped((String)flags));
            }
        }

        @Override
        protected void visitLibraryFileFlagsOrdinal(Integer flagsOrdinal) {
            this.visitLibraryFileFlags(this.stringTable.get(flagsOrdinal));
        }

        @Override
        public void visitLibraryFileSrc(String src) {
            this.currentLibraryFilePath = src;
        }

        @Override
        public void visitLibraryFileWorkingDirectory(String workingDirectory) {
            this.currentLibraryFileWorkingDirectory = workingDirectory;
        }

        @Override
        protected void visitLibraryFileWorkingDirectoryOrdinal(Integer workingDirectoryOrdinal) {
            this.visitLibraryFileWorkingDirectory(this.stringTable.get(workingDirectoryOrdinal));
        }

        @Override
        public void visitCFileExtensions(String extension) {
            this.builder.extensions.put(extension, "c");
        }

        @Override
        public void visitCppFileExtensions(String extension) {
            this.builder.extensions.put(extension, "c++");
        }

        @Override
        public void visitLibraryRuntimeFile(String runtimeFile) {
            Preconditions.checkNotNull(this.currentLibraryRuntimeFiles);
            this.currentLibraryRuntimeFiles.add(new File(runtimeFile));
        }

        @Override
        public void endLibraryFile() {
            Preconditions.checkNotNull(this.currentLibrarySourceFiles);
            Preconditions.checkNotNull((Object)this.currentLibraryFilePath);
            if (this.currentLibraryFileSettingsName != null) {
                this.currentLibrarySourceFiles.add(new NativeFileImpl(new File(this.currentLibraryFilePath), this.currentLibraryFileSettingsName, this.newFileOrNull(this.currentLibraryFileWorkingDirectory)));
            }
            this.currentLibraryFilePath = null;
            this.currentLibraryFileSettingsName = null;
            this.currentLibraryFileWorkingDirectory = null;
        }

        private String getSettingsName(List<String> flags) {
            ImmutableList flagsCopy = ImmutableList.copyOf(flags);
            NativeSettings setting = (NativeSettings)this.builder.settingsMap.get(flags);
            if (setting == null) {
                setting = new NativeSettingsImpl("setting" + UUID.randomUUID(), (List<String>)flagsCopy);
                this.builder.settingsMap.put(flagsCopy, setting);
            }
            return setting.getName();
        }
    }
}

