/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.AndroidDependenciesRenderer;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00068GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/DependencyReportTask;", "Lorg/gradle/api/DefaultTask;", "()V", "renderer", "Lcom/android/build/gradle/internal/AndroidDependenciesRenderer;", "testComponents", "", "Lcom/android/build/api/component/impl/TestComponentPropertiesImpl;", "getTestComponents", "()Ljava/util/List;", "setTestComponents", "(Ljava/util/List;)V", "variants", "Lcom/android/build/api/variant/impl/VariantPropertiesImpl;", "getVariants", "setVariants", "generate", "", "gradle"})
public class DependencyReportTask
extends DefaultTask {
    private final AndroidDependenciesRenderer renderer = new AndroidDependenciesRenderer();
    @NotNull
    public List<? extends VariantPropertiesImpl> variants;
    @NotNull
    public List<? extends TestComponentPropertiesImpl> testComponents;

    @Internal
    @NotNull
    public final List<VariantPropertiesImpl> getVariants() {
        List<VariantPropertiesImpl> list = this.variants;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variants");
        }
        return list;
    }

    public final void setVariants(@NotNull List<? extends VariantPropertiesImpl> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.variants = list;
    }

    @Internal
    @NotNull
    public final List<TestComponentPropertiesImpl> getTestComponents() {
        List<TestComponentPropertiesImpl> list = this.testComponents;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testComponents");
        }
        return list;
    }

    public final void setTestComponents(@NotNull List<? extends TestComponentPropertiesImpl> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.testComponents = list;
    }

    @TaskAction
    public final void generate() throws IOException {
        this.renderer.setOutput(((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create(((Object)((Object)this)).getClass()));
        List<? extends VariantPropertiesImpl> list = this.variants;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variants");
        }
        Iterable iterable = list;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                VariantPropertiesImpl it = (VariantPropertiesImpl)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (VariantPropertiesImpl)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        List sortedVariants = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        for (VariantPropertiesImpl variant2 : sortedVariants) {
            this.renderer.startComponent(variant2);
            this.renderer.render(variant2);
        }
        List<? extends TestComponentPropertiesImpl> list2 = this.testComponents;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testComponents");
        }
        iterable = list2;
        boolean bl2 = false;
        comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TestComponentPropertiesImpl it = (TestComponentPropertiesImpl)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (TestComponentPropertiesImpl)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        List sortedTestComponents = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        for (TestComponentPropertiesImpl testComponent : sortedTestComponents) {
            this.renderer.startComponent(testComponent);
            this.renderer.render(testComponent);
        }
    }
}

