/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.mlkit.codegen;

import com.android.build.gradle.internal.tasks.mlkit.codegen.ClassNames;
import com.android.tools.mlkit.TensorInfo;
import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CodeUtils {
    private static final Map<TensorInfo.DataType, TypeName> typeToNameMap = new HashMap<TensorInfo.DataType, TypeName>();

    public static TypeName getParameterType(TensorInfo tensorInfo) {
        if (tensorInfo.getSource() == TensorInfo.Source.INPUT) {
            if (tensorInfo.getContentType() == TensorInfo.ContentType.IMAGE) {
                return ClassNames.TENSOR_IMAGE;
            }
            return ClassNames.TENSOR_BUFFER;
        }
        return ClassNames.TENSOR_BUFFER;
    }

    public static String getFileName(String name2) {
        return name2.replaceAll("\\..*", "") + "Data";
    }

    public static String getProcessorName(TensorInfo tensorInfo) {
        if (tensorInfo.getSource() == TensorInfo.Source.INPUT) {
            return tensorInfo.getName() + "Processor";
        }
        return tensorInfo.getName() + "PostProcessor";
    }

    public static String getProcessorBuilderName(TensorInfo tensorInfo) {
        return CodeUtils.getProcessorName(tensorInfo) + "Builder";
    }

    public static String getFloatArrayString(float[] array) {
        String[] localArray = new String[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            localArray[i2] = array[i2] + "f";
        }
        return CodeUtils.getArrayString("float", localArray);
    }

    public static String getIntArrayString(int[] array) {
        return CodeUtils.getArrayString("int", (String[])Arrays.stream(array).mapToObj(String::valueOf).toArray(String[]::new));
    }

    public static String getObjectArrayString(String[] array) {
        return CodeUtils.getArrayString("Object", array);
    }

    private static String getArrayString(String type, String[] array) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("new %s[] {", type));
        for (String dim : array) {
            builder.append(dim + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("}");
        return builder.toString();
    }

    public static String getDataType(TensorInfo.DataType type) {
        return type.toString();
    }

    public static TypeName getOutputParameterType(TensorInfo tensorInfo) {
        if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_AXIS_LABELS) {
            return ParameterizedTypeName.get((ClassName)ClassNames.MAP, (TypeName[])new TypeName[]{ClassNames.STRING, ClassNames.FLOAT});
        }
        return ClassNames.BYTE_BUFFER;
    }

    public static String getUpperCamelName(String name2) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, name2);
    }

    static {
        typeToNameMap.put(TensorInfo.DataType.UINT8, TypeName.BYTE);
        typeToNameMap.put(TensorInfo.DataType.FLOAT32, TypeName.FLOAT);
        typeToNameMap.put(TensorInfo.DataType.INT64, TypeName.LONG);
        typeToNameMap.put(TensorInfo.DataType.INT32, TypeName.INT);
    }
}

