/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.api.variant.impl.VariantOutputConfigurationImplKt;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.DynamicFeatureCreationConfig;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.manifest.ManifestHelperKt;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexingType;
import com.android.builder.model.ApiVersion;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;

@CacheableTask
public abstract class ProcessApplicationManifest
extends ManifestProcessorTask {
    private ArtifactCollection manifests;
    private ArtifactCollection featureManifests;
    private FileCollection dependencyFeatureNameArtifacts;
    private FileCollection microApkManifest;
    private Property<Boolean> baseModuleDebuggable;
    private Property<Integer> baseModuleVersionCode;
    private Property<String> baseModuleVersionName;
    private final Property<String> packageOverride;
    private final ListProperty<File> manifestOverlays;
    private final MapProperty<String, Object> manifestPlaceholders;
    private boolean isFeatureSplitVariantType;
    private String buildTypeName;
    private FileCollection navigationJsons;

    @Inject
    public ProcessApplicationManifest(ObjectFactory objectFactory) {
        super(objectFactory);
        this.packageOverride = objectFactory.property(String.class);
        this.manifestOverlays = objectFactory.listProperty(File.class);
        this.manifestPlaceholders = objectFactory.mapProperty(String.class, Object.class);
        this.baseModuleDebuggable = objectFactory.property(Boolean.class);
        this.baseModuleVersionCode = objectFactory.property(Integer.class);
        this.baseModuleVersionName = objectFactory.property(String.class);
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        BuiltArtifactsImpl compatibleScreenManifests = new BuiltArtifactsLoaderImpl().load((Provider<Directory>)this.getCompatibleScreensManifest());
        if (compatibleScreenManifests == null) {
            throw new RuntimeException("Cannot find generated compatible screen manifests, file a bug");
        }
        if (this.baseModuleDebuggable.isPresent()) {
            boolean isDebuggable = ((Set)this.getOptionalFeatures().get()).contains(ManifestMerger2.Invoker.Feature.DEBUGGABLE);
            if ((Boolean)this.baseModuleDebuggable.get() != isDebuggable) {
                String errorMessage = String.format("Dynamic Feature '%1$s' (build type '%2$s') %3$s debuggable,\nand the corresponding build type in the base application %4$s debuggable.\nRecommendation: \n   in  %5$s\n   set android.buildTypes.%2$s.debuggable = %6$s", this.getProject().getPath(), this.buildTypeName, isDebuggable ? "is" : "is not", (Boolean)this.baseModuleDebuggable.get() != false ? "is" : "is not", this.getProject().getBuildFile(), (Boolean)this.baseModuleDebuggable.get() != false ? "true" : "false");
                throw new InvalidUserDataException(errorMessage);
            }
        }
        ImmutableList.Builder mergedManifestOutputs = ImmutableList.builder();
        ImmutableList.Builder metadataFeatureMergedManifestOutputs = ImmutableList.builder();
        ImmutableList.Builder bundleManifestOutputs = ImmutableList.builder();
        ImmutableList.Builder instantAppManifestOutputs = ImmutableList.builder();
        ArrayList navJsons = this.navigationJsons == null ? Collections.emptyList() : Lists.newArrayList((Iterable)this.navigationJsons);
        for (VariantOutputImpl variantOutput : (List)this.getVariantOutputs().get()) {
            BuiltArtifactImpl compatibleScreenManifestForSplit = compatibleScreenManifests.getBuiltArtifact(variantOutput);
            String dirName2 = VariantOutputConfigurationImplKt.dirName(variantOutput);
            File manifestOutputFile = new File(((Directory)this.getManifestOutputDirectory().get()).getAsFile(), FileUtils.join((String[])new String[]{dirName2, "AndroidManifest.xml"}));
            File metadataFeatureManifestOutputFile = FileUtils.join((File)((Directory)this.getMetadataFeatureManifestOutputDirectory().get()).getAsFile(), (String[])new String[]{dirName2, "AndroidManifest.xml"});
            File bundleManifestOutputFile = FileUtils.join((File)((Directory)this.getBundleManifestOutputDirectory().get()).getAsFile(), (String[])new String[]{dirName2, "AndroidManifest.xml"});
            File instantAppManifestOutputFile = this.getInstantAppManifestOutputDirectory().isPresent() ? FileUtils.join((File)((Directory)this.getInstantAppManifestOutputDirectory().get()).getAsFile(), (String[])new String[]{dirName2, "AndroidManifest.xml"}) : null;
            MergingReport mergingReport = ManifestHelperKt.mergeManifestsForApplication((File)this.getMainManifest().get(), (List)this.manifestOverlays.get(), this.computeFullProviderList(compatibleScreenManifestForSplit), navJsons, (String)this.getFeatureName().getOrNull(), (String)this.packageOverride.get(), this.baseModuleVersionCode.isPresent() ? ((Integer)this.baseModuleVersionCode.get()).intValue() : ((Integer)variantOutput.getVersionCode().get()).intValue(), this.baseModuleVersionName.isPresent() && !((String)this.baseModuleVersionName.get()).isEmpty() ? (String)this.baseModuleVersionName.get() : (String)variantOutput.getVersionName().get(), (String)this.getMinSdkVersion().getOrNull(), (String)this.getTargetSdkVersion().getOrNull(), (Integer)this.getMaxSdkVersion().getOrNull(), manifestOutputFile.getAbsolutePath(), null, metadataFeatureManifestOutputFile.getAbsolutePath(), bundleManifestOutputFile.getAbsolutePath(), instantAppManifestOutputFile != null ? instantAppManifestOutputFile.getAbsolutePath() : null, ManifestMerger2.MergeType.APPLICATION, (Map)this.manifestPlaceholders.get(), (Collection)this.getOptionalFeatures().get(), this.getDependencyFeatureNames(), ((RegularFile)this.getReportFile().get()).getAsFile(), LoggerWrapper.getLogger(ProcessApplicationManifest.class));
            XmlDocument mergedXmlDocument = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            ProcessApplicationManifest.outputMergeBlameContents(mergingReport, ((RegularFile)this.getMergeBlameFile().get()).getAsFile());
            ImmutableMap properties = mergedXmlDocument != null ? ImmutableMap.of((Object)"packageId", (Object)mergedXmlDocument.getPackageName(), (Object)"split", (Object)mergedXmlDocument.getSplitName(), (Object)"minSdkVersion", (Object)mergedXmlDocument.getMinSdkVersion()) : ImmutableMap.of();
            mergedManifestOutputs.add((Object)variantOutput.toBuiltArtifact(manifestOutputFile, (Map<String, String>)properties));
            metadataFeatureMergedManifestOutputs.add((Object)variantOutput.toBuiltArtifact(metadataFeatureManifestOutputFile, (Map<String, String>)properties));
            bundleManifestOutputs.add((Object)variantOutput.toBuiltArtifact(bundleManifestOutputFile, (Map<String, String>)properties));
            if (instantAppManifestOutputFile == null) continue;
            instantAppManifestOutputs.add((Object)variantOutput.toBuiltArtifact(instantAppManifestOutputFile, (Map<String, String>)properties));
        }
        new BuiltArtifactsImpl(2, InternalArtifactType.MERGED_MANIFESTS.INSTANCE, (String)this.getApplicationId().get(), this.getVariantName(), (Collection<BuiltArtifactImpl>)mergedManifestOutputs.build()).save((Directory)this.getManifestOutputDirectory().get());
        new BuiltArtifactsImpl(2, InternalArtifactType.METADATA_FEATURE_MANIFEST.INSTANCE, (String)this.getApplicationId().get(), this.getVariantName(), (Collection<BuiltArtifactImpl>)metadataFeatureMergedManifestOutputs.build()).save((Directory)this.getMetadataFeatureManifestOutputDirectory().get());
        new BuiltArtifactsImpl(2, InternalArtifactType.BUNDLE_MANIFEST.INSTANCE, (String)this.getApplicationId().get(), this.getVariantName(), (Collection<BuiltArtifactImpl>)bundleManifestOutputs.build()).save((Directory)this.getBundleManifestOutputDirectory().get());
        if (this.getInstantAppManifestOutputDirectory().isPresent()) {
            new BuiltArtifactsImpl(2, InternalArtifactType.INSTANT_APP_MANIFEST.INSTANCE, (String)this.getApplicationId().get(), this.getVariantName(), (Collection<BuiltArtifactImpl>)instantAppManifestOutputs.build()).save((Directory)this.getInstantAppManifestOutputDirectory().get());
        }
    }

    @Override
    @Internal
    public File getAaptFriendlyManifestOutputFile() {
        return null;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract Property<File> getMainManifest();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ListProperty<File> getManifestOverlays() {
        return this.manifestOverlays;
    }

    @Input
    @Optional
    public Property<String> getPackageOverride() {
        return this.packageOverride;
    }

    @Input
    @Optional
    public MapProperty<String, Object> getManifestPlaceholders() {
        return this.manifestPlaceholders;
    }

    private static List<ManifestProvider> computeProviders(Set<ResolvedArtifactResult> artifacts2) {
        ArrayList providers = Lists.newArrayListWithCapacity((int)artifacts2.size());
        for (ResolvedArtifactResult artifact : artifacts2) {
            File directory2 = artifact.getFile();
            BuiltArtifactsImpl splitOutputs = BuiltArtifactsLoaderImpl.loadFromDirectory(directory2);
            if (splitOutputs == null || splitOutputs.getElements().isEmpty()) {
                throw new GradleException("Could not load manifest from " + directory2);
            }
            providers.add(new CreationAction.ManifestProviderImpl(new File(((BuiltArtifact)splitOutputs.getElements().iterator().next()).getOutputFile()), ProcessApplicationManifest.getArtifactName(artifact)));
        }
        return providers;
    }

    private List<ManifestProvider> computeFullProviderList(BuiltArtifact compatibleScreenManifestForSplit) {
        File microManifest;
        Set artifacts2 = this.manifests.getArtifacts();
        ArrayList providers = Lists.newArrayListWithCapacity((int)(artifacts2.size() + 2));
        for (ResolvedArtifactResult artifact : artifacts2) {
            providers.add(new CreationAction.ManifestProviderImpl(artifact.getFile(), ProcessApplicationManifest.getArtifactName(artifact)));
        }
        if (this.microApkManifest != null && (microManifest = this.microApkManifest.getSingleFile()).isFile()) {
            providers.add(new CreationAction.ManifestProviderImpl(microManifest, "Wear App sub-manifest"));
        }
        if (compatibleScreenManifestForSplit != null) {
            providers.add(new CreationAction.ManifestProviderImpl(new File(compatibleScreenManifestForSplit.getOutputFile()), "Compatible-Screens sub-manifest"));
        }
        if (this.featureManifests != null) {
            providers.addAll(ProcessApplicationManifest.computeProviders(this.featureManifests.getArtifacts()));
        }
        return providers;
    }

    private List<String> getDependencyFeatureNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.isFeatureSplitVariantType) {
            return list;
        }
        try {
            for (File file : this.dependencyFeatureNameArtifacts.getFiles()) {
                list.add(org.apache.commons.io.FileUtils.readFileToString((File)file));
            }
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not load feature declaration", e);
        }
    }

    private static String getNameFromAutoNamespacedManifest(File manifest) {
        String manifestSuffix = "_AndroidManifest.xml";
        String fileName = manifest.getName();
        if (!fileName.endsWith("_AndroidManifest.xml")) {
            throw new RuntimeException("Invalid auto-namespaced manifest file: " + manifest.getAbsolutePath());
        }
        return fileName.substring(0, fileName.length() - "_AndroidManifest.xml".length());
    }

    public static String getArtifactName(ResolvedArtifactResult artifact) {
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        if (id instanceof ProjectComponentIdentifier) {
            return ((ProjectComponentIdentifier)id).getProjectPath();
        }
        if (id instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier mID = (ModuleComponentIdentifier)id;
            return mID.getGroup() + ":" + mID.getModule() + ":" + mID.getVersion();
        }
        if (id instanceof OpaqueComponentArtifactIdentifier) {
            return id.getDisplayName();
        }
        if (id instanceof ArtifactCollectionWithExtraArtifact.ExtraComponentIdentifier) {
            return id.getDisplayName();
        }
        throw new RuntimeException("Unsupported type of ComponentIdentifier");
    }

    @Input
    public abstract Property<String> getApplicationId();

    @Input
    public abstract Property<String> getVariantType();

    @Input
    @Optional
    public abstract Property<String> getMinSdkVersion();

    @Input
    @Optional
    public abstract Property<String> getTargetSdkVersion();

    @Input
    @Optional
    public abstract Property<Integer> getMaxSdkVersion();

    @Internal
    public abstract SetProperty<ManifestMerger2.Invoker.Feature> getOptionalFeatures();

    @Input
    public List<String> getOptionalFeaturesString() {
        return ((Set)this.getOptionalFeatures().get()).stream().map(Enum::toString).collect(Collectors.toList());
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifests() {
        return this.manifests.getArtifactFiles();
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getNavigationJsons() {
        return this.navigationJsons;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFeatureManifests() {
        if (this.featureManifests == null) {
            return null;
        }
        return this.featureManifests.getArtifactFiles();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getDependencyFeatureNameArtifacts() {
        return this.dependencyFeatureNameArtifacts;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getMicroApkManifest() {
        return this.microApkManifest;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getCompatibleScreensManifest();

    @Input
    @Optional
    public Property<Boolean> getBaseModuleDebuggable() {
        return this.baseModuleDebuggable;
    }

    @Input
    @Optional
    public Property<Integer> getBaseModuleVersionCode() {
        return this.baseModuleVersionCode;
    }

    @Input
    @Optional
    public Property<String> getBaseModuleVersionName() {
        return this.baseModuleVersionName;
    }

    @Input
    @Optional
    public abstract Property<String> getFeatureName();

    @Nested
    public abstract ListProperty<VariantOutputImpl> getVariantOutputs();

    private static EnumSet<ManifestMerger2.Invoker.Feature> getOptionalFeatures(ApkCreationConfig creationConfig, boolean isAdvancedProfilingOn) {
        ArrayList<ManifestMerger2.Invoker.Feature> features = new ArrayList<ManifestMerger2.Invoker.Feature>();
        VariantType variantType = creationConfig.getVariantType();
        if (variantType.isDynamicFeature()) {
            features.add(ManifestMerger2.Invoker.Feature.ADD_FEATURE_SPLIT_ATTRIBUTE);
            features.add(ManifestMerger2.Invoker.Feature.CREATE_FEATURE_MANIFEST);
            features.add(ManifestMerger2.Invoker.Feature.ADD_USES_SPLIT_DEPENDENCIES);
        }
        if (variantType.isDynamicFeature()) {
            features.add(ManifestMerger2.Invoker.Feature.STRIP_MIN_SDK_FROM_FEATURE_MANIFEST);
        }
        features.add(ManifestMerger2.Invoker.Feature.ADD_INSTANT_APP_MANIFEST);
        if (variantType.isBaseModule() || variantType.isDynamicFeature()) {
            features.add(ManifestMerger2.Invoker.Feature.CREATE_BUNDLETOOL_MANIFEST);
        }
        if (variantType.isDynamicFeature()) {
            features.add(ManifestMerger2.Invoker.Feature.ADD_SPLIT_NAME_TO_BUNDLETOOL_MANIFEST);
        }
        if (creationConfig.getTestOnlyApk()) {
            features.add(ManifestMerger2.Invoker.Feature.TEST_ONLY);
        }
        if (creationConfig.getDebuggable()) {
            features.add(ManifestMerger2.Invoker.Feature.DEBUGGABLE);
            if (isAdvancedProfilingOn) {
                features.add(ManifestMerger2.Invoker.Feature.ADVANCED_PROFILING);
            }
        }
        if (creationConfig.getDexingType() == DexingType.LEGACY_MULTIDEX) {
            if (creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_ANDROID_X)) {
                features.add(ManifestMerger2.Invoker.Feature.ADD_ANDROIDX_MULTIDEX_APPLICATION_IF_NO_NAME);
            } else {
                features.add(ManifestMerger2.Invoker.Feature.ADD_SUPPORT_MULTIDEX_APPLICATION_IF_NO_NAME);
            }
        }
        if (creationConfig.getServices().getProjectOptions().get(BooleanOption.ENFORCE_UNIQUE_PACKAGE_NAMES)) {
            features.add(ManifestMerger2.Invoker.Feature.ENFORCE_UNIQUE_PACKAGE_NAME);
        }
        return features.isEmpty() ? EnumSet.noneOf(ManifestMerger2.Invoker.Feature.class) : EnumSet.copyOf(features);
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ProcessApplicationManifest, ApkCreationConfig> {
        protected final ApkCreationConfig creationConfig;
        protected final boolean isAdvancedProfilingOn;

        public CreationAction(ApkCreationConfig creationConfig, boolean isAdvancedProfilingOn) {
            super(creationConfig);
            this.creationConfig = creationConfig;
            this.isAdvancedProfilingOn = isAdvancedProfilingOn;
        }

        @Override
        public String getName() {
            return this.computeTaskName("process", "Manifest");
        }

        @Override
        public Class<ProcessApplicationManifest> getType() {
            return ProcessApplicationManifest.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            VariantType variantType = this.creationConfig.getVariantType();
            Preconditions.checkState((!variantType.isTestComponent() ? 1 : 0) != 0);
            BuildArtifactsHolder artifacts2 = this.creationConfig.getArtifacts();
            artifacts2.republish(InternalArtifactType.MERGED_MANIFESTS.INSTANCE, InternalArtifactType.MANIFEST_METADATA.INSTANCE);
        }

        @Override
        public void handleProvider(TaskProvider<? extends ProcessApplicationManifest> taskProvider) {
            super.handleProvider(taskProvider);
            this.creationConfig.getTaskContainer().setProcessManifestTask(taskProvider);
            BuildArtifactsHolder artifacts2 = this.creationConfig.getArtifacts();
            artifacts2.producesDir(InternalArtifactType.MERGED_MANIFESTS.INSTANCE, taskProvider, ManifestProcessorTask::getManifestOutputDirectory, "");
            artifacts2.producesDir(InternalArtifactType.INSTANT_APP_MANIFEST.INSTANCE, taskProvider, ManifestProcessorTask::getInstantAppManifestOutputDirectory, "");
            artifacts2.producesFile(InternalArtifactType.MANIFEST_MERGE_BLAME_FILE.INSTANCE, taskProvider, ManifestProcessorTask::getMergeBlameFile, "manifest-merger-blame-" + this.creationConfig.getBaseName() + "-report.txt");
            artifacts2.producesDir(InternalArtifactType.METADATA_FEATURE_MANIFEST.INSTANCE, taskProvider, ManifestProcessorTask::getMetadataFeatureManifestOutputDirectory, "metadata-feature");
            artifacts2.producesDir(InternalArtifactType.BUNDLE_MANIFEST.INSTANCE, taskProvider, ManifestProcessorTask::getBundleManifestOutputDirectory, "bundle-manifest");
            this.creationConfig.getArtifacts().producesFile(InternalArtifactType.MANIFEST_MERGE_REPORT.INSTANCE, taskProvider, ManifestProcessorTask::getReportFile, FileUtils.join((File)this.creationConfig.getGlobalScope().getOutputsDir(), (String[])new String[]{"logs"}).getAbsolutePath(), "manifest-merger-" + this.creationConfig.getBaseName() + "-report.txt");
        }

        @Override
        public void configure(ProcessApplicationManifest task) {
            super.configure(task);
            VariantSources variantSources = this.creationConfig.getVariantSources();
            GlobalScope globalScope = this.creationConfig.getGlobalScope();
            VariantType variantType = this.creationConfig.getVariantType();
            Project project2 = globalScope.getProject();
            task.manifests = this.creationConfig.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            if (this.creationConfig.getTaskContainer().getMicroApkTask() != null && this.creationConfig.getEmbedsMicroApp()) {
                task.microApkManifest = (FileCollection)project2.files(new Object[]{this.creationConfig.getPaths().getMicroApkManifestFile()});
            }
            BuildArtifactsHolder artifacts2 = this.creationConfig.getArtifacts();
            artifacts2.setTaskInputToFinalProduct(InternalArtifactType.COMPATIBLE_SCREEN_MANIFEST.INSTANCE, task.getCompatibleScreensManifest());
            task.getApplicationId().set(this.creationConfig.getApplicationId());
            task.getApplicationId().disallowChanges();
            task.getVariantType().set((Object)this.creationConfig.getVariantType().toString());
            task.getVariantType().disallowChanges();
            task.getMinSdkVersion().set(project2.provider(() -> this.creationConfig.getMinSdkVersion().getApiString()));
            task.getMinSdkVersion().disallowChanges();
            task.getTargetSdkVersion().set(project2.provider(() -> {
                ApiVersion targetSdk = this.creationConfig.getTargetSdkVersion();
                return targetSdk.getApiLevel() < 1 ? null : targetSdk.getApiString();
            }));
            task.getTargetSdkVersion().disallowChanges();
            task.getMaxSdkVersion().set(project2.provider(this.creationConfig::getMaxSdkVersion));
            task.getMaxSdkVersion().disallowChanges();
            task.getOptionalFeatures().set(project2.provider(() -> ProcessApplicationManifest.getOptionalFeatures(this.creationConfig, this.isAdvancedProfilingOn)));
            task.getOptionalFeatures().disallowChanges();
            this.creationConfig.getOutputs().getEnabledVariantOutputs().forEach(arg_0 -> task.getVariantOutputs().add(arg_0));
            task.getVariantOutputs().disallowChanges();
            if (variantType.isBaseModule()) {
                task.featureManifests = this.creationConfig.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.REVERSE_METADATA_FEATURE_MANIFEST);
            } else if (variantType.isDynamicFeature()) {
                DynamicFeatureCreationConfig dfCreationConfig = (DynamicFeatureCreationConfig)this.creationConfig;
                HasConfigurableValuesKt.setDisallowChanges(task.getFeatureName(), dfCreationConfig.getFeatureName());
                HasConfigurableValuesKt.setDisallowChanges(task.baseModuleDebuggable, dfCreationConfig.getBaseModuleDebuggable());
                HasConfigurableValuesKt.setDisallowChanges(task.baseModuleVersionCode, dfCreationConfig.getBaseModuleVersionCode());
                HasConfigurableValuesKt.setDisallowChanges(task.baseModuleVersionName, dfCreationConfig.getBaseModuleVersionName());
                task.dependencyFeatureNameArtifacts = this.creationConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.FEATURE_NAME);
            }
            if (!globalScope.getExtension().getAaptOptions().getNamespaced()) {
                task.navigationJsons = (FileCollection)project2.files(new Object[]{this.creationConfig.getArtifacts().getFinalProduct(InternalArtifactType.NAVIGATION_JSON.INSTANCE), this.creationConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.NAVIGATION_JSON)});
            }
            task.packageOverride.set(this.creationConfig.getApplicationId());
            task.packageOverride.disallowChanges();
            task.manifestPlaceholders.set(task.getProject().provider(this.creationConfig::getManifestPlaceholders));
            task.manifestPlaceholders.disallowChanges();
            task.getMainManifest().set(project2.provider(variantSources::getMainManifestFilePath));
            task.getMainManifest().disallowChanges();
            task.manifestOverlays.set(task.getProject().provider(variantSources::getManifestOverlays));
            task.manifestOverlays.disallowChanges();
            task.isFeatureSplitVariantType = this.creationConfig.getVariantType().isDynamicFeature();
            task.buildTypeName = this.creationConfig.getBuildType();
        }

        public static class ManifestProviderImpl
        implements ManifestProvider {
            private final File manifest;
            private final String name;

            public ManifestProviderImpl(File manifest, String name2) {
                this.manifest = manifest;
                this.name = name2;
            }

            public File getManifest() {
                return this.manifest;
            }

            public String getName() {
                return this.name;
            }
        }
    }
}

