/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.AbstractProductFlavor;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantAttributesProvider;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.Serializable;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u000234B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\rJ\u000e\u0010-\u001a\u00020\r2\u0006\u0010,\u001a\u00020\rJ\u000e\u0010.\u001a\u00020\r2\u0006\u0010,\u001a\u00020\rJ\u0010\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u0007J\u0012\u00102\u001a\u0004\u0018\u00010\r2\b\b\u0002\u00101\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0019\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0018R\u0013\u0010%\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0018R\u0013\u0010'\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0018R\u0013\u0010)\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0018\u00a8\u00065"}, d2={"Lcom/android/builder/core/VariantAttributesProvider;", "", "mergedFlavor", "Lcom/android/builder/model/ProductFlavor;", "buildType", "Lcom/android/builder/model/BuildType;", "isTestVariant", "", "manifestSupplier", "Lcom/android/builder/core/ManifestAttributeSupplier;", "manifestFile", "Ljava/io/File;", "fullName", "", "(Lcom/android/builder/model/ProductFlavor;Lcom/android/builder/model/BuildType;ZLcom/android/builder/core/ManifestAttributeSupplier;Ljava/io/File;Ljava/lang/String;)V", "extractNativeLibs", "getExtractNativeLibs", "()Ljava/lang/Boolean;", "functionalTest", "getFunctionalTest", "handleProfiling", "getHandleProfiling", "idOverride", "getIdOverride", "()Ljava/lang/String;", "instrumentationRunner", "getInstrumentationRunner", "manifestVersionCodeSupplier", "Ljava/util/function/IntSupplier;", "getManifestVersionCodeSupplier", "()Ljava/util/function/IntSupplier;", "manifestVersionNameSupplier", "Ljava/util/function/Supplier;", "getManifestVersionNameSupplier", "()Ljava/util/function/Supplier;", "packageName", "getPackageName", "split", "getSplit", "targetPackage", "getTargetPackage", "testLabel", "getTestLabel", "getApplicationId", "testedPackage", "getOriginalApplicationId", "getTestApplicationId", "getVersionCode", "", "ignoreManifest", "getVersionName", "ManifestVersionCodeSupplier", "ManifestVersionNameSupplier", "gradle"})
public final class VariantAttributesProvider {
    private final ProductFlavor mergedFlavor;
    private final BuildType buildType;
    private final boolean isTestVariant;
    private final ManifestAttributeSupplier manifestSupplier;
    private final File manifestFile;
    private final String fullName;

    @Nullable
    public final String getIdOverride() {
        String idName = this.mergedFlavor.getApplicationId();
        String idSuffix = AbstractProductFlavor.Companion.mergeApplicationIdSuffix(this.buildType.getApplicationIdSuffix(), this.mergedFlavor.getApplicationIdSuffix());
        CharSequence charSequence = idSuffix;
        boolean bl = false;
        if (!(charSequence.length() == 0)) {
            String string = idName;
            if (string == null) {
                string = this.getPackageName();
            }
            idName = string;
            idName = idSuffix.charAt(0) == '.' ? idName + idSuffix : idName + '.' + idSuffix;
        }
        return idName;
    }

    @NotNull
    public final String getPackageName() {
        Preconditions.checkState((!this.isTestVariant ? 1 : 0) != 0);
        String string = this.manifestSupplier.getPackage();
        if (string == null) {
            throw (Throwable)new RuntimeException("Cannot read packageName from " + this.manifestFile.getAbsolutePath());
        }
        return string;
    }

    @Nullable
    public final String getSplit() {
        return this.manifestSupplier.getSplit();
    }

    @Nullable
    public final String getVersionName(boolean ignoreManifest) {
        String versionSuffix;
        String versionName = this.mergedFlavor.getVersionName();
        if (versionName == null && !this.isTestVariant && !ignoreManifest) {
            versionName = this.manifestSupplier.getVersionName();
        }
        if ((versionSuffix = AbstractProductFlavor.Companion.mergeVersionNameSuffix(this.buildType.getVersionNameSuffix(), this.mergedFlavor.getVersionNameSuffix())) != null) {
            CharSequence charSequence = versionSuffix;
            boolean bl = false;
            if (charSequence.length() > 0) {
                versionName = Strings.nullToEmpty((String)versionName) + versionSuffix;
            }
        }
        return versionName;
    }

    public static /* synthetic */ String getVersionName$default(VariantAttributesProvider variantAttributesProvider, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return variantAttributesProvider.getVersionName(bl);
    }

    public final int getVersionCode(boolean ignoreManifest) {
        int versionCode;
        Integer n = this.mergedFlavor.getVersionCode();
        int n2 = versionCode = n != null ? n : -1;
        if (versionCode == -1 && !this.isTestVariant && !ignoreManifest) {
            versionCode = this.manifestSupplier.getVersionCode();
        }
        return versionCode;
    }

    public static /* synthetic */ int getVersionCode$default(VariantAttributesProvider variantAttributesProvider, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return variantAttributesProvider.getVersionCode(bl);
    }

    @Nullable
    public final String getInstrumentationRunner() {
        String string = this.mergedFlavor.getTestInstrumentationRunner();
        if (string == null) {
            string = this.manifestSupplier.getInstrumentationRunner();
        }
        return string;
    }

    @Nullable
    public final String getTargetPackage() {
        return this.manifestSupplier.getTargetPackage();
    }

    @Nullable
    public final Boolean getFunctionalTest() {
        Boolean bl = this.mergedFlavor.getTestFunctionalTest();
        if (bl == null) {
            bl = this.manifestSupplier.getFunctionalTest();
        }
        return bl;
    }

    @Nullable
    public final Boolean getHandleProfiling() {
        Boolean bl = this.mergedFlavor.getTestHandleProfiling();
        if (bl == null) {
            bl = this.manifestSupplier.getHandleProfiling();
        }
        return bl;
    }

    @Nullable
    public final String getTestLabel() {
        return this.manifestSupplier.getTestLabel();
    }

    @Nullable
    public final Boolean getExtractNativeLibs() {
        return this.manifestSupplier.getExtractNativeLibs();
    }

    @NotNull
    public final String getApplicationId(@NotNull String testedPackage) {
        Intrinsics.checkParameterIsNotNull((Object)testedPackage, (String)"testedPackage");
        String id = null;
        if (this.isTestVariant) {
            id = this.mergedFlavor.getTestApplicationId();
            if (id == null) {
                id = testedPackage + ".test";
            } else if (Intrinsics.areEqual((Object)id, (Object)testedPackage)) {
                throw (Throwable)new RuntimeException("Application and test application id cannot be the same: both are " + id + " for " + this.fullName);
            }
        } else {
            String string = this.getIdOverride();
            if (string == null) {
                string = this.getPackageName();
            }
            id = string;
        }
        return id;
    }

    @NotNull
    public final String getOriginalApplicationId(@NotNull String testedPackage) {
        Intrinsics.checkParameterIsNotNull((Object)testedPackage, (String)"testedPackage");
        return this.isTestVariant ? this.getApplicationId(testedPackage) : this.getPackageName();
    }

    @NotNull
    public final String getTestApplicationId(@NotNull String testedPackage) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)testedPackage, (String)"testedPackage");
        Preconditions.checkState((boolean)this.isTestVariant);
        if (!Strings.isNullOrEmpty((String)this.mergedFlavor.getTestApplicationId())) {
            string = this.mergedFlavor.getTestApplicationId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            string = this.getApplicationId(testedPackage);
        }
        return string;
    }

    @NotNull
    public final Supplier<String> getManifestVersionNameSupplier() {
        File file = this.isTestVariant ? null : this.manifestFile;
        String versionSuffix = AbstractProductFlavor.Companion.mergeVersionNameSuffix(this.buildType.getVersionNameSuffix(), this.mergedFlavor.getVersionNameSuffix());
        return new ManifestVersionNameSupplier(file, this.manifestSupplier.isManifestFileRequired(), versionSuffix);
    }

    @NotNull
    public final IntSupplier getManifestVersionCodeSupplier() {
        File file = this.isTestVariant ? null : this.manifestFile;
        return new ManifestVersionCodeSupplier(file, this.manifestSupplier.isManifestFileRequired());
    }

    public VariantAttributesProvider(@NotNull ProductFlavor mergedFlavor, @NotNull BuildType buildType, boolean isTestVariant, @NotNull ManifestAttributeSupplier manifestSupplier, @NotNull File manifestFile, @NotNull String fullName) {
        Intrinsics.checkParameterIsNotNull((Object)mergedFlavor, (String)"mergedFlavor");
        Intrinsics.checkParameterIsNotNull((Object)buildType, (String)"buildType");
        Intrinsics.checkParameterIsNotNull((Object)manifestSupplier, (String)"manifestSupplier");
        Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
        Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
        this.mergedFlavor = mergedFlavor;
        this.buildType = buildType;
        this.isTestVariant = isTestVariant;
        this.manifestSupplier = manifestSupplier;
        this.manifestFile = manifestFile;
        this.fullName = fullName;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003B%\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/builder/core/VariantAttributesProvider$ManifestVersionNameSupplier;", "Ljava/util/function/Supplier;", "", "Ljava/io/Serializable;", "manifestFile", "Ljava/io/File;", "isManifestFileRequired", "", "versionSuffix", "(Ljava/io/File;ZLjava/lang/String;)V", "isCached", "versionName", "get", "gradle"})
    private static final class ManifestVersionNameSupplier
    implements Supplier<String>,
    Serializable {
        private boolean isCached;
        private String versionName;
        private final File manifestFile;
        private final boolean isManifestFileRequired;
        private final String versionSuffix;

        @Override
        @Nullable
        public String get() {
            if (this.isCached) {
                return this.versionName;
            }
            if (this.manifestFile != null) {
                this.versionName = new DefaultManifestParser(this.manifestFile, (BooleanSupplier)get.1.INSTANCE, this.isManifestFileRequired, null).getVersionName();
            }
            if (this.versionSuffix != null) {
                CharSequence charSequence = this.versionSuffix;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    this.versionName = Strings.nullToEmpty((String)this.versionName) + this.versionSuffix;
                }
            }
            this.isCached = true;
            return this.versionName;
        }

        public ManifestVersionNameSupplier(@Nullable File manifestFile, boolean isManifestFileRequired, @Nullable String versionSuffix) {
            this.manifestFile = manifestFile;
            this.isManifestFileRequired = isManifestFileRequired;
            this.versionSuffix = versionSuffix;
        }

        public /* synthetic */ ManifestVersionNameSupplier(File file, boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                file = null;
            }
            if ((n & 4) != 0) {
                string = null;
            }
            this(file, bl, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/builder/core/VariantAttributesProvider$ManifestVersionCodeSupplier;", "Ljava/util/function/IntSupplier;", "Ljava/io/Serializable;", "manifestFile", "Ljava/io/File;", "isManifestFileRequired", "", "(Ljava/io/File;Z)V", "isCached", "versionCode", "", "getAsInt", "gradle"})
    private static final class ManifestVersionCodeSupplier
    implements IntSupplier,
    Serializable {
        private boolean isCached;
        private int versionCode;
        private final File manifestFile;
        private final boolean isManifestFileRequired;

        @Override
        public int getAsInt() {
            if (this.isCached) {
                return this.versionCode;
            }
            if (this.versionCode == -1 && this.manifestFile != null) {
                this.versionCode = new DefaultManifestParser(this.manifestFile, (BooleanSupplier)getAsInt.1.INSTANCE, this.isManifestFileRequired, null).getVersionCode();
            }
            this.isCached = true;
            return this.versionCode;
        }

        public ManifestVersionCodeSupplier(@Nullable File manifestFile, boolean isManifestFileRequired) {
            this.manifestFile = manifestFile;
            this.isManifestFileRequired = isManifestFileRequired;
            this.versionCode = -1;
        }

        public /* synthetic */ ManifestVersionCodeSupplier(File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                file = null;
            }
            this(file, bl);
        }
    }
}

