/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.ProfilerInitializer;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.ide.common.workers.GradlePluginMBeans;
import com.android.ide.common.workers.ProfileMBean;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H&\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "T", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "Lorg/gradle/workers/WorkAction;", "()V", "execute", "", "run", "Parameters", "gradle"})
public abstract class ProfileAwareWorkAction<T extends Parameters>
implements WorkAction<T> {
    public final void execute() {
        block1: {
            Object object = ((Parameters)this.getParameters()).getProjectName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.projectName.get()");
            ProfileMBean profileMBean = GradlePluginMBeans.INSTANCE.getProfileMBean((String)object);
            if (profileMBean != null) {
                Object object2 = ((Parameters)this.getParameters()).getTaskOwner().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.taskOwner.get()");
                String string = (String)object2;
                Object object3 = ((Parameters)this.getParameters()).getWorkerKey().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.workerKey.get()");
                profileMBean.workerStarted(string, (String)object3);
            }
            this.run();
            Object object4 = ((Parameters)this.getParameters()).getProjectName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"parameters.projectName.get()");
            ProfileMBean profileMBean2 = GradlePluginMBeans.INSTANCE.getProfileMBean((String)object4);
            if (profileMBean2 == null) break block1;
            Object object5 = ((Parameters)this.getParameters()).getTaskOwner().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"parameters.taskOwner.get()");
            String string = (String)object5;
            Object object6 = ((Parameters)this.getParameters()).getWorkerKey().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"parameters.workerKey.get()");
            profileMBean2.workerFinished(string, (String)object6);
        }
    }

    public abstract void run();

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "projectName", "Lorg/gradle/api/provider/Property;", "", "getProjectName", "()Lorg/gradle/api/provider/Property;", "taskOwner", "getTaskOwner", "workerKey", "getWorkerKey", "initializeFromAndroidVariantTask", "", "task", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "gradle"})
    public static abstract class Parameters
    implements WorkParameters {
        @NotNull
        public abstract Property<String> getProjectName();

        @NotNull
        public abstract Property<String> getTaskOwner();

        @NotNull
        public abstract Property<String> getWorkerKey();

        public final void initializeFromAndroidVariantTask(@NotNull AndroidVariantTask task) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                HasConfigurableValuesKt.setDisallowChanges(this.getProjectName(), task.getProjectName());
                String taskOwnerString = task.getPath();
                HasConfigurableValuesKt.setDisallowChanges(this.getTaskOwner(), taskOwnerString);
                String workerKeyString = this.getTaskOwner() + '{' + this.getClass().getName() + this.hashCode();
                HasConfigurableValuesKt.setDisallowChanges(this.getWorkerKey(), workerKeyString);
                Object object = ProfilerInitializer.getListener();
                if (object == null) break block1;
                String string = taskOwnerString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"taskOwnerString");
                if ((object = ((RecordingBuildListener)object).getTaskRecord(string)) != null) {
                    ((TaskProfilingRecord)object).addWorker(workerKeyString, GradleBuildProfileSpan.ExecutionType.WORKER_EXECUTION);
                }
            }
        }
    }
}

