/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CustomClassTransform
extends Transform {
    private final String name;
    private final String path;
    private final boolean addDependencies;
    public static final Set<QualifiedContent.Scope> SCOPE_EXTERNAL = Sets.immutableEnumSet((Enum)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Enum[])new QualifiedContent.Scope[0]);

    public CustomClassTransform(String path, boolean addDependencies) {
        this.name = Files.getNameWithoutExtension((String)path);
        this.path = path;
        this.addDependencies = addDependencies;
    }

    public String getName() {
        return this.name;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return this.addDependencies ? ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES, (Object)((Object)ExtendedContentType.NATIVE_LIBS)) : ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        return ImmutableSet.of((Object)SecondaryFile.nonIncremental((File)new File(this.path)));
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws InterruptedException, IOException {
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        assert (outputProvider != null);
        if (!invocation.isIncremental()) {
            outputProvider.deleteAll();
            if (this.addDependencies) {
                try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.path));){
                    ZipEntry entry;
                    Pattern pattern = Pattern.compile("dependencies/(.*)\\.jar");
                    while ((entry = zis.getNextEntry()) != null && ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) {
                        Matcher matcher = pattern.matcher(entry.getName());
                        if (matcher.matches()) {
                            String name2 = matcher.group(1);
                            File outputJar = outputProvider.getContentLocation(name2, this.getOutputTypes(), SCOPE_EXTERNAL, Format.JAR);
                            Files.createParentDirs((File)outputJar);
                            try (FileOutputStream fos = new FileOutputStream(outputJar);){
                                ByteStreams.copy((InputStream)zis, (OutputStream)fos);
                            }
                        }
                        zis.closeEntry();
                    }
                }
            }
        }
        URL url = new File(this.path).toURI().toURL();
        try (URLClassLoader loader = new URLClassLoader(new URL[]{url});){
            BiConsumer<InputStream, OutputStream> function = this.loadTransformFunction(loader);
            for (TransformInput ti : invocation.getInputs()) {
                for (JarInput jarInput : ti.getJarInputs()) {
                    File inputJar = jarInput.getFile();
                    File outputJar = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                    if (invocation.isIncremental()) {
                        switch (jarInput.getStatus()) {
                            case NOTCHANGED: {
                                break;
                            }
                            case ADDED: 
                            case CHANGED: {
                                this.transformJar(function, inputJar, outputJar);
                                break;
                            }
                            case REMOVED: {
                                FileUtils.delete((File)outputJar);
                            }
                        }
                        continue;
                    }
                    this.transformJar(function, inputJar, outputJar);
                }
                for (DirectoryInput di : ti.getDirectoryInputs()) {
                    File inputDir = di.getFile();
                    File outputDir = outputProvider.getContentLocation(di.getName(), di.getContentTypes(), di.getScopes(), Format.DIRECTORY);
                    if (invocation.isIncremental()) {
                        for (Map.Entry entry : di.getChangedFiles().entrySet()) {
                            File inputFile = (File)entry.getKey();
                            switch ((Status)entry.getValue()) {
                                case NOTCHANGED: {
                                    break;
                                }
                                case ADDED: 
                                case CHANGED: {
                                    if (inputFile.isDirectory() || !inputFile.getName().endsWith(".class")) break;
                                    File out = CustomClassTransform.toOutputFile(outputDir, inputDir, inputFile);
                                    this.transformFile(function, inputFile, out);
                                    break;
                                }
                                case REMOVED: {
                                    File outputFile = CustomClassTransform.toOutputFile(outputDir, inputDir, inputFile);
                                    FileUtils.deleteIfExists((File)outputFile);
                                }
                            }
                        }
                        continue;
                    }
                    for (File in : FileUtils.getAllFiles((File)inputDir)) {
                        if (!in.getName().endsWith(".class")) continue;
                        File out = CustomClassTransform.toOutputFile(outputDir, inputDir, in);
                        this.transformFile(function, in, out);
                    }
                }
            }
        }
    }

    private BiConsumer<InputStream, OutputStream> loadTransformFunction(URLClassLoader loader) {
        Type[] types;
        ServiceLoader<BiConsumer> serviceLoader = ServiceLoader.load(BiConsumer.class, loader);
        ArrayList functions = Lists.newArrayList(serviceLoader.iterator());
        if (functions.isEmpty()) {
            throw new IllegalStateException("Custom transform does not provide a BiConsumer to apply");
        }
        if (functions.size() > 1) {
            throw new IllegalStateException("Custom transform provides more than one BiConsumer to apply");
        }
        BiConsumer uncheckedFunction = (BiConsumer)functions.get(0);
        for (Type type : types = uncheckedFunction.getClass().getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType generic = (ParameterizedType)type;
            Type[] args2 = generic.getActualTypeArguments();
            if (!generic.getRawType().equals(BiConsumer.class) || args2.length != 2 || !args2[0].equals(InputStream.class) || !args2[1].equals(OutputStream.class)) continue;
            return uncheckedFunction;
        }
        throw new IllegalStateException("Custom transform must provide a BiConsumer<InputStream, OutputStream>");
    }

    private void transformJar(BiConsumer<InputStream, OutputStream> function, File inputJar, File outputJar) throws IOException {
        Files.createParentDirs((File)outputJar);
        try (FileInputStream fis = new FileInputStream(inputJar);
             ZipInputStream zis = new ZipInputStream(fis);
             FileOutputStream fos = new FileOutputStream(outputJar);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null && ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) {
                if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                    ZipEntry nextEntry = new ZipEntry(entry.getName());
                    nextEntry.setTime(-1L);
                    zos.putNextEntry(nextEntry);
                    this.apply(function, zis, zos);
                }
                entry = zis.getNextEntry();
            }
        }
    }

    private void transformFile(BiConsumer<InputStream, OutputStream> function, File inputFile, File outputFile) throws IOException {
        Files.createParentDirs((File)outputFile);
        try (FileInputStream fis = new FileInputStream(inputFile);
             FileOutputStream fos = new FileOutputStream(outputFile);){
            this.apply(function, fis, fos);
        }
    }

    private static File toOutputFile(File outputDir, File inputDir, File inputFile) {
        return new File(outputDir, FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
    }

    private void apply(BiConsumer<InputStream, OutputStream> function, InputStream in, OutputStream out) throws IOException {
        try {
            function.accept(in, out);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

