/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.LintBaseTask;
import com.android.utils.StringHelper;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class LintPerVariantTask
extends LintBaseTask
implements VariantAwareTask {
    private LintBaseTask.VariantInputs variantInputs;
    private ConfigurableFileCollection allInputs;
    private boolean fatalOnly;
    private String variantName;

    @Override
    @Internal
    public String getVariantName() {
        return this.variantName;
    }

    @Override
    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    public FileCollection getAllInputs() {
        return this.allInputs;
    }

    @TaskAction
    public void lint() {
        this.runLint(new LintPerVariantTaskDescriptor());
    }

    public static class VitalCreationAction
    extends LintBaseTask.BaseCreationAction<LintPerVariantTask> {
        private final ComponentPropertiesImpl componentProperties;
        private final List<? extends VariantPropertiesImpl> allComponentsWithLint;

        public VitalCreationAction(ComponentPropertiesImpl componentProperties, List<? extends VariantPropertiesImpl> allComponentsWithLint) {
            super(componentProperties.getGlobalScope());
            this.componentProperties = componentProperties;
            this.allComponentsWithLint = allComponentsWithLint;
        }

        @Override
        public String getName() {
            return this.componentProperties.computeTaskName("lintVital");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void configure(LintPerVariantTask task) {
            super.configure(task);
            task.setVariantName(this.componentProperties.getName());
            task.allInputs = this.globalScope.getProject().files(new Object[0]);
            task.variantInputs = new LintBaseTask.VariantInputs(this.componentProperties);
            task.allInputs.from(new Object[]{task.variantInputs.getAllInputs()});
            for (ComponentPropertiesImpl componentPropertiesImpl : this.allComponentsWithLint) {
                LintBaseTask.addModelArtifactsToInputs(task.allInputs, componentPropertiesImpl);
            }
            task.fatalOnly = true;
            task.setDescription("Runs lint on just the fatal issues in the " + task.getVariantName() + " build.");
            task.getEnableGradleWorkers().set((Object)this.componentProperties.getServices().getProjectOptions().get(BooleanOption.ENABLE_GRADLE_WORKERS));
        }
    }

    public static class CreationAction
    extends LintBaseTask.BaseCreationAction<LintPerVariantTask> {
        private final VariantPropertiesImpl variantProperties;
        private final List<? extends VariantPropertiesImpl> allVariants;

        public CreationAction(VariantPropertiesImpl variantProperties, List<? extends VariantPropertiesImpl> allVariants) {
            super(variantProperties.getGlobalScope());
            this.variantProperties = variantProperties;
            this.allVariants = allVariants;
        }

        @Override
        public String getName() {
            return this.variantProperties.computeTaskName("lint");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void configure(LintPerVariantTask lint) {
            super.configure(lint);
            lint.setVariantName(this.variantProperties.getName());
            lint.allInputs = this.globalScope.getProject().files(new Object[0]);
            lint.variantInputs = new LintBaseTask.VariantInputs(this.variantProperties);
            lint.allInputs.from(new Object[]{lint.variantInputs.getAllInputs()});
            for (VariantPropertiesImpl variantPropertiesImpl : this.allVariants) {
                LintBaseTask.addModelArtifactsToInputs(lint.allInputs, variantPropertiesImpl);
            }
            lint.setDescription(StringHelper.appendCapitalized((String)"Runs lint on the ", (String)lint.getVariantName(), (String)" build."));
            lint.getEnableGradleWorkers().set((Object)this.variantProperties.getServices().getProjectOptions().get(BooleanOption.ENABLE_GRADLE_WORKERS));
        }
    }

    private class LintPerVariantTaskDescriptor
    extends LintBaseTask.LintBaseTaskDescriptor {
        private LintPerVariantTaskDescriptor() {
            super(LintPerVariantTask.this);
        }

        public String getVariantName() {
            return LintPerVariantTask.this.getVariantName();
        }

        public LintBaseTask.VariantInputs getVariantInputs(String variantName) {
            assert (variantName.equals(this.getVariantName()));
            return LintPerVariantTask.this.variantInputs;
        }

        public Set<String> getVariantNames() {
            return Collections.singleton(LintPerVariantTask.this.variantName);
        }

        public boolean isFatalOnly() {
            return LintPerVariantTask.this.fatalOnly;
        }
    }
}

