/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.util.RelativizableFile;
import android.databinding.tool.writer.JavaFileWriter;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.WorkerExecutorResourceCompilationService;
import com.android.build.gradle.internal.databinding.MergingFileLookup;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.namespaced.NamespaceRemover;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.Aapt2DaemonBuildService;
import com.android.build.gradle.internal.services.Aapt2DaemonServiceKey;
import com.android.build.gradle.internal.services.Aapt2WorkersBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.Blocks;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.ResourceAwareTask;
import com.android.build.gradle.tasks.ResourceException;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.builder.png.VectorDrawableRenderer;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.resources.CopyToOutputDirectoryResourceCompilationService;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.resources.FileValidity;
import com.android.ide.common.resources.GeneratedResourceSet;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergedResourceWriter;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NoOpResourcePreprocessor;
import com.android.ide.common.resources.ResourceCompilationService;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourcePreprocessor;
import com.android.ide.common.resources.ResourceSet;
import com.android.ide.common.resources.SingleFileProcessor;
import com.android.ide.common.vectordrawable.ResourcesNotSupportedException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import kotlin.Pair;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.slf4j.Logger;

@CacheableTask
public abstract class MergeResources
extends ResourceAwareTask {
    private File generatedPngsOutputDir;
    private boolean processResources;
    private boolean crunchPng;
    private List<ResourceSet> processedInputs;
    private final FileValidity<ResourceSet> fileValidity = new FileValidity();
    private boolean disableVectorDrawables;
    private boolean vectorSupportLibraryIsUsed;
    private Collection<String> generatedDensities;
    private String aapt2Version;
    private File mergedNotCompiledResourcesOutputDirectory;
    private boolean pseudoLocalesEnabled;
    private boolean precompileDependenciesResources;
    private ImmutableSet<Flag> flags;
    private boolean useJvmResourceCompiler;
    private SyncOptions.ErrorFormatMode errorFormatMode;

    @Internal
    public abstract ConfigurableFileCollection getAapt2FromMaven();

    @Input
    public abstract Property<Boolean> getDataBindingEnabled();

    @Input
    public abstract Property<Boolean> getViewBindingEnabled();

    @Input
    @Optional
    public abstract Property<String> getPackageName();

    @Input
    @Optional
    public abstract Property<Boolean> getUseAndroidX();

    @Input
    public abstract SetProperty<String> getResourceDirsOutsideRootProjectDir();

    @Internal
    public abstract Property<Aapt2WorkersBuildService> getAapt2WorkersBuildService();

    @Internal
    public abstract Property<Aapt2DaemonBuildService> getAapt2DaemonBuildService();

    private static ResourceCompilationService getResourceProcessor(String projectName, String owner, FileCollection aapt2FromMaven, WorkerExecutorFacade workerExecutor, SyncOptions.ErrorFormatMode errorFormatMode, ImmutableSet<Flag> flags, boolean processResources, boolean useJvmResourceCompiler, org.gradle.api.logging.Logger logger, Aapt2DaemonBuildService aapt2DaemonBuildService) {
        if (flags.contains((Object)Flag.REMOVE_RESOURCE_NAMESPACES)) {
            return NamespaceRemover.INSTANCE;
        }
        if (!processResources) {
            return CopyToOutputDirectoryResourceCompilationService.INSTANCE;
        }
        Aapt2DaemonServiceKey aapt2ServiceKey = aapt2DaemonBuildService.registerAaptService(aapt2FromMaven.getSingleFile(), new LoggerWrapper(logger));
        return new WorkerExecutorResourceCompilationService(projectName, owner, workerExecutor, aapt2ServiceKey, errorFormatMode, useJvmResourceCompiler);
    }

    @Override
    protected boolean getIncremental() {
        return true;
    }

    @Internal
    public WorkerExecutorFacade getAaptWorkerFacade() {
        return ((Aapt2WorkersBuildService)this.getAapt2WorkersBuildService().get()).getWorkerForAapt2(this.getProjectName(), this.getPath(), this.getWorkerExecutor(), (Boolean)this.getEnableGradleWorkers().get());
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getDataBindingLayoutInfoOutFolder();

    @Internal
    public abstract Property<String> getAaptEnv();

    @Internal
    public abstract RegularFileProperty getProjectRootDir();

    @Override
    protected void doFullTaskAction() throws IOException, JAXBException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        File destinationDir = ((Directory)this.getOutputDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)destinationDir);
        if (this.getDataBindingLayoutInfoOutFolder().isPresent()) {
            FileUtils.deleteDirectoryContents((File)((Directory)this.getDataBindingLayoutInfoOutFolder().get()).getAsFile());
        }
        List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor, (String)this.getAaptEnv().getOrNull());
        ResourceMerger merger = new ResourceMerger(((Integer)this.getMinSdk().get()).intValue());
        MergingLog mergingLog2 = null;
        if (this.getBlameLogOutputFolder().isPresent()) {
            File blameLogFolder = ((Directory)this.getBlameLogOutputFolder().get()).getAsFile();
            FileUtils.cleanOutputDir((File)blameLogFolder);
            mergingLog2 = new MergingLog(blameLogFolder);
        }
        try (WorkerExecutorFacade workerExecutorFacade = this.getAaptWorkerFacade();
             ResourceCompilationService resourceCompiler = MergeResources.getResourceProcessor(this.getProjectName(), this.getPath(), (FileCollection)this.getAapt2FromMaven(), workerExecutorFacade, this.errorFormatMode, this.flags, this.processResources, this.useJvmResourceCompiler, this.getLogger(), (Aapt2DaemonBuildService)this.getAapt2DaemonBuildService().get());){
            SingleFileProcessor dataBindingLayoutProcessor = this.maybeCreateLayoutProcessor();
            Blocks.recordSpan(this.getProjectName(), this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_1, () -> {
                for (ResourceSet resourceSet : resourceSets) {
                    resourceSet.loadFromFiles((ILogger)new LoggerWrapper(this.getLogger()));
                    merger.addDataSet(resourceSet);
                }
            });
            File publicFile = this.getPublicFile().isPresent() ? ((RegularFile)this.getPublicFile().get()).getAsFile() : null;
            MergedResourceWriter writer = new MergedResourceWriter(workerExecutorFacade, destinationDir, publicFile, mergingLog2, preprocessor, resourceCompiler, this.getIncrementalFolder(), dataBindingLayoutProcessor, this.mergedNotCompiledResourcesOutputDirectory, this.pseudoLocalesEnabled, this.getCrunchPng());
            Blocks.recordSpan(this.getProjectName(), this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_2, () -> merger.mergeData((MergeConsumer)writer, false));
            Blocks.recordSpan(this.getProjectName(), this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_3, () -> {
                if (dataBindingLayoutProcessor != null) {
                    dataBindingLayoutProcessor.end();
                }
            });
            Blocks.recordSpan(this.getProjectName(), this.getPath(), GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION_PHASE_4, () -> merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false));
        }
        catch (Exception e) {
            MergingException.findAndReportMergingException((Exception)e, (MessageReceiver)new MessageReceiverImpl(this.errorFormatMode, (Logger)this.getLogger()));
            try {
                throw e;
            }
            catch (MergingException mergingException) {
                merger.cleanBlob(this.getIncrementalFolder());
                throw new ResourceException(mergingException.getMessage(), mergingException);
            }
        }
        finally {
            this.cleanup();
        }
    }

    private boolean isFilteredOutLibraryResource(File changedFile) {
        ArtifactCollection localLibraryResources = this.getResourcesComputer().getLibraries();
        File parentFile = changedFile.getParentFile();
        if (localLibraryResources == null || parentFile.getName().startsWith("values")) {
            return false;
        }
        for (File resDir : localLibraryResources.getArtifactFiles()) {
            if (!parentFile.getAbsolutePath().startsWith(resDir.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, ? extends FileStatus> changedInputs) throws IOException, JAXBException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        ResourceMerger merger = new ResourceMerger(((Integer)this.getMinSdk().get()).intValue());
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true, (String)this.getAaptEnv().getOrNull())) {
                this.doFullTaskAction();
                return;
            }
            if (this.precompileDependenciesResources && (changedInputs = changedInputs.entrySet().stream().filter(fileEntry -> !this.isFilteredOutLibraryResource((File)fileEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
                return;
            }
            for (Object resourceSet : merger.getDataSets()) {
                resourceSet.setPreprocessor(preprocessor);
            }
            List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor, (String)this.getAaptEnv().getOrNull());
            if (!merger.checkValidUpdate(resourceSets)) {
                this.getLogger().info("Changed Resource sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry entry : changedInputs.entrySet()) {
                File changedFile = (File)entry.getKey();
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((ResourceSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, (FileStatus)entry.getValue(), (ILogger)new LoggerWrapper(this.getLogger()))) continue;
                this.getLogger().info(String.format("Failed to process %s event! Full task run", entry.getValue()));
                this.doFullTaskAction();
                return;
            }
            MergingLog mergingLog2 = this.getBlameLogOutputFolder().isPresent() ? new MergingLog(((Directory)this.getBlameLogOutputFolder().get()).getAsFile()) : null;
            try (WorkerExecutorFacade workerExecutorFacade = this.getAaptWorkerFacade();
                 ResourceCompilationService resourceCompiler = MergeResources.getResourceProcessor(this.getProjectName(), this.getPath(), (FileCollection)this.getAapt2FromMaven(), workerExecutorFacade, this.errorFormatMode, this.flags, this.processResources, this.useJvmResourceCompiler, this.getLogger(), (Aapt2DaemonBuildService)this.getAapt2DaemonBuildService().get());){
                SingleFileProcessor dataBindingLayoutProcessor = this.maybeCreateLayoutProcessor();
                File publicFile = this.getPublicFile().isPresent() ? ((RegularFile)this.getPublicFile().get()).getAsFile() : null;
                MergedResourceWriter writer = new MergedResourceWriter(workerExecutorFacade, ((Directory)this.getOutputDir().get()).getAsFile(), publicFile, mergingLog2, preprocessor, resourceCompiler, this.getIncrementalFolder(), dataBindingLayoutProcessor, this.mergedNotCompiledResourcesOutputDirectory, this.pseudoLocalesEnabled, this.getCrunchPng());
                merger.mergeData((MergeConsumer)writer, false);
                if (dataBindingLayoutProcessor != null) {
                    dataBindingLayoutProcessor.end();
                }
                merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
            }
        }
        catch (Exception e) {
            MergingException.findAndReportMergingException((Exception)e, (MessageReceiver)new MessageReceiverImpl(this.errorFormatMode, (Logger)this.getLogger()));
            try {
                throw e;
            }
            catch (MergingException mergingException) {
                merger.cleanBlob(this.getIncrementalFolder());
                throw new ResourceException(mergingException.getMessage(), mergingException);
            }
        }
        finally {
            this.cleanup();
        }
    }

    private SingleFileProcessor maybeCreateLayoutProcessor() {
        if (!((Boolean)this.getDataBindingEnabled().get()).booleanValue() && !((Boolean)this.getViewBindingEnabled().get()).booleanValue()) {
            return null;
        }
        LayoutXmlProcessor.OriginalFileLookup fileLookup = this.getBlameLogOutputFolder().isPresent() ? new MergingFileLookup(((Directory)this.getBlameLogOutputFolder().get()).getAsFile()) : file -> null;
        final LayoutXmlProcessor processor2 = new LayoutXmlProcessor((String)this.getPackageName().get(), new JavaFileWriter(){

            public void writeToFile(String canonicalName, String contents) {
                throw new UnsupportedOperationException("Not supported in this mode");
            }

            public void deleteFile(String canonicalName) {
                throw new UnsupportedOperationException("Not supported in this mode");
            }
        }, fileLookup, ((Boolean)this.getUseAndroidX().get()).booleanValue());
        return new SingleFileProcessor(){

            private LayoutXmlProcessor getProcessor() {
                return processor2;
            }

            public boolean processSingleFile(File inputFile, File outputFile, Boolean inputFileIsFromDependency) throws Exception {
                RelativizableFile normalizedInputFile;
                if (inputFileIsFromDependency == Boolean.TRUE) {
                    return false;
                }
                File rootProjectDir = (File)MergeResources.this.getProjectRootDir().getAsFile().get();
                if (FileUtils.isFileInDirectory((File)inputFile, (File)rootProjectDir)) {
                    Preconditions.checkState((!this.resourceIsInResourceDirs(inputFile, (Set)MergeResources.this.getResourceDirsOutsideRootProjectDir().get()) ? 1 : 0) != 0, (Object)(inputFile.getAbsolutePath() + " should not be annotated as @Input"));
                    normalizedInputFile = RelativizableFile.fromAbsoluteFile((File)inputFile.getCanonicalFile(), (File)rootProjectDir);
                    Preconditions.checkState((normalizedInputFile.getRelativeFile() != null ? 1 : 0) != 0);
                } else {
                    Preconditions.checkState((boolean)this.resourceIsInResourceDirs(inputFile, (Set)MergeResources.this.getResourceDirsOutsideRootProjectDir().get()), (Object)(inputFile.getAbsolutePath() + " is not annotated as @Input"));
                    normalizedInputFile = RelativizableFile.fromAbsoluteFile((File)inputFile.getCanonicalFile(), null);
                    Preconditions.checkState((normalizedInputFile.getRelativeFile() == null ? 1 : 0) != 0);
                }
                return this.getProcessor().processSingleFile(normalizedInputFile, outputFile, ((Boolean)MergeResources.this.getViewBindingEnabled().get()).booleanValue(), ((Boolean)MergeResources.this.getDataBindingEnabled().get()).booleanValue());
            }

            private boolean resourceIsInResourceDirs(File resFile, Set<String> resDirs) {
                return resDirs.stream().anyMatch(resDir -> FileUtils.isFileInDirectory((File)resFile, (File)new File((String)resDir)));
            }

            public void processRemovedFile(File file) {
                this.getProcessor().processRemovedFile(file);
            }

            public void processFileWithNoDataBinding(File file) {
                this.getProcessor().processFileWithNoDataBinding(file);
            }

            public void end() throws JAXBException {
                this.getProcessor().writeLayoutInfoFiles(((Directory)MergeResources.this.getDataBindingLayoutInfoOutFolder().get()).getAsFile());
            }
        };
    }

    private ResourcePreprocessor getPreprocessor() {
        if (this.disableVectorDrawables) {
            return NoOpResourcePreprocessor.INSTANCE;
        }
        Collection densities = this.getGeneratedDensities().stream().map(Density::getEnum).collect(Collectors.toList());
        return new MergeResourcesVectorDrawableRenderer((Integer)this.getMinSdk().get(), this.vectorSupportLibraryIsUsed, this.generatedPngsOutputDir, densities, LoggerWrapper.supplierFor(MergeResources.class));
    }

    private List<ResourceSet> getConfiguredResourceSets(ResourcePreprocessor preprocessor, String aaptEnv) {
        if (this.processedInputs == null) {
            this.processedInputs = this.getResourcesComputer().compute(this.precompileDependenciesResources, aaptEnv);
            ArrayList<GeneratedResourceSet> generatedSets = new ArrayList<GeneratedResourceSet>(this.processedInputs.size());
            for (ResourceSet resourceSet : this.processedInputs) {
                resourceSet.setPreprocessor(preprocessor);
                GeneratedResourceSet generatedSet = new GeneratedResourceSet(resourceSet, aaptEnv);
                resourceSet.setGeneratedSet((ResourceSet)generatedSet);
                generatedSets.add(generatedSet);
            }
            for (int i2 = 0; i2 < generatedSets.size(); ++i2) {
                this.processedInputs.add(2 * i2, (ResourceSet)generatedSets.get(i2));
            }
        }
        return this.processedInputs;
    }

    private void cleanup() {
        this.fileValidity.clear();
        this.processedInputs = null;
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Input
    public boolean getCrunchPng() {
        return this.crunchPng;
    }

    @Input
    public boolean getProcessResources() {
        return this.processResources;
    }

    @Optional
    @OutputFile
    public abstract RegularFileProperty getPublicFile();

    @Input
    public boolean isValidateEnabled() {
        return this.getResourcesComputer().getValidateEnabled();
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getBlameLogOutputFolder();

    @Optional
    @OutputDirectory
    public File getGeneratedPngsOutputDir() {
        return this.generatedPngsOutputDir;
    }

    @Input
    public Collection<String> getGeneratedDensities() {
        return this.generatedDensities;
    }

    @Input
    public abstract Property<Integer> getMinSdk();

    @Input
    public boolean isVectorSupportLibraryUsed() {
        return this.vectorSupportLibraryIsUsed;
    }

    @Input
    public String getAapt2Version() {
        return this.aapt2Version;
    }

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getMergedNotCompiledResourcesOutputDirectory();

    @Input
    public boolean isPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    @Input
    public String getFlags() {
        return this.flags.stream().map(Enum::name).sorted().collect(Collectors.joining(","));
    }

    @Input
    public boolean isJvmResourceCompilerEnabled() {
        return this.useJvmResourceCompiler;
    }

    public static enum Flag {
        REMOVE_RESOURCE_NAMESPACES,
        PROCESS_VECTOR_DRAWABLES;

    }

    public static class CreationAction
    extends VariantTaskCreationAction<MergeResources, ComponentPropertiesImpl> {
        private final TaskManager.MergeType mergeType;
        private final String taskNamePrefix;
        private final File mergedNotCompiledOutputDirectory;
        private final boolean includeDependencies;
        private final boolean processResources;
        private final boolean processVectorDrawables;
        private final ImmutableSet<Flag> flags;
        private boolean isLibrary;

        public CreationAction(ComponentPropertiesImpl componentProperties, TaskManager.MergeType mergeType, String taskNamePrefix, File mergedNotCompiledOutputDirectory, boolean includeDependencies, boolean processResources, ImmutableSet<Flag> flags, boolean isLibrary) {
            super(componentProperties);
            this.mergeType = mergeType;
            this.taskNamePrefix = taskNamePrefix;
            this.mergedNotCompiledOutputDirectory = mergedNotCompiledOutputDirectory;
            this.includeDependencies = includeDependencies;
            this.processResources = processResources;
            this.processVectorDrawables = flags.contains((Object)Flag.PROCESS_VECTOR_DRAWABLES);
            this.flags = flags;
            this.isLibrary = isLibrary;
        }

        @Override
        public String getName() {
            return this.computeTaskName(this.taskNamePrefix, "Resources");
        }

        @Override
        public Class<MergeResources> getType() {
            return MergeResources.class;
        }

        @Override
        public void handleProvider(TaskProvider<MergeResources> taskProvider) {
            super.handleProvider(taskProvider);
            ((ComponentPropertiesImpl)this.creationConfig).getTaskContainer().setMergeResourcesTask(taskProvider);
            ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, MergeResources::getDataBindingLayoutInfoOutFolder).withName("out").on(this.mergeType == TaskManager.MergeType.MERGE ? InternalArtifactType.DATA_BINDING_LAYOUT_INFO_TYPE_MERGE.INSTANCE : InternalArtifactType.DATA_BINDING_LAYOUT_INFO_TYPE_PACKAGE.INSTANCE);
            if (this.includeDependencies) {
                ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, MergeResources::getBlameLogOutputFolder).withName("out").on(InternalArtifactType.MERGED_RES_BLAME_FOLDER.INSTANCE);
            }
        }

        @Override
        public void configure(MergeResources task) {
            super.configure(task);
            VariantScope variantScope = ((ComponentPropertiesImpl)this.creationConfig).getVariantScope();
            GlobalScope globalScope = ((ComponentPropertiesImpl)this.creationConfig).getGlobalScope();
            VariantPathHelper paths = ((ComponentPropertiesImpl)this.creationConfig).getPaths();
            task.getMinSdk().set(globalScope.getProject().provider(() -> ((ComponentPropertiesImpl)this.creationConfig).getMinSdkVersion().getApiLevel()));
            task.getMinSdk().disallowChanges();
            Pair<FileCollection, String> aapt2AndVersion = Aapt2MavenUtils.getAapt2FromMavenAndVersion(globalScope);
            task.getAapt2FromMaven().from(new Object[]{aapt2AndVersion.getFirst()});
            task.aapt2Version = (String)aapt2AndVersion.getSecond();
            task.setIncrementalFolder(paths.getIncrementalDir(this.getName()));
            task.processResources = this.processResources;
            task.crunchPng = variantScope.isCrunchPngs();
            VectorDrawablesOptions vectorDrawablesOptions = ((ComponentPropertiesImpl)this.creationConfig).getVariantDslInfo().getVectorDrawables();
            task.generatedDensities = vectorDrawablesOptions.getGeneratedDensities();
            if (task.generatedDensities == null) {
                task.generatedDensities = Collections.emptySet();
            }
            task.disableVectorDrawables = !this.processVectorDrawables || task.generatedDensities.isEmpty();
            task.vectorSupportLibraryIsUsed = Boolean.TRUE.equals(vectorDrawablesOptions.getUseSupportLibrary());
            task.getResourcesComputer().initFromVariantScope((ComponentPropertiesImpl)this.creationConfig, this.includeDependencies);
            if (!task.disableVectorDrawables) {
                task.generatedPngsOutputDir = paths.getGeneratedPngsOutputDir();
            }
            BuildFeatureValues features = ((ComponentPropertiesImpl)this.creationConfig).getBuildFeatures();
            boolean isDataBindingEnabled = features.getDataBinding();
            boolean isViewBindingEnabled = features.getViewBinding();
            HasConfigurableValuesKt.setDisallowChanges(task.getDataBindingEnabled(), isDataBindingEnabled);
            HasConfigurableValuesKt.setDisallowChanges(task.getViewBindingEnabled(), isViewBindingEnabled);
            if (isDataBindingEnabled || isViewBindingEnabled) {
                HasConfigurableValuesKt.setDisallowChanges(task.getPackageName(), ((ComponentPropertiesImpl)this.creationConfig).getVariantDslInfo().getPackageName());
                HasConfigurableValuesKt.setDisallowChanges(task.getUseAndroidX(), ((ComponentPropertiesImpl)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.USE_ANDROID_X));
            }
            task.mergedNotCompiledResourcesOutputDirectory = this.mergedNotCompiledOutputDirectory;
            task.pseudoLocalesEnabled = ((ComponentPropertiesImpl)this.creationConfig).getVariantDslInfo().isPseudoLocalesEnabled();
            task.flags = this.flags;
            task.errorFormatMode = SyncOptions.getErrorFormatMode(((ComponentPropertiesImpl)this.creationConfig).getServices().getProjectOptions());
            task.precompileDependenciesResources = this.mergeType.equals((Object)TaskManager.MergeType.MERGE) && !this.isLibrary && variantScope.isPrecompileDependenciesResourcesEnabled();
            task.getResourceDirsOutsideRootProjectDir().set(globalScope.getProject().provider(() -> {
                HashSet<String> resourceDirsOutsideRootProjectDir = new HashSet<String>();
                if (!isDataBindingEnabled && !isViewBindingEnabled) {
                    return resourceDirsOutsideRootProjectDir;
                }
                File rootProjectDir = task.getProject().getRootDir();
                for (FileCollection resDirs : task.getLocalResources()) {
                    for (File resDir : resDirs.getFiles()) {
                        if (FileUtils.isFileInDirectory((File)resDir, (File)rootProjectDir)) continue;
                        resourceDirsOutsideRootProjectDir.add(resDir.getCanonicalPath());
                    }
                }
                return resourceDirsOutsideRootProjectDir;
            }));
            task.getResourceDirsOutsideRootProjectDir().disallowChanges();
            task.dependsOn(new Object[]{((ComponentPropertiesImpl)this.creationConfig).getTaskContainer().getResourceGenTask()});
            task.getInputs().files(new Object[]{task.getLocalResources()}).withPathSensitivity(this.processResources ? PathSensitivity.ABSOLUTE : PathSensitivity.RELATIVE).withPropertyName("rawLocalResources");
            task.useJvmResourceCompiler = ((ComponentPropertiesImpl)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_JVM_RESOURCE_COMPILER);
            HasConfigurableValuesKt.setDisallowChanges(task.getAapt2WorkersBuildService(), BuildServicesKt.getBuildService(((ComponentPropertiesImpl)this.creationConfig).getServices().getBuildServiceRegistry(), Aapt2WorkersBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getAapt2DaemonBuildService(), BuildServicesKt.getBuildService(((ComponentPropertiesImpl)this.creationConfig).getServices().getBuildServiceRegistry(), Aapt2DaemonBuildService.class));
            task.getAaptEnv().set(((ComponentPropertiesImpl)this.creationConfig).getServices().getGradleEnvironmentProvider().getEnvVariable("ANDROID_AAPT_IGNORE"));
            task.getProjectRootDir().set(task.getProject().getRootDir());
        }
    }

    private static class MergeResourcesVectorDrawableRenderer
    extends VectorDrawableRenderer {
        public MergeResourcesVectorDrawableRenderer(int minSdk, boolean supportLibraryIsUsed, File outputDir, Collection<Density> densities, Supplier<ILogger> loggerSupplier) {
            super(minSdk, supportLibraryIsUsed, outputDir, densities, loggerSupplier);
        }

        public void generateFile(File toBeGenerated, File original) throws IOException {
            try {
                super.generateFile(toBeGenerated, original);
            }
            catch (ResourcesNotSupportedException e) {
                throw new GradleException(String.format("Can't process attribute %1$s=\"%2$s\": references to other resources are not supported by build-time PNG generation.\n%3$s\nSee http://developer.android.com/tools/help/vector-asset-studio.html for details.", e.getName(), e.getValue(), this.getPreprocessingReasonDescription(original)));
            }
        }
    }
}

