/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkR19Info$WhenMappings;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkR19Info;", "Lcom/android/build/gradle/internal/ndk/DefaultNdkInfo;", "root", "Ljava/io/File;", "(Ljava/io/File;)V", "getRoot", "()Ljava/io/File;", "supportedStls", "", "Lcom/android/build/gradle/internal/ndk/Stl;", "getSupportedStls", "()Ljava/util/List;", "getDefaultStl", "buildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "getObjcopyExecutable", "abi", "Lcom/android/build/gradle/internal/core/Abi;", "getStlSharedObjectFile", "stl", "getStripExecutable", "getToolchainAbi", "validate", "", "gradle"})
public class NdkR19Info
extends DefaultNdkInfo {
    @NotNull
    private final List<Stl> supportedStls;
    @NotNull
    private final File root;

    @Override
    @NotNull
    public List<Stl> getSupportedStls() {
        return this.supportedStls;
    }

    @Override
    @NotNull
    protected Abi getToolchainAbi(@NotNull Abi abi) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        return abi == Abi.MIPS ? Abi.MIPS64 : abi;
    }

    @Override
    @NotNull
    public Stl getDefaultStl(@NotNull NativeBuildSystem buildSystem2) {
        Stl stl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)buildSystem2), (String)"buildSystem");
        switch (NdkR19Info$WhenMappings.$EnumSwitchMapping$0[buildSystem2.ordinal()]) {
            case 1: {
                stl = Stl.LIBCXX_STATIC;
                break;
            }
            case 2: {
                stl = Stl.SYSTEM;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stl;
    }

    @Override
    @NotNull
    public File getStlSharedObjectFile(@NotNull Stl stl, @NotNull Abi abi) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)stl), (String)"stl");
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        Preconditions.checkArgument((stl == Stl.LIBCXX_SHARED ? 1 : 0) != 0, (String)"Only c++_shared is valid for packaging as of NDK r19", (Object[])new Object[0]);
        Preconditions.checkArgument((boolean)this.getSupportedAbis().contains((Object)abi), (String)("Unsupported ABI for NDK r19+: " + (Object)((Object)abi)), (Object[])new Object[0]);
        switch (NdkR19Info$WhenMappings.$EnumSwitchMapping$1[abi.ordinal()]) {
            case 1: {
                string = "aarch64-linux-android";
                break;
            }
            case 2: {
                string = "arm-linux-androideabi";
                break;
            }
            case 3: {
                string = "i686-linux-android";
                break;
            }
            case 4: {
                string = "x86_64-linux-android";
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("Unsupported ABI for NDK r19+: " + (Object)((Object)abi));
            }
        }
        String sysrootTriple = string;
        File file = FilesKt.resolve((File)this.getRootDirectory(), (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/sysroot/usr/lib/" + sysrootTriple + '/' + stl.getLibraryName()));
        Preconditions.checkState((boolean)file.isFile(), (String)("Expected NDK STL shared object file at " + file), (Object[])new Object[0]);
        return file;
    }

    @Override
    @NotNull
    public File getStripExecutable(@NotNull Abi abi) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        return FilesKt.resolve((File)this.getRootDirectory(), (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/bin/" + this.getToolchainAbi(abi).getGccExecutablePrefix() + "-strip"));
    }

    @Override
    @NotNull
    public File getObjcopyExecutable(@NotNull Abi abi) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        return FilesKt.resolve((File)this.getRootDirectory(), (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/bin/" + this.getToolchainAbi(abi).getGccExecutablePrefix() + "-objcopy"));
    }

    @Override
    @Nullable
    public String validate() {
        File toolchainsDir = FilesKt.resolve((File)this.getRootDirectory(), (String)"toolchains");
        if (!toolchainsDir.isDirectory()) {
            return toolchainsDir + " is not a directory.";
        }
        return null;
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    public NdkR19Info(@NotNull File root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        super(root);
        this.root = root;
        this.supportedStls = CollectionsKt.listOf((Object[])new Stl[]{Stl.LIBCXX_SHARED, Stl.LIBCXX_STATIC, Stl.NONE, Stl.SYSTEM});
    }
}

