/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.Version;
import com.android.build.api.component.ComponentBuilder;
import com.android.build.api.component.impl.TestComponentBuilderImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.extension.AndroidComponentsExtension;
import com.android.build.api.extension.impl.VariantApiOperationsRegistrar;
import com.android.build.api.variant.Variant;
import com.android.build.api.variant.VariantBuilder;
import com.android.build.api.variant.impl.GradleProperty;
import com.android.build.api.variant.impl.VariantBuilderImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidBasePlugin;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.ApiObjectFactory;
import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.BadPluginException;
import com.android.build.gradle.internal.ClasspathVerifier;
import com.android.build.gradle.internal.DependencyConfigurator;
import com.android.build.gradle.internal.DependencyResolutionChecks;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.NonFinalPluginExpiry;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.attribution.BuildAttributionService;
import com.android.build.gradle.internal.crash.CrashReporting;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.DslVariableFactory;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.IncompatibleProjectOptionsReporter;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.NativeModelBuilder;
import com.android.build.gradle.internal.ide.dependencies.LibraryDependencyCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.build.gradle.internal.ide.v2.GlobalLibraryBuildService;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.plugins.LintModuleLoader;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.res.Aapt2FromMaven;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.DelayedActionsExecutor;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.services.Aapt2DaemonBuildService;
import com.android.build.gradle.internal.services.Aapt2ThreadPoolBuildService;
import com.android.build.gradle.internal.services.ClassesHierarchyBuildService;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.services.DslServicesImpl;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.StringCachingBuildService;
import com.android.build.gradle.internal.services.SymbolTableBuildService;
import com.android.build.gradle.internal.utils.AgpRepositoryChecker;
import com.android.build.gradle.internal.utils.AgpVersionChecker;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.internal.variant.LegacyVariantInputManager;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.internal.variant.VariantModelImpl;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.v2.ide.ProjectType;
import com.android.repository.Revision;
import com.android.sdklib.AndroidTargetHash;
import com.android.tools.lint.model.LintModelModuleLoader;
import com.android.tools.lint.model.LintModelModuleLoaderProvider;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.Directory;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.slf4j.Logger;

public abstract class BasePlugin<AndroidComponentsT extends AndroidComponentsExtension<? extends ComponentBuilder, ? extends Variant>, VariantBuilderT extends VariantBuilderImpl, VariantT extends VariantImpl>
implements Plugin<Project>,
LintModelModuleLoaderProvider {
    private BaseExtension extension;
    private AndroidComponentsExtension<? extends ComponentBuilder, ? extends Variant> androidComponentsExtension;
    private VariantManager<VariantBuilderT, VariantT> variantManager;
    private LegacyVariantInputManager variantInputModel;
    protected Project project;
    protected ProjectServices projectServices;
    protected DslServicesImpl dslServices;
    protected GlobalScope globalScope;
    protected SyncIssueReporterImpl syncIssueReporter;
    private VariantFactory<VariantBuilderT, VariantT> variantFactory;
    private final ToolingModelBuilderRegistry registry;
    private final LintModelModuleLoader lintModuleLoader;
    private final SoftwareComponentFactory componentFactory;
    private LoggerWrapper loggerWrapper;
    protected ExtraModelInfo extraModelInfo;
    private String creator;
    private boolean hasCreatedTasks = false;
    private AnalyticsConfiguratorService configuratorService;
    private ProjectOptionService optionService;
    private final BuildEventsListenerRegistry listenerRegistry;

    public BasePlugin(ToolingModelBuilderRegistry registry, SoftwareComponentFactory componentFactory, BuildEventsListenerRegistry listenerRegistry) {
        ClasspathVerifier.checkClasspathSanity();
        this.registry = registry;
        this.lintModuleLoader = new LintModuleLoader(this, registry);
        this.componentFactory = componentFactory;
        this.creator = "Android Gradle " + Version.ANDROID_GRADLE_PLUGIN_VERSION;
        NonFinalPluginExpiry.verifyRetirementAge();
        this.listenerRegistry = listenerRegistry;
    }

    protected abstract BaseExtension createExtension(DslServices var1, GlobalScope var2, DslContainerProvider<DefaultConfig, BuildType, ProductFlavor, SigningConfig> var3, NamedDomainObjectContainer<BaseVariantOutput> var4, ExtraModelInfo var5);

    protected abstract AndroidComponentsT createComponentExtension(DslServices var1, VariantApiOperationsRegistrar<VariantBuilderT, VariantT> var2);

    protected abstract GradleBuildProject.PluginType getAnalyticsPluginType();

    protected abstract VariantFactory<VariantBuilderT, VariantT> createVariantFactory(ProjectServices var1, GlobalScope var2);

    protected abstract TaskManager<VariantBuilderT, VariantT> createTaskManager(List<ComponentInfo<VariantBuilderT, VariantT>> var1, List<ComponentInfo<TestComponentBuilderImpl, TestComponentImpl>> var2, boolean var3, GlobalScope var4, BaseExtension var5);

    protected abstract int getProjectType();

    protected abstract ProjectType getProjectTypeV2();

    @VisibleForTesting
    public VariantManager<VariantBuilderT, VariantT> getVariantManager() {
        return this.variantManager;
    }

    @VisibleForTesting
    public VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> getVariantInputModel() {
        return this.variantInputModel;
    }

    public BaseExtension getExtension() {
        return this.extension;
    }

    private ILogger getLogger() {
        if (this.loggerWrapper == null) {
            this.loggerWrapper = new LoggerWrapper(this.project.getLogger());
        }
        return this.loggerWrapper;
    }

    public final void apply(Project project) {
        CrashReporting.runAction(() -> {
            this.basePluginApply(project);
            this.pluginSpecificApply(project);
        });
    }

    private void basePluginApply(Project project) {
        System.setProperty("java.awt.headless", "true");
        this.project = project;
        new AnalyticsService.RegistrationAction(project).execute();
        this.configuratorService = (AnalyticsConfiguratorService)new AnalyticsConfiguratorService.RegistrationAction(project).execute().get();
        this.optionService = (ProjectOptionService)new ProjectOptionService.RegistrationAction(project).execute().get();
        this.createProjectServices(project);
        ProjectOptions projectOptions = this.projectServices.getProjectOptions();
        DependencyResolutionChecks.registerDependencyCheck(project, projectOptions);
        project.getPluginManager().apply(AndroidBasePlugin.class);
        this.checkPathForErrors();
        this.checkModulesForErrors();
        AgpVersionChecker.enforceTheSamePluginVersions(project);
        String attributionFileLocation = projectOptions.get(StringOption.IDE_ATTRIBUTION_FILE_LOCATION);
        if (attributionFileLocation != null) {
            new BuildAttributionService.RegistrationAction(project).execute();
            BuildAttributionService.Companion.init(project, attributionFileLocation, this.listenerRegistry);
        }
        this.configuratorService.createAnalyticsService(project, this.listenerRegistry);
        this.configuratorService.getProjectBuilder(project.getPath()).setAndroidPluginVersion(Version.ANDROID_GRADLE_PLUGIN_VERSION).setAndroidPlugin(this.getAnalyticsPluginType()).setPluginGeneration(GradleBuildProject.PluginGeneration.FIRST).setOptions(AnalyticsUtil.toProto(projectOptions));
        this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_CONFIGURE, project.getPath(), null, this::configureProject);
        this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_BASE_EXTENSION_CREATION, project.getPath(), null, this::configureExtension);
        this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_TASKS_CREATION, project.getPath(), null, this::createTasks);
    }

    protected abstract void pluginSpecificApply(Project var1);

    private void configureProject() {
        Gradle gradle = this.project.getGradle();
        Provider stringCachingService = new StringCachingBuildService.RegistrationAction(this.project).execute();
        Provider mavenCoordinatesCacheBuildService = new MavenCoordinatesCacheBuildService.RegistrationAction(this.project, stringCachingService).execute();
        new LibraryDependencyCacheBuildService.RegistrationAction(this.project, mavenCoordinatesCacheBuildService).execute();
        new GlobalLibraryBuildService.RegistrationAction(this.project, mavenCoordinatesCacheBuildService).execute();
        new LintClassLoaderBuildService.RegistrationAction(this.project).execute();
        this.extraModelInfo = new ExtraModelInfo(mavenCoordinatesCacheBuildService);
        ProjectOptions projectOptions = this.projectServices.getProjectOptions();
        SyncIssueReporter issueReporter2 = this.projectServices.getIssueReporter();
        new Aapt2ThreadPoolBuildService.RegistrationAction(this.project, projectOptions).execute();
        new Aapt2DaemonBuildService.RegistrationAction(this.project, projectOptions).execute();
        new SyncIssueReporterImpl.GlobalSyncIssueService.RegistrationAction(this.project, SyncOptions.getModelQueryMode(projectOptions), SyncOptions.getErrorFormatMode(projectOptions)).execute();
        Provider sdkComponentsBuildService = new SdkComponentsBuildService.RegistrationAction(this.project, projectOptions).execute();
        Provider avdComponentsBuildService = new AvdComponentsBuildService.RegistrationAction(this.project, (Provider<Directory>)ManagedDeviceUtilsKt.getManagedDeviceAvdFolder(this.project.getObjects(), this.project.getProviders()), sdkComponentsBuildService, (Provider<SdkComponentsBuildService.VersionedSdkLoader>)sdkComponentsBuildService.map(buildService -> buildService.sdkLoader((Provider<String>)this.project.getProviders().provider(() -> this.extension.getCompileSdkVersion()), (Provider<Revision>)this.project.getProviders().provider(() -> this.extension.getBuildToolsRevision())))).execute();
        new SymbolTableBuildService.RegistrationAction(this.project, projectOptions).execute();
        new ClassesHierarchyBuildService.RegistrationAction(this.project).execute();
        projectOptions.getAllOptions().forEach(this.projectServices.getDeprecationReporter()::reportOptionIssuesIfAny);
        IncompatibleProjectOptionsReporter.check(projectOptions, this.projectServices.getIssueReporter());
        GradlePluginUtils.enforceMinimumVersionsOfPlugins(this.project, issueReporter2);
        this.project.getPlugins().apply(JavaBasePlugin.class);
        this.dslServices = new DslServicesImpl(this.projectServices, new DslVariableFactory(this.syncIssueReporter), sdkComponentsBuildService);
        MessageReceiverImpl messageReceiver = new MessageReceiverImpl(SyncOptions.getErrorFormatMode(projectOptions), (Logger)this.projectServices.getLogger());
        this.globalScope = new GlobalScope(this.project, this.creator, this.dslServices, sdkComponentsBuildService, avdComponentsBuildService, this.registry, messageReceiver, this.componentFactory);
        this.project.getTasks().named("assemble").configure(task -> task.setDescription("Assembles all variants of all applications and secondary packages."));
        gradle.projectsEvaluated(action -> DeprecationReporterImpl.Companion.clean());
        BasePlugin.createLintClasspathConfiguration(this.project);
    }

    public static void createLintClasspathConfiguration(Project project) {
        Configuration config2 = (Configuration)project.getConfigurations().create("lintClassPath");
        config2.setVisible(false);
        config2.setTransitive(true);
        config2.setCanBeConsumed(false);
        config2.setDescription("The lint embedded classpath");
        project.getDependencies().add(config2.getName(), (Object)("com.android.tools.lint:lint-gradle:" + Version.ANDROID_TOOLS_BASE_VERSION));
    }

    private void configureExtension() {
        DslServices dslServices = this.globalScope.getDslServices();
        NamedDomainObjectContainer buildOutputs = this.project.container(BaseVariantOutput.class);
        this.project.getExtensions().add("buildOutputs", (Object)buildOutputs);
        this.variantFactory = this.createVariantFactory(this.projectServices, this.globalScope);
        this.variantInputModel = new LegacyVariantInputManager(dslServices, this.variantFactory.getVariantType(), new SourceSetManager(this.project, this.isPackagePublished(), dslServices, new DelayedActionsExecutor()));
        this.extension = this.createExtension(dslServices, this.globalScope, this.variantInputModel, (NamedDomainObjectContainer<BaseVariantOutput>)buildOutputs, this.extraModelInfo);
        this.globalScope.setExtension(this.extension);
        VariantApiOperationsRegistrar<VariantBuilder, Variant> variantApiOperations = new VariantApiOperationsRegistrar<VariantBuilder, Variant>();
        this.androidComponentsExtension = this.createComponentExtension(dslServices, variantApiOperations);
        this.variantManager = new VariantManager<VariantBuilderT, VariantT>(this.globalScope, this.project, this.projectServices.getProjectOptions(), this.extension, variantApiOperations, this.variantFactory, this.variantInputModel, this.projectServices);
        this.registerModels(this.registry, this.globalScope, this.variantInputModel, this.extension, this.extraModelInfo);
        this.variantFactory.createDefaultComponents(this.variantInputModel);
        this.createAndroidTestUtilConfiguration();
    }

    protected void registerModels(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> variantInputModel, BaseExtension extension, ExtraModelInfo extraModelInfo) {
        VariantModelImpl variantModel = new VariantModelImpl(variantInputModel, (Function0<String>)((Function0)extension::getTestBuildType), (Function0<? extends List<? extends VariantImpl>>)((Function0)() -> this.variantManager.getMainComponents().stream().map(ComponentInfo::getVariant).collect(Collectors.toList())), (Function0<? extends List<? extends TestComponentImpl>>)((Function0)() -> this.variantManager.getTestComponents().stream().map(ComponentInfo::getVariant).collect(Collectors.toList())), this.dslServices.getIssueReporter());
        this.registerModelBuilder(registry, globalScope, variantModel, extension, extraModelInfo);
        registry.register(new com.android.build.gradle.internal.ide.v2.ModelBuilder(globalScope, variantModel, (CommonExtension)extension, this.projectServices.getIssueReporter(), this.getProjectTypeV2()));
        if (globalScope.getProjectOptions().get(BooleanOption.ENABLE_V2_NATIVE_MODEL)) {
            com.android.build.gradle.internal.ide.v2.NativeModelBuilder nativeModelBuilderV2 = new com.android.build.gradle.internal.ide.v2.NativeModelBuilder(this.projectServices.getIssueReporter(), globalScope, variantModel);
            registry.register((ToolingModelBuilder)nativeModelBuilderV2);
        } else {
            NativeModelBuilder nativeModelBuilder = new NativeModelBuilder(this.projectServices.getIssueReporter(), globalScope, variantModel);
            registry.register((ToolingModelBuilder)nativeModelBuilder);
        }
    }

    protected void registerModelBuilder(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantModel variantModel, BaseExtension extension, ExtraModelInfo extraModelInfo) {
        registry.register(new ModelBuilder<BaseExtension>(globalScope, variantModel, extension, extraModelInfo, this.projectServices.getIssueReporter(), this.getProjectType()));
    }

    private void createTasks() {
        this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.TASK_MANAGER_CREATE_TASKS, this.project.getPath(), null, () -> TaskManager.createTasksBeforeEvaluate(this.globalScope, this.variantFactory.getVariantType(), this.extension.getSourceSets()));
        this.project.afterEvaluate(CrashReporting.afterEvaluate(p -> {
            this.variantInputModel.getSourceSetManager().runBuildableArtifactsActions();
            this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_CREATE_ANDROID_TASKS, this.project.getPath(), null, this::createAndroidTasks);
        }));
    }

    @VisibleForTesting
    final void createAndroidTasks() {
        if (this.extension.getCompileSdkVersion() == null) {
            if (SyncOptions.getModelQueryMode(this.projectServices.getProjectOptions()).equals((Object)SyncOptions.EvaluationMode.IDE)) {
                String newCompileSdkVersion = this.findHighestSdkInstalled();
                if (newCompileSdkVersion == null) {
                    newCompileSdkVersion = "android-30";
                }
                this.extension.setCompileSdkVersion(newCompileSdkVersion);
            }
            this.dslServices.getIssueReporter().reportError(IssueReporter.Type.COMPILE_SDK_VERSION_NOT_SET, "compileSdkVersion is not specified. Please add it to build.gradle");
        }
        Preconditions.checkState((this.extension.getCompileSdkVersion() != null ? 1 : 0) != 0, (Object)"compileSdkVersion is not specified.");
        if (this.project.getPlugins().hasPlugin(JavaPlugin.class)) {
            throw new BadPluginException("The 'java' plugin has been applied, but it is not compatible with the Android plugins.");
        }
        if (this.project.getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            String warningMsg = "One of the plugins you are using supports Java 8 language features. To try the support built into the Android plugin, remove the following from your build.gradle:\n    apply plugin: 'me.tatarka.retrolambda'\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n";
            this.dslServices.getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, warningMsg);
        }
        AgpRepositoryChecker.INSTANCE.checkRepositories(this.project);
        if (!(this.project.getState().getExecuted() && this.project.getState().getFailure() == null || SdkLocator.getSdkTestDirectory() != null)) {
            return;
        }
        if (this.hasCreatedTasks) {
            return;
        }
        this.hasCreatedTasks = true;
        this.extension.disableWrite();
        this.dslServices.getVariableFactory().disableWrite();
        this.configuratorService.getProjectBuilder(this.project.getPath()).setCompileSdk(this.extension.getCompileSdkVersion()).setBuildToolsVersion(this.extension.getBuildToolsRevision().toString()).setSplits(AnalyticsUtil.toProto(this.extension.getSplits()));
        String kotlinPluginVersion = this.getKotlinPluginVersion();
        if (kotlinPluginVersion != null) {
            this.configuratorService.getProjectBuilder(this.project.getPath()).setKotlinPluginVersion(kotlinPluginVersion);
        }
        AnalyticsUtil.recordFirebasePerformancePluginVersion(this.project);
        BuildFeatureValues buildFeatureValues = this.variantFactory.createBuildFeatureValues(this.extension.getBuildFeatures(), this.projectServices.getProjectOptions());
        this.variantManager.createVariants(buildFeatureValues, this.extension.getNamespace());
        List<ComponentInfo<VariantBuilderT, VariantT>> variants = this.variantManager.getMainComponents();
        TaskManager<VariantBuilderT, VariantT> taskManager = this.createTaskManager(variants, this.variantManager.getTestComponents(), !this.variantInputModel.getProductFlavors().isEmpty(), this.globalScope, this.extension);
        taskManager.createTasks(this.variantFactory.getVariantType(), buildFeatureValues);
        new DependencyConfigurator(this.project, this.project.getName(), this.globalScope, this.variantInputModel, this.projectServices).configureDependencySubstitutions().configureGeneralTransforms().configureVariantTransforms(variants, this.variantManager.getTestComponents()).configureAttributeMatchingStrategies();
        ApiObjectFactory apiObjectFactory = new ApiObjectFactory(this.extension, this.variantFactory, this.globalScope);
        for (ComponentInfo<VariantBuilderT, VariantT> variant : variants) {
            apiObjectFactory.create((VariantImpl)variant.getVariant());
        }
        this.variantManager.lockVariantProperties();
        this.variantInputModel.getSourceSetManager().checkForUnconfiguredSourceSets();
        taskManager.createPostApiTasks();
        for (ComponentInfo<VariantBuilderT, VariantT> component2 : variants) {
            ((VariantImpl)component2.getVariant()).publishBuildArtifacts();
        }
        this.checkSplitConfiguration();
        this.variantManager.setHasCreatedTasks(true);
        for (ComponentInfo<VariantBuilderT, VariantT> variant : variants) {
            ((VariantImpl)variant.getVariant()).getArtifacts().ensureAllOperationsAreSatisfied();
        }
        GradleProperty.Companion.endOfEvaluation();
    }

    private String findHighestSdkInstalled() {
        String highestSdk = null;
        File folder = new File(SdkComponentsKt.getSdkDir(this.project.getRootDir(), this.syncIssueReporter), "platforms");
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            Arrays.sort(listOfFiles, Comparator.comparing(File::getName).reversed());
            for (File file : listOfFiles) {
                if (AndroidTargetHash.getPlatformVersion((String)file.getName()) == null) continue;
                highestSdk = file.getName();
                break;
            }
        }
        return highestSdk;
    }

    private void checkSplitConfiguration() {
        boolean splitsEnabled;
        String configApkUrl = "https://d.android.com/topic/instant-apps/guides/config-splits.html";
        boolean generatePureSplits = this.extension.getGeneratePureSplits();
        Splits splits = this.extension.getSplits();
        boolean bl = splitsEnabled = splits.getDensity().isEnable() || splits.getAbi().isEnable() || splits.getLanguage().isEnable();
        if (generatePureSplits) {
            this.dslServices.getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, "Configuration APKs are supported by the Google Play Store only when publishing Android Instant Apps. To instead generate stand-alone APKs for different device configurations, set generatePureSplits=false. For more information, go to " + configApkUrl);
        }
        if (!generatePureSplits && splits.getLanguage().isEnable()) {
            this.dslServices.getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, "Per-language APKs are supported only when building Android Instant Apps. For more information, go to " + configApkUrl);
        }
    }

    private void checkModulesForErrors() {
        String CHECKED_MODULES_FLAG = "checked_modules_for_errors";
        ExtraPropertiesExtension extraProperties = this.project.getRootProject().getExtensions().getExtraProperties();
        boolean alreadyChecked = extraProperties.has(CHECKED_MODULES_FLAG);
        if (alreadyChecked) {
            return;
        }
        extraProperties.set(CHECKED_MODULES_FLAG, (Object)true);
        Set allProjects = this.project.getRootProject().getAllprojects();
        HashMap<String, Project> subProjectsById = new HashMap<String, Project>(allProjects.size());
        for (Project subProject : allProjects) {
            String id = subProject.getGroup().toString() + ":" + subProject.getName();
            if (subProjectsById.containsKey(id)) {
                String message = String.format("Your project contains 2 or more modules with the same identification %1$s\nat \"%2$s\" and \"%3$s\".\nYou must use different identification (either name or group) for each modules.", id, ((Project)subProjectsById.get(id)).getPath(), subProject.getPath());
                throw new StopExecutionException(message);
            }
            subProjectsById.put(id, subProject);
        }
    }

    private void checkPathForErrors() {
        if (!System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
            return;
        }
        if (this.projectServices.getProjectOptions().get(BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY)) {
            return;
        }
        if (CharMatcher.ascii().matchesAllOf((CharSequence)this.project.getRootDir().getAbsolutePath())) {
            return;
        }
        String message = "Your project path contains non-ASCII characters. This will most likely cause the build to fail on Windows. Please move your project to a different directory. See http://b.android.com/95744 for details. This warning can be disabled by adding the line '" + BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY.getPropertyName() + "=true' to gradle.properties file in the project directory.";
        throw new StopExecutionException(message);
    }

    public LintModelModuleLoader getModuleLoader() {
        return this.lintModuleLoader;
    }

    private String getKotlinPluginVersion() {
        Plugin plugin = this.project.getPlugins().findPlugin("kotlin-android");
        if (plugin == null) {
            return null;
        }
        try {
            Method method = plugin.getClass().getMethod("getKotlinPluginVersion", new Class[0]);
            method.setAccessible(true);
            return method.invoke((Object)plugin, new Object[0]).toString();
        }
        catch (Throwable e) {
            return "unknown";
        }
    }

    protected boolean isPackagePublished() {
        return false;
    }

    private void createAndroidTestUtilConfiguration() {
        this.project.getLogger().debug("Creating configuration androidTestUtil");
        Configuration configuration2 = (Configuration)this.project.getConfigurations().maybeCreate("androidTestUtil");
        configuration2.setVisible(false);
        configuration2.setDescription("Additional APKs used during instrumentation testing.");
        configuration2.setCanBeConsumed(false);
        configuration2.setCanBeResolved(true);
    }

    private void createProjectServices(Project project) {
        ObjectFactory objectFactory = project.getObjects();
        org.gradle.api.logging.Logger logger = project.getLogger();
        String projectPath = project.getPath();
        ProjectOptions projectOptions = this.optionService.getProjectOptions();
        this.syncIssueReporter = new SyncIssueReporterImpl(SyncOptions.getModelQueryMode(projectOptions), SyncOptions.getErrorFormatMode(projectOptions), logger);
        DeprecationReporterImpl deprecationReporter = new DeprecationReporterImpl(this.syncIssueReporter, projectOptions, projectPath);
        Aapt2FromMaven aapt2FromMaven = Aapt2FromMaven.create(project, projectOptions);
        this.projectServices = new ProjectServices(this.syncIssueReporter, deprecationReporter, objectFactory, project.getLogger(), project.getProviders(), project.getLayout(), projectOptions, project.getGradle().getSharedServices(), aapt2FromMaven, project.getGradle().getStartParameter().getMaxWorkerCount(), (Function1<Object, ? extends File>)((Function1)arg_0 -> ((Project)project).file(arg_0)));
    }
}

