/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;

public abstract class ExtractProguardFiles
extends DefaultTask {
    private final ImmutableList<File> generatedFiles;
    private final ProjectLayout projectLayout;

    @Input
    public abstract Property<Boolean> getEnableKeepRClass();

    @Inject
    public ExtractProguardFiles(ProjectLayout projectLayout) {
        this.projectLayout = projectLayout;
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (String name2 : ProguardFiles.KNOWN_FILE_NAMES) {
            outputs.add((Object)ProguardFiles.getDefaultProguardFile(name2, projectLayout.getBuildDirectory()));
        }
        this.generatedFiles = outputs.build();
    }

    @OutputFiles
    public List<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    @TaskAction
    protected void run() throws Exception {
        for (String name2 : ProguardFiles.KNOWN_FILE_NAMES) {
            File defaultProguardFile = ProguardFiles.getDefaultProguardFile(name2, this.projectLayout.getBuildDirectory());
            if (defaultProguardFile.isFile()) continue;
            ProguardFiles.createProguardFile(name2, defaultProguardFile, (Boolean)this.getEnableKeepRClass().get());
        }
    }

    public static class CreationAction
    extends TaskCreationAction<ExtractProguardFiles> {
        private final GlobalScope globalScope;

        public CreationAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        @Override
        public String getName() {
            return "extractProguardFiles";
        }

        @Override
        public Class<ExtractProguardFiles> getType() {
            return ExtractProguardFiles.class;
        }

        @Override
        public void configure(ExtractProguardFiles task) {
            task.getEnableKeepRClass().set((Object)(!this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_R_TXT_RESOURCE_SHRINKING) ? 1 : 0));
        }
    }
}

