/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.attribution;

import com.android.build.gradle.internal.cxx.attribution.GenerateChromeTraceKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/cxx/attribution/AttributionKey;", "", "module", "", "variant", "abi", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAbi", "()Ljava/lang/String;", "filename", "getFilename", "getModule", "getVariant", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "gradle-core"})
public final class AttributionKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String module;
    @NotNull
    private final String variant;
    @NotNull
    private final String abi;

    public AttributionKey(@NotNull String module2, @NotNull String variant2, @NotNull String abi) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)variant2, (String)"variant");
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        this.module = module2;
        this.variant = variant2;
        this.abi = abi;
    }

    @NotNull
    public final String getModule() {
        return this.module;
    }

    @NotNull
    public final String getVariant() {
        return this.variant;
    }

    @NotNull
    public final String getAbi() {
        return this.abi;
    }

    @NotNull
    public String toString() {
        return this.module + " / " + this.variant + " / " + this.abi;
    }

    @NotNull
    public final String getFilename() {
        CharSequence charSequence = this.module;
        Regex regex = GenerateChromeTraceKt.access$getIllegalChars$p();
        String string = "_";
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder().append(regex.replace(charSequence, string)).append('-');
        charSequence = this.variant;
        regex = GenerateChromeTraceKt.access$getIllegalChars$p();
        string = "_";
        bl = false;
        return stringBuilder.append(regex.replace(charSequence, string)).append('-').append(this.abi).toString();
    }

    @NotNull
    public final String component1() {
        return this.module;
    }

    @NotNull
    public final String component2() {
        return this.variant;
    }

    @NotNull
    public final String component3() {
        return this.abi;
    }

    @NotNull
    public final AttributionKey copy(@NotNull String module2, @NotNull String variant2, @NotNull String abi) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)variant2, (String)"variant");
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        return new AttributionKey(module2, variant2, abi);
    }

    public static /* synthetic */ AttributionKey copy$default(AttributionKey attributionKey, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = attributionKey.module;
        }
        if ((n & 2) != 0) {
            string2 = attributionKey.variant;
        }
        if ((n & 4) != 0) {
            string3 = attributionKey.abi;
        }
        return attributionKey.copy(string, string2, string3);
    }

    public int hashCode() {
        int result2 = this.module.hashCode();
        result2 = result2 * 31 + this.variant.hashCode();
        result2 = result2 * 31 + this.abi.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttributionKey)) {
            return false;
        }
        AttributionKey attributionKey = (AttributionKey)other;
        if (!Intrinsics.areEqual((Object)this.module, (Object)attributionKey.module)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variant, (Object)attributionKey.variant)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.abi, (Object)attributionKey.abi);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/cxx/attribution/AttributionKey$Companion;", "", "()V", "fromAbi", "Lcom/android/build/gradle/internal/cxx/attribution/AttributionKey;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributionKey fromAbi(@NotNull CxxAbiModel abi) {
            Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
            String string = abi.getVariant().getModule().getGradleModulePathName();
            String string2 = abi.getVariant().getVariantName();
            String string3 = abi.getAbi().getTag();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"abi.abi.tag");
            return new AttributionKey(string, string2, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

