/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.attribution;

import com.android.build.gradle.internal.cxx.attribution.AttributionKey;
import com.android.build.gradle.internal.cxx.attribution.AttributionTask;
import com.android.build.gradle.internal.cxx.attribution.OperationType;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.builder.profile.ChromeTraceJson;
import com.android.builder.profile.TraceEventJson;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\t\u001a(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011\u001a\"\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\u0006\u0010\u000e\u001a\u00020\tH\u0002\u001a\"\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u001a\"\u0010\u0018\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0012H\u0002\u001a*\u0010\u001d\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0014H\u0002\u001a\"\u0010 \u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u001a\"\u0010!\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"MICROSECOND_IN_MILLISECOND", "", "illegalChars", "Lkotlin/text/Regex;", "generateChromeTrace", "", "abiModel", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "ninjaLogFile", "Ljava/io/File;", "linesToSkip", "buildStartTime", "", "extraChromeTraceDir", "file", "outputFile", "allAttributions", "", "Lcom/android/build/gradle/internal/cxx/attribution/AttributionKey;", "", "Lcom/android/build/gradle/internal/cxx/attribution/AttributionTask;", "readZipContent", "squashTasks", "tasks", "addProcessNameMetaEvent", "", "Lcom/android/builder/profile/TraceEventJson;", "pid", "key", "addTaskEvent", "tid", "task", "addThreadNameMetaEvent", "collectTask", "line", "", "startingTimestamp", "gradle-core"})
public final class GenerateChromeTraceKt {
    private static final int MICROSECOND_IN_MILLISECOND = 1000;
    @NotNull
    private static final Regex illegalChars = new Regex("[:\\\\/\"'|?*<>]");

    public static final void generateChromeTrace(@NotNull File file, @NotNull File outputFile) {
        Map<AttributionKey, List<AttributionTask>> map;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        try {
            map = GenerateChromeTraceKt.readZipContent(file);
        }
        catch (Throwable e) {
            LoggingEnvironmentKt.warnln(Intrinsics.stringPlus((String)"Cannot parse native build attribution zip file. Exception: ", (Object)Throwables.getStackTraceAsString((Throwable)e)), new Object[0]);
            return;
        }
        Map<AttributionKey, List<AttributionTask>> allAttributions = map;
        GenerateChromeTraceKt.generateChromeTrace(outputFile, allAttributions);
    }

    public static /* synthetic */ void generateChromeTrace$default(File file, File file2, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = new File(file.getParentFile(), Intrinsics.stringPlus((String)FilesKt.getNameWithoutExtension((File)file), (Object)".json.gz"));
        }
        GenerateChromeTraceKt.generateChromeTrace(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void generateChromeTrace(@NotNull CxxAbiModel abiModel, @NotNull File ninjaLogFile, int linesToSkip, long buildStartTime, @NotNull File extraChromeTraceDir) {
        Intrinsics.checkParameterIsNotNull((Object)abiModel, (String)"abiModel");
        Intrinsics.checkParameterIsNotNull((Object)ninjaLogFile, (String)"ninjaLogFile");
        Intrinsics.checkParameterIsNotNull((Object)extraChromeTraceDir, (String)"extraChromeTraceDir");
        AttributionKey attributionKey = AttributionKey.Companion.fromAbi(abiModel);
        try {
            void $this$useLines$iv;
            extraChromeTraceDir.mkdirs();
            boolean bl = false;
            List allTasks = new ArrayList();
            File file = ninjaLogFile;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
            Charset charset$iv = charset;
            boolean $i$f$useLines = false;
            Closeable closeable = $this$useLines$iv;
            int n = 8192;
            boolean bl2 = false;
            Reader reader = closeable;
            boolean bl3 = false;
            InputStream inputStream = reader;
            boolean bl4 = false;
            inputStream = new FileInputStream((File)((Object)inputStream));
            bl4 = false;
            reader = new InputStreamReader(inputStream, charset$iv);
            bl3 = false;
            closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
            n = 0;
            bl2 = false;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl5 = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl6 = false;
                Sequence $this$forEach$iv = SequencesKt.drop((Sequence)lines, (int)linesToSkip);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl7 = false;
                    if (StringsKt.startsWith$default((String)line, (String)"# ", (boolean)false, (int)2, null)) continue;
                    GenerateChromeTraceKt.collectTask(allTasks, line, buildStartTime);
                }
                reader = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            GenerateChromeTraceKt.generateChromeTrace(FilesKt.resolve((File)extraChromeTraceDir, (String)("external_native_build-" + buildStartTime + '-' + attributionKey.getFilename() + ".json.gz")), MapsKt.mapOf((Pair)TuplesKt.to((Object)attributionKey, (Object)allTasks)));
        }
        catch (Throwable e) {
            LoggingEnvironmentKt.warnln("Cannot generate Chrome trace file for " + attributionKey + ". Exception: " + Throwables.getStackTraceAsString((Throwable)e), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateChromeTrace(@NotNull File outputFile, @NotNull Map<AttributionKey, ? extends List<AttributionTask>> allAttributions) {
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        Intrinsics.checkParameterIsNotNull(allAttributions, (String)"allAttributions");
        try {
            boolean bl = false;
            List allEvents = new ArrayList();
            Iterable $this$sortedBy$iv = allAttributions.entrySet();
            boolean $i$f$sortedBy = false;
            boolean bl2 = false;
            Iterable $this$forEachIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry $dstr$_u24__u24$tasks = (Map.Entry)a;
                    boolean bl2 = false;
                    Object object = $dstr$_u24__u24$tasks;
                    boolean bl3 = false;
                    List tasks = (List)object.getValue();
                    long l = (object = (AttributionTask)CollectionsKt.firstOrNull((List)tasks)) == null ? 0L : ((AttributionTask)object).getStartTimeMs();
                    $dstr$_u24__u24$tasks = (Map.Entry)b;
                    Comparable comparable = Long.valueOf(l);
                    bl2 = false;
                    object = $dstr$_u24__u24$tasks;
                    bl3 = false;
                    tasks = (List)object.getValue();
                    object = (AttributionTask)CollectionsKt.firstOrNull((List)tasks);
                    Long l2 = object == null ? 0L : ((AttributionTask)object).getStartTimeMs();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l2);
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $dstr$key$tasksForAnAbi;
                int n = index$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Map.Entry entry = (Map.Entry)item$iv;
                int pid = n;
                boolean bl4 = false;
                void var13_15 = $dstr$key$tasksForAnAbi;
                boolean bl5 = false;
                AttributionKey key = (AttributionKey)var13_15.getKey();
                void var14_16 = $dstr$key$tasksForAnAbi;
                boolean bl6 = false;
                List tasksForAnAbi = (List)var14_16.getValue();
                GenerateChromeTraceKt.addProcessNameMetaEvent(allEvents, pid, key);
                Iterable $this$forEachIndexed$iv2 = GenerateChromeTraceKt.squashTasks(tasksForAnAbi);
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    void tasks;
                    int n2 = index$iv2++;
                    boolean bl7 = false;
                    if (n2 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    List list = (List)item$iv2;
                    int tid = n2;
                    boolean bl8 = false;
                    GenerateChromeTraceKt.addThreadNameMetaEvent(allEvents, pid, tid);
                    Iterable $this$forEach$iv = (Iterable)tasks;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AttributionTask task = (AttributionTask)element$iv;
                        boolean bl9 = false;
                        GenerateChromeTraceKt.addTaskEvent(allEvents, pid, tid, task);
                    }
                }
            }
            new ChromeTraceJson(allEvents).storeToFile(outputFile);
        }
        catch (Throwable e) {
            LoggingEnvironmentKt.warnln(Intrinsics.stringPlus((String)"Cannot output native build attribution in Chrome trace format. Exception: ", (Object)Throwables.getStackTraceAsString((Throwable)e)), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map<AttributionKey, List<AttributionTask>> readZipContent(File file) {
        boolean bl = false;
        Map allAttributions = new LinkedHashMap();
        ZipFile zipFile = new ZipFile(file);
        Closeable closeable = new ZipInputStream(new FileInputStream(file));
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            Object object;
            ZipInputStream it = (ZipInputStream)closeable;
            boolean bl4 = false;
            while ((object = it.getNextEntry()) != null) {
                Object entry = object;
                if (((ZipEntry)entry).isDirectory()) continue;
                Object object2 = ((ZipEntry)entry).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"entry.name");
                CharSequence charSequence = (CharSequence)object2;
                object2 = new char[1];
                object2[0] = 47;
                Object object3 = object = StringsKt.split$default((CharSequence)charSequence, (char[])object2, (boolean)false, (int)3, (int)2, null);
                boolean bl5 = false;
                String module2 = (String)object3.get(0);
                Object object4 = object;
                boolean bl6 = false;
                String variant2 = (String)object4.get(1);
                Object object5 = object;
                boolean bl7 = false;
                String abi = (String)object5.get(2);
                object5 = allAttributions;
                AttributionKey attributionKey = new AttributionKey(module2, variant2, abi);
                boolean bl8 = false;
                List list = new ArrayList();
                boolean bl9 = false;
                boolean bl10 = false;
                List $this$readZipContent_u24lambda_u2d10_u24lambda_u2d9 = list;
                boolean bl11 = false;
                Closeable closeable2 = new InputStreamReader(zipFile.getInputStream((ZipEntry)entry), StandardCharsets.UTF_8);
                boolean bl12 = false;
                boolean bl13 = false;
                Throwable throwable2 = null;
                try {
                    InputStreamReader inputStreamReader = (InputStreamReader)closeable2;
                    boolean bl14 = false;
                    long startingTimestamp = 0L;
                    for (String line : TextStreamsKt.readLines((Reader)inputStreamReader)) {
                        if (StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) {
                            String string;
                            String string2;
                            block17: {
                                void $this$takeWhile$iv;
                                String string3;
                                int index$iv;
                                int n;
                                String $this$dropWhile$iv;
                                block16: {
                                    string2 = line;
                                    boolean $i$f$dropWhile = false;
                                    int n2 = 0;
                                    n = ((CharSequence)$this$dropWhile$iv).length();
                                    while (n2 < n) {
                                        char c2 = $this$dropWhile$iv.charAt(index$iv);
                                        boolean bl15 = false;
                                        if (!(!Character.isDigit(c2))) {
                                            String c2 = $this$dropWhile$iv;
                                            bl15 = false;
                                            String string4 = c2.substring(index$iv);
                                            string3 = string4;
                                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                                            break block16;
                                        }
                                        ++index$iv;
                                    }
                                    string3 = "";
                                }
                                $this$dropWhile$iv = string3;
                                boolean $i$f$takeWhile = false;
                                n = $this$takeWhile$iv.length();
                                for (index$iv = 0; index$iv < n; ++index$iv) {
                                    char c = $this$takeWhile$iv.charAt(index$iv);
                                    boolean bl16 = false;
                                    if (Character.isDigit(c)) continue;
                                    void var33_46 = $this$takeWhile$iv;
                                    int n3 = 0;
                                    boolean bl17 = false;
                                    String string5 = var33_46.substring(n3, index$iv);
                                    string = string5;
                                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    break block17;
                                }
                                string = $this$takeWhile$iv;
                            }
                            string2 = string;
                            boolean bl18 = false;
                            startingTimestamp = Long.parseLong(string2);
                            continue;
                        }
                        GenerateChromeTraceKt.collectTask($this$readZipContent_u24lambda_u2d10_u24lambda_u2d9, line, startingTimestamp);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                bl9 = false;
                object5.put(attributionKey, list);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return allAttributions;
    }

    private static final void collectTask(List<AttributionTask> $this$collectTask, String line, long startingTimestamp) {
        List list;
        char[] cArray = new char[]{'\t'};
        List list2 = list = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        String start = (String)list2.get(0);
        List list3 = list;
        boolean bl2 = false;
        String end = (String)list3.get(1);
        List list4 = list;
        boolean bl3 = false;
        String output2 = (String)list4.get(3);
        File outputFile = new File(output2);
        String string = outputFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputFile.name");
        String string2 = string;
        string = FilesKt.getExtension((File)outputFile);
        OperationType operationType = Intrinsics.areEqual((Object)string, (Object)"o") ? OperationType.COMPILE : OperationType.LINK;
        string = start;
        boolean bl4 = false;
        long l = Long.parseLong(string) + startingTimestamp;
        string = end;
        bl4 = false;
        $this$collectTask.add(new AttributionTask(string2, operationType, l, Long.parseLong(string) + startingTimestamp, output2));
    }

    private static final void addProcessNameMetaEvent(List<TraceEventJson> $this$addProcessNameMetaEvent, int pid, AttributionKey key) {
        $this$addProcessNameMetaEvent.add(new TraceEventJson(pid, 0, 0L, "M", null, "process_name", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)key.toString())), 80, null));
    }

    private static final void addThreadNameMetaEvent(List<TraceEventJson> $this$addThreadNameMetaEvent, int pid, int tid) {
        $this$addThreadNameMetaEvent.add(new TraceEventJson(pid, tid, 0L, "M", null, "thread_name", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)Intrinsics.stringPlus((String)"ninja->clang ", (Object)tid))), 80, null));
    }

    private static final void addTaskEvent(List<TraceEventJson> $this$addTaskEvent, int pid, int tid, AttributionTask task) {
        $this$addTaskEvent.add(new TraceEventJson(pid, tid, task.getStartTimeMs() * (long)1000, "B", task.getType().toString(), task.getName(), task.getType().getColorName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"output", (Object)task.getOutput()))));
        $this$addTaskEvent.add(new TraceEventJson(pid, tid, task.getEndTimeMs() * (long)1000, "E", null, null, null, null, 240, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<AttributionTask>> squashTasks(List<AttributionTask> tasks) {
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$sortedBy$iv = tasks;
        boolean $i$f$sortedBy = false;
        boolean bl2 = false;
        for (AttributionTask task : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                AttributionTask it = (AttributionTask)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getStartTimeMs());
                it = (AttributionTask)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getStartTimeMs();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        })) {
            List chosenTrack;
            Object v0;
            void $this$maxBy$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object[] objectArray = (Object[])result2;
            boolean $i$f$filter = false;
            void var7_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                List it = (List)element$iv$iv;
                boolean bl3 = false;
                AttributionTask attributionTask = (AttributionTask)CollectionsKt.lastOrNull((List)it);
                if (!((attributionTask == null ? 0L : attributionTask.getEndTimeMs()) <= task.getStartTimeMs())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxBy = false;
            void $this$maxByOrNull$iv$iv = $this$maxBy$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv$iv = $this$maxByOrNull$iv$iv.iterator();
            if (!iterator$iv$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv$iv = iterator$iv$iv.next();
                if (!iterator$iv$iv.hasNext()) {
                    v0 = maxElem$iv$iv;
                } else {
                    List it = (List)maxElem$iv$iv;
                    boolean bl4 = false;
                    AttributionTask bl3 = (AttributionTask)CollectionsKt.lastOrNull((List)it);
                    long maxValue$iv$iv = bl3 == null ? 0L : bl3.getEndTimeMs();
                    do {
                        long v$iv$iv;
                        Object e$iv$iv = iterator$iv$iv.next();
                        List it2 = (List)e$iv$iv;
                        $i$a$-maxBy-GenerateChromeTraceKt$squashTasks$chosenTrack$2 = false;
                        AttributionTask attributionTask = (AttributionTask)CollectionsKt.lastOrNull((List)it2);
                        long l = v$iv$iv = attributionTask == null ? 0L : attributionTask.getEndTimeMs();
                        if (maxValue$iv$iv >= v$iv$iv) continue;
                        maxElem$iv$iv = e$iv$iv;
                        maxValue$iv$iv = v$iv$iv;
                    } while (iterator$iv$iv.hasNext());
                    v0 = maxElem$iv$iv;
                }
            }
            if ((chosenTrack = (List)v0) == null) {
                objectArray = new AttributionTask[]{task};
                result2.add(CollectionsKt.mutableListOf((Object[])objectArray));
                continue;
            }
            chosenTrack.add(task);
        }
        return result2;
    }

    public static final /* synthetic */ Regex access$getIllegalChars$p() {
        return illegalChars;
    }
}

