/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.testing.utp.EmulatorGrpcInfo;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b\u001a\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"DEFAULT_EMULATOR_GRPC_PORT", "", "getDEFAULT_EMULATOR_GRPC_PORT$annotations", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "computeRegistrationDirectoryContainer", "Ljava/nio/file/Path;", "findGrpcInfo", "Lcom/android/build/gradle/internal/testing/utp/EmulatorGrpcInfo;", "deviceSerial", "", "file", "getUid", "gradle-core"})
public final class IceboxConfigUtilsKt {
    public static final int DEFAULT_EMULATOR_GRPC_PORT = 8554;
    private static final Logger LOG = Logger.getLogger("IceboxConfigUtils");

    @VisibleForTesting
    public static /* synthetic */ void getDEFAULT_EMULATOR_GRPC_PORT$annotations() {
    }

    private static final Path computeRegistrationDirectoryContainer() {
        String string;
        String object = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProperty(\"os.name\")");
        String string2 = object;
        String[] stringArray = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"ROOT");
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toLowerCase((Locale)stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String os = string4;
        if (StringsKt.startsWith$default((String)os, (String)"mac", (boolean)false, (int)2, null)) {
            String string5 = System.getenv("HOME");
            String string6 = string5 == null ? "/" : string5;
            String[] stringArray2 = new String[]{"Library", "Caches", "TemporaryItems"};
            return Paths.get(string6, stringArray2);
        }
        if (StringsKt.startsWith$default((String)os, (String)"win", (boolean)false, (int)2, null)) {
            String string7 = System.getenv("LOCALAPPDATA");
            String string8 = string7 == null ? "/" : string7;
            String[] stringArray3 = new String[]{"Temp"};
            return Paths.get(string8, stringArray3);
        }
        stringArray = new String[]{System.getenv("XDG_RUNTIME_DIR"), Intrinsics.stringPlus((String)"/run/user/", (Object)IceboxConfigUtilsKt.getUid()), System.getenv("ANDROID_EMULATOR_HOME"), System.getenv("ANDROID_PREFS_ROOT"), System.getenv("ANDROID_SDK_HOME"), Intrinsics.stringPlus((String)((string = System.getenv("HOME")) == null ? "/" : string), (Object)".android"), System.getProperty("android.emulator.home")};
        for (String dirstr : stringArray) {
            if (dirstr == null) continue;
            try {
                Path dir = Paths.get(dirstr, new String[0]);
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                return dir;
            }
            catch (InvalidPathException exception) {
                LOG.finer("Failed to parse dir " + dirstr + ", exception " + exception);
            }
        }
        String[] stringArray4 = new String[]{Intrinsics.stringPlus((String)"android-", (Object)System.getProperty("USER"))};
        return Paths.get(FileUtils.getTempDirectory().getAbsolutePath(), stringArray4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getUid() {
        try {
            String userName = System.getProperty("user.name");
            String command = Intrinsics.stringPlus((String)"id -u ", (Object)userName);
            Process process2 = Runtime.getRuntime().exec(command);
            Closeable closeable = process2.getInputStream();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                Object object = ByteStreamsKt.readBytes((InputStream)it);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
                boolean bl4 = false;
                object = new String((byte[])object, charset);
                boolean bl5 = false;
                String result2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                object = result2;
                bl5 = false;
                if (object.length() == 0) {
                    String string = null;
                    return string;
                }
                String string = result2;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static final EmulatorGrpcInfo findGrpcInfo(@NotNull String deviceSerial, @NotNull Path file) {
        Intrinsics.checkParameterIsNotNull((Object)deviceSerial, (String)"deviceSerial");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        int currentGrpcPort = 0;
        currentGrpcPort = 8554;
        String currentGrpcToken = null;
        boolean matchedAvd = false;
        List<String> list = Files.readAllLines(file);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"readAllLines(file)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String serial;
            int n;
            String string;
            String line = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)line, (String)"line");
            if (StringsKt.startsWith$default((String)line, (String)"grpc.port=", (boolean)false, (int)2, null)) {
                string = line;
                int n2 = "grpc.port=".length();
                n = 0;
                String string2 = string.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                currentGrpcPort = Integer.parseInt(string2, 10);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"grpc.token=", (boolean)false, (int)2, null)) {
                string = line;
                int n3 = "grpc.token=".length();
                n = 0;
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"port.serial=", (boolean)false, (int)2, null)) continue;
            String string3 = line;
            n = "port.serial=".length();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)string3.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            matchedAvd = Intrinsics.areEqual((Object)Intrinsics.stringPlus((String)"emulator-", (Object)serial), (Object)deviceSerial);
        }
        if (matchedAvd) {
            return new EmulatorGrpcInfo(currentGrpcPort, currentGrpcToken);
        }
        return null;
    }

    @NotNull
    public static final EmulatorGrpcInfo findGrpcInfo(@NotNull String deviceSerial) {
        Intrinsics.checkParameterIsNotNull((Object)deviceSerial, (String)"deviceSerial");
        try {
            Pattern fileNamePattern = Pattern.compile("pid_\\d+.ini");
            Object object = IceboxConfigUtilsKt.computeRegistrationDirectoryContainer();
            Path directory2 = object == null ? null : object.resolve("avd/running");
            Stream<Path> stream2 = Files.list(directory2);
            Intrinsics.checkExpressionValueIsNotNull(stream2, (String)"list(directory)");
            object = (EmulatorGrpcInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence(stream2), (Function1)((Function1)new Function1<Path, EmulatorGrpcInfo>(fileNamePattern, deviceSerial){
                final /* synthetic */ Pattern $fileNamePattern;
                final /* synthetic */ String $deviceSerial;
                {
                    this.$fileNamePattern = $fileNamePattern;
                    this.$deviceSerial = $deviceSerial;
                    super(1);
                }

                @Nullable
                public final EmulatorGrpcInfo invoke(Path file) {
                    EmulatorGrpcInfo emulatorGrpcInfo;
                    if (this.$fileNamePattern.matcher(((Object)file.getFileName()).toString()).matches()) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"file");
                        emulatorGrpcInfo = IceboxConfigUtilsKt.findGrpcInfo(this.$deviceSerial, file);
                    } else {
                        emulatorGrpcInfo = null;
                    }
                    return emulatorGrpcInfo;
                }
            }))));
            return object == null ? new EmulatorGrpcInfo(8554, null) : object;
        }
        catch (Throwable exception) {
            LOG.fine(Intrinsics.stringPlus((String)"Failed to parse emulator gRPC port, fallback to default, exception ", (Object)exception));
            return new EmulatorGrpcInfo(8554, null);
        }
    }
}

