/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.builder.model.ApiVersion;
import com.android.sdklib.AndroidVersion;
import java.io.Serializable;
import java.util.Objects;

final class ApiVersionImpl
implements ApiVersion,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int mApiLevel;
    private final String mCodename;

    public static ApiVersion clone(ApiVersion apiVersion) {
        if (apiVersion == null) {
            return null;
        }
        return new ApiVersionImpl(apiVersion);
    }

    public static ApiVersion clone(AndroidVersion androidVersion) {
        return new ApiVersionImpl(androidVersion.getApiLevel(), androidVersion.getCodename());
    }

    private ApiVersionImpl(ApiVersion apiVersion) {
        this(apiVersion.getApiLevel(), apiVersion.getCodename());
    }

    private ApiVersionImpl(int apiLevel, String codename) {
        this.mApiLevel = apiLevel;
        this.mCodename = codename;
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    public String getCodename() {
        return this.mCodename;
    }

    public String getApiString() {
        return this.mCodename != null ? this.mCodename : Integer.toString(this.mApiLevel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiVersionImpl that = (ApiVersionImpl)o;
        return this.mApiLevel == that.mApiLevel && Objects.equals(this.mCodename, that.mCodename);
    }

    public int hashCode() {
        return Objects.hash(this.mApiLevel, this.mCodename);
    }
}

