/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a%\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a/\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u000b\u001a'\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\f\u001a'\u0010\r\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\f\u001a'\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\f\u001a\u001a\u0010\u000f\u001a\u00020\b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u001a/\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u000b\u001a'\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u0015"}, d2={"checkedFormat", "", "format", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "errorln", "", "diagnosticCode", "Lcom/android/utils/cxx/CxxDiagnosticCode;", "(Lcom/android/utils/cxx/CxxDiagnosticCode;Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/String;[Ljava/lang/Object;)V", "infoln", "lifecycleln", "logStructured", "message", "Lkotlin/Function1;", "Lcom/android/build/gradle/internal/cxx/string/StringEncoder;", "Lcom/google/protobuf/GeneratedMessageV3;", "warnln", "gradle-core"})
public final class LoggingEnvironmentKt {
    public static final void errorln(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedErrorToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args), null);
    }

    public static final void errorln(@NotNull CxxDiagnosticCode diagnosticCode, @NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)diagnosticCode, (String)"diagnosticCode");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedErrorToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args), diagnosticCode);
    }

    public static final void warnln(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedWarningToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args), null);
    }

    public static final void warnln(@NotNull CxxDiagnosticCode diagnosticCode, @NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)diagnosticCode, (String)"diagnosticCode");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedWarningToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args), diagnosticCode);
    }

    public static final void lifecycleln(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedLifecycleToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args));
    }

    public static final void infoln(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedInfoToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args));
    }

    public static final void logStructured(@NotNull Function1<? super StringEncoder, ? extends GeneratedMessageV3> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        ThreadLoggingEnvironment.Companion.logStructuredMessageToCurrentLogger(message);
    }

    private static final String checkedFormat(String format, Object[] args) {
        Object object = args;
        boolean bl = false;
        if (((Object[])object).length == 0) {
            return format;
        }
        try {
            object = StringCompanionObject.INSTANCE;
            Object[] objectArray = new Object[((StringCompanionObject)args).length];
            System.arraycopy(args, 0, objectArray, 0, ((StringCompanionObject)args).length);
            boolean bl2 = false;
            String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            object = string;
        }
        catch (Throwable e) {
            StringBuilder stringBuilder = new StringBuilder().append("\n        ").append((Object)e.getMessage()).append("\n        format = ").append(format).append("\n        args[").append(((StringCompanionObject)args).length).append("] = ").append(ArraysKt.joinToString$default((Object[])args, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append("\n        stacktrace = ");
            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
            object = StringsKt.trimIndent((String)stringBuilder.append(ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
        }
        return object;
    }

    public static final /* synthetic */ String access$checkedFormat(String format, Object[] args) {
        return LoggingEnvironmentKt.checkedFormat(format, args);
    }
}

