/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.AndroidLintInputs;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.errors.IssueReporter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/lint/LintFromMaven;", "", "files", "Lorg/gradle/api/file/FileCollection;", "version", "", "(Lorg/gradle/api/file/FileCollection;Ljava/lang/String;)V", "getFiles", "()Lorg/gradle/api/file/FileCollection;", "getVersion", "()Ljava/lang/String;", "Companion", "gradle-core"})
public final class LintFromMaven {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileCollection files;
    @NotNull
    private final String version;

    public LintFromMaven(@NotNull FileCollection files2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.files = files2;
        this.version = version;
    }

    @NotNull
    public final FileCollection getFiles() {
        return this.files;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @JvmStatic
    @NotNull
    public static final LintFromMaven from(@NotNull Project project2, @NotNull ProjectOptions projectOptions, @NotNull IssueReporter issueReporter2) {
        return Companion.from(project2, projectOptions, issueReporter2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/lint/LintFromMaven$Companion;", "", "()V", "from", "Lcom/android/build/gradle/internal/lint/LintFromMaven;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LintFromMaven from(@NotNull Project project2, @NotNull ProjectOptions projectOptions, @NotNull IssueReporter issueReporter2) {
            Dependency[] dependencyArray;
            String string;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
            Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
            Dependency[] dependencyArray2 = projectOptions.get(StringOption.LINT_VERSION_OVERRIDE);
            if (dependencyArray2 == null) {
                string = null;
            } else {
                dependencyArray = dependencyArray2;
                boolean bl = false;
                string = ((Object)StringsKt.trim((CharSequence)((CharSequence)dependencyArray))).toString();
            }
            String lintVersion = AndroidLintInputs.getLintMavenArtifactVersion$default(string, issueReporter2, null, null, 12, null);
            dependencyArray = new Dependency[1];
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools.lint"), TuplesKt.to((Object)"name", (Object)"lint-gradle"), TuplesKt.to((Object)"version", (Object)lintVersion)};
            dependencyArray[0] = project2.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
            Configuration config2 = project2.getConfigurations().detachedConfiguration(dependencyArray);
            config2.setTransitive(true);
            config2.setCanBeResolved(true);
            Intrinsics.checkNotNullExpressionValue((Object)config2, (String)"config");
            return new LintFromMaven((FileCollection)config2, lintVersion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

