/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollections;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.dependencies.VariantKey;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u001aD\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011*\u00020\u0014H\u0002\u001a\n\u0010\u0015\u001a\u00020\u0012*\u00020\u0016\u00a8\u0006\u0017"}, d2={"getAllArtifacts", "", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "componentImpl", "Lcom/android/build/api/component/impl/ComponentImpl;", "consumedConfigType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ConsumedConfigType;", "dependencyFailureHandler", "Lcom/android/build/gradle/internal/ide/DependencyFailureHandler;", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "collections", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactCollections;", "projectPath", "variantName", "asMultiMap", "Lcom/google/common/collect/ImmutableMultimap;", "Lcom/android/build/gradle/internal/ide/dependencies/VariantKey;", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "toKey", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "gradle-core"})
@JvmName(name="ArtifactUtils")
public final class ArtifactUtils {
    @NotNull
    public static final Set<ResolvedArtifact> getAllArtifacts(@NotNull ComponentImpl componentImpl, @NotNull AndroidArtifacts.ConsumedConfigType consumedConfigType, @Nullable DependencyFailureHandler dependencyFailureHandler, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkNotNullParameter((Object)componentImpl, (String)"componentImpl");
        Intrinsics.checkNotNullParameter((Object)((Object)consumedConfigType), (String)"consumedConfigType");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        ArtifactCollections collections = new ArtifactCollections(componentImpl, consumedConfigType);
        String string = componentImpl.getServices().getProjectInfo().getProject().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentImpl.services.projectInfo.getProject().path");
        return ArtifactUtils.getAllArtifacts(collections, dependencyFailureHandler, buildMapping, string, componentImpl.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<ResolvedArtifact> getAllArtifacts(ArtifactCollections collections, DependencyFailureHandler dependencyFailureHandler, ImmutableMap<String, String> buildMapping, String projectPath, String variantName) {
        void $this$filterTo$iv$iv;
        ArtifactCollection incomingArtifacts = collections.getAll();
        ImmutableMultimap<VariantKey, ResolvedArtifactResult> manifests = ArtifactUtils.asMultiMap(collections.getManifests());
        ImmutableMultimap<VariantKey, ResolvedArtifactResult> explodedAars = ArtifactUtils.asMultiMap(collections.getExplodedAars());
        ArtifactCollection projectList = collections.getProjectJars();
        ImmutableMultimap<VariantKey, ResolvedArtifactResult> projectJars = ArtifactUtils.asMultiMap(projectList);
        if (dependencyFailureHandler != null) {
            Collection failures = incomingArtifacts.getFailures();
            String string = projectPath + '@' + variantName + '/' + collections.getConsumedConfigType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)failures, (String)"failures");
            dependencyFailureHandler.addErrors(string, failures);
        }
        ImmutableSet immutableSet = explodedAars.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"explodedAars.keySet()");
        Iterable $this$filter$iv = (Iterable)immutableSet;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VariantKey it = (VariantKey)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getOwner() instanceof ProjectComponentIdentifier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List aarWrappedAsProjects = (List)destination$iv$iv;
        Set resolvedArtifactResults = incomingArtifacts.getArtifacts();
        LinkedHashSet artifacts2 = Sets.newLinkedHashSetWithExpectedSize((int)resolvedArtifactResults.size());
        for (ResolvedArtifactResult resolvedComponentResult : resolvedArtifactResults) {
            boolean bl;
            ResolvedVariantResult resolvedVariantResult = resolvedComponentResult.getVariant();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"resolvedComponentResult.variant");
            VariantKey variantKey = ArtifactUtils.toKey(resolvedVariantResult);
            boolean isAarWrappedAsProject = aarWrappedAsProjects.contains(variantKey);
            ResolvedArtifact.DependencyType dependencyType = null;
            ImmutableCollection bl2 = explodedAars.get((Object)variantKey);
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"explodedAars[variantKey]");
            Collection extractedAar = (Collection)bl2;
            ImmutableCollection immutableCollection = manifests.get((Object)variantKey);
            Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"manifests[variantKey]");
            Collection manifest = (Collection)immutableCollection;
            Collection mainArtifacts = null;
            String artifactType = (String)resolvedComponentResult.getVariant().getAttributes().getAttribute(AndroidArtifacts.ARTIFACT_TYPE);
            Iterator iterator2 = artifactType;
            if (Intrinsics.areEqual((Object)iterator2, (Object)AndroidArtifacts.ArtifactType.AAR.getType())) {
                dependencyType = ResolvedArtifact.DependencyType.ANDROID;
                mainArtifacts = CollectionsKt.listOf((Object)resolvedComponentResult);
            } else if (Intrinsics.areEqual((Object)iterator2, (Object)AndroidArtifacts.ArtifactType.JAR.getType())) {
                Collection collection = manifest;
                bl = false;
                if (!collection.isEmpty()) {
                    dependencyType = ResolvedArtifact.DependencyType.ANDROID;
                    mainArtifacts = manifest;
                } else {
                    Collection collection2;
                    dependencyType = ResolvedArtifact.DependencyType.JAVA;
                    ImmutableCollection projectJar = projectJars.get((Object)variantKey);
                    Collection collection3 = (Collection)projectJar;
                    boolean bl3 = false;
                    if (collection3.isEmpty()) {
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"resolvedComponentResult");
                        collection2 = CollectionsKt.listOf((Object)resolvedComponentResult);
                    } else {
                        collection2 = collection3;
                    }
                    Collection collection4 = collection2;
                    Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"projectJar.ifEmpty {\n                        // Note use this component directly to handle classified artifacts\n                        // This is tested by AppWithClassifierDepTest.\n                        listOf<ResolvedArtifactResult>(resolvedComponentResult)\n                    }");
                    mainArtifacts = collection4;
                }
            } else {
                throw new IllegalStateException("Internal error: Artifact type " + artifactType + " not expected, only jar or aar are handled.");
            }
            iterator2 = mainArtifacts;
            boolean projectJar = false;
            boolean bl5 = !iterator2.isEmpty();
            projectJar = false;
            bl = false;
            if (!bl5) {
                boolean bl6 = false;
                String string = StringsKt.trimMargin$default((String)("Internal Error: No artifact found for artifactType '" + variantKey + "'\n            | context: " + projectPath + ' ' + variantName + "\n            | manifests = " + manifests + "\n            | explodedAars = " + explodedAars + "\n            | projectJars = " + projectJars + "\n        "), null, (int)1, null);
                throw (Throwable)new IllegalStateException(string.toString());
            }
            for (ResolvedArtifactResult mainArtifact : mainArtifacts) {
                artifacts2.add(new ResolvedArtifact(mainArtifact, (ResolvedArtifactResult)CollectionsKt.firstOrNull((Iterable)extractedAar), dependencyType, isAarWrappedAsProject, buildMapping));
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)artifacts2, (String)"artifacts");
        return artifacts2;
    }

    private static final ImmutableMultimap<VariantKey, ResolvedArtifactResult> asMultiMap(ArtifactCollection $this$asMultiMap) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        boolean bl = false;
        boolean bl2 = false;
        ImmutableMultimap.Builder builder2 = builder;
        boolean bl3 = false;
        for (ResolvedArtifactResult artifact : $this$asMultiMap.getArtifacts()) {
            ResolvedVariantResult resolvedVariantResult = artifact.getVariant();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"artifact.variant");
            builder2.put((Object)ArtifactUtils.toKey(resolvedVariantResult), (Object)artifact);
        }
        ImmutableMultimap immutableMultimap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMultimap, (String)"builder<VariantKey, ResolvedArtifactResult>()\n        .also { builder ->\n            for (artifact in artifacts) {\n                builder.put(artifact.variant.toKey(), artifact)\n            }\n        }.build()");
        return immutableMultimap;
    }

    @NotNull
    public static final VariantKey toKey(@NotNull ResolvedVariantResult $this$toKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toKey, (String)"<this>");
        Object object = $this$toKey.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"owner");
        ComponentIdentifier componentIdentifier = object;
        object = $this$toKey.getCapabilities();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"capabilities");
        Object object2 = object;
        object = $this$toKey.getExternalVariant().orElse(null);
        return new VariantKey(componentIdentifier, (List<? extends Capability>)object2, object == null ? null : ArtifactUtils.toKey((ResolvedVariantResult)object));
    }

    public static final /* synthetic */ Set access$getAllArtifacts(ArtifactCollections collections, DependencyFailureHandler dependencyFailureHandler, ImmutableMap buildMapping, String projectPath, String variantName) {
        return ArtifactUtils.getAllArtifacts(collections, dependencyFailureHandler, (ImmutableMap<String, String>)buildMapping, projectPath, variantName);
    }
}

