/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.AarMetadataArtifact;
import com.android.build.gradle.internal.tasks.AarMetadataReader;
import com.android.build.gradle.internal.tasks.CheckAarMetadataWorkParameters;
import com.android.build.gradle.internal.utils.CompileData;
import com.android.build.gradle.internal.utils.SdkUtilsKt;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.sdklib.SdkVersionInfo;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkParameters;", "checkAarMetadataWorkParameters", "(Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkParameters;)V", "checkAarMetadataArtifact", "", "aarMetadataArtifact", "Lcom/android/build/gradle/internal/tasks/AarMetadataArtifact;", "errorMessages", "", "", "execute", "getApiIntFromString", "", "sdkVersion", "gradle-core"})
public abstract class CheckAarMetadataWorkAction
implements WorkAction<CheckAarMetadataWorkParameters> {
    @NotNull
    private final CheckAarMetadataWorkParameters checkAarMetadataWorkParameters;

    @Inject
    public CheckAarMetadataWorkAction(@NotNull CheckAarMetadataWorkParameters checkAarMetadataWorkParameters) {
        Intrinsics.checkNotNullParameter((Object)checkAarMetadataWorkParameters, (String)"checkAarMetadataWorkParameters");
        this.checkAarMetadataWorkParameters = checkAarMetadataWorkParameters;
    }

    public void execute() {
        Object object = new String[]{"One or more issues found when checking AAR metadata values:"};
        List errorMessages = CollectionsKt.mutableListOf((Object[])object);
        object = this.checkAarMetadataWorkParameters.getAarMetadataArtifacts().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"checkAarMetadataWorkParameters.aarMetadataArtifacts.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AarMetadataArtifact it = (AarMetadataArtifact)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.checkAarMetadataArtifact(it, errorMessages);
        }
        if (errorMessages.size() > 1) {
            throw new RuntimeException(CollectionsKt.joinToString$default((Iterable)errorMessages, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null));
        }
    }

    private final void checkAarMetadataArtifact(AarMetadataArtifact aarMetadataArtifact, List<String> errorMessages) {
        String minAgpVersion;
        File aarMetadataFile = aarMetadataArtifact.getFile();
        String displayName = aarMetadataArtifact.getDisplayName();
        AarMetadataReader aarMetadataReader = new AarMetadataReader(aarMetadataFile);
        String aarFormatVersion = aarMetadataReader.getAarFormatVersion();
        if (aarFormatVersion == null) {
            errorMessages.add(StringsKt.trimIndent((String)("\n                    A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties) does\n                    not specify an aarFormatVersion value, which is a required value.\n                    Dependency: " + displayName + ".\n                    AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                    ")));
        } else {
            try {
                int majorAarVersion = Revision.parseRevision((String)aarFormatVersion).getMajor();
                int maxMajorAarVersion = Revision.parseRevision((String)((String)this.checkAarMetadataWorkParameters.getAarFormatVersion().get())).getMajor();
                if (majorAarVersion > maxMajorAarVersion) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            The aarFormatVersion (" + aarFormatVersion + ") specified in a\n                            dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                            is not compatible with this version of the Android Gradle Plugin.\n                            Please upgrade to a newer version of the Android Gradle Plugin.\n                            Dependency: " + displayName + ".\n                            AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                            ")));
                }
            }
            catch (NumberFormatException e) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                        has an invalid aarFormatVersion value.\n                        " + e.getMessage() + "\n                        Dependency: " + displayName + ".\n                        AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                        ")));
            }
        }
        String aarMetadataVersion = aarMetadataReader.getAarMetadataVersion();
        if (aarMetadataVersion == null) {
            errorMessages.add(StringsKt.trimIndent((String)("\n                    A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties) does\n                    not specify an aarMetadataVersion value, which is a required value.\n                    Dependency: " + displayName + ".\n                    AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                    ")));
        } else {
            try {
                int majorAarMetadataVersion = Revision.parseRevision((String)aarMetadataVersion).getMajor();
                int maxMajorAarMetadataVersion = Revision.parseRevision((String)((String)this.checkAarMetadataWorkParameters.getAarMetadataVersion().get())).getMajor();
                if (majorAarMetadataVersion > maxMajorAarMetadataVersion) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            The aarMetadataVersion (" + aarMetadataVersion + ") specified in a\n                            dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                            is not compatible with this version of the Android Gradle Plugin.\n                            Please upgrade to a newer version of the Android Gradle Plugin.\n                            Dependency: " + displayName + ".\n                            AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                            ")));
                }
            }
            catch (NumberFormatException e) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                        has an invalid aarMetadataVersion value.\n                        " + e.getMessage() + "\n                        Dependency: " + displayName + ".\n                        AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                        ")));
            }
        }
        String minCompileSdk = aarMetadataReader.getMinCompileSdk();
        if (minCompileSdk != null) {
            Integer minCompileSdkInt = StringsKt.toIntOrNull((String)minCompileSdk);
            if (minCompileSdkInt == null) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                        has an invalid minCompileSdk value. minCompileSdk\n                        must be an integer.\n                        Dependency: " + displayName + ".\n                        AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                        ")));
            } else {
                String compileSdkVersion = (String)this.checkAarMetadataWorkParameters.getCompileSdkVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)compileSdkVersion, (String)"compileSdkVersion");
                int compileSdkVersionInt = this.getApiIntFromString(compileSdkVersion);
                if (minCompileSdkInt > compileSdkVersionInt) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires 'compileSdkVersion' to be set to " + minCompileSdk + " or higher.\n                            Compilation target for module '" + this.checkAarMetadataWorkParameters.getProjectPath().get() + "' is '" + compileSdkVersion + "'\n                            ")));
                }
            }
        }
        if ((minAgpVersion = aarMetadataReader.getMinAgpVersion()) != null) {
            GradleVersion parsedMinAgpVersion = GradleVersion.tryParseStableAndroidGradlePluginVersion((String)minAgpVersion);
            if (parsedMinAgpVersion == null) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                        has an invalid minAndroidGradlePluginVersion value\n                        (" + minAgpVersion + "). minAndroidGradlePluginVersion must be a a\n                        stable AGP version, formatted with major, minor, and micro values (for\n                        example \"4.0.0\").\n                        Dependency: " + displayName + ".\n                        AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                        ")));
            } else {
                GradleVersion parsedAgpVersion = GradleVersion.parseAndroidGradlePluginVersion((String)((String)this.checkAarMetadataWorkParameters.getAgpVersion().get()));
                if (parsedMinAgpVersion.compareTo(parsedAgpVersion) > 0) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires an Android Gradle Plugin version of " + minAgpVersion + " or higher.\n                            The Android Gradle Plugin version used for this build is " + this.checkAarMetadataWorkParameters.getAgpVersion().get() + ".\n                            ")));
                }
            }
        }
    }

    private final int getApiIntFromString(String sdkVersion) {
        CompileData compileData = SdkUtilsKt.parseTargetHash(sdkVersion);
        if (compileData.getApiLevel() != null) {
            return compileData.getApiLevel();
        }
        if (compileData.getCodeName() != null) {
            return SdkVersionInfo.getApiByPreviewName((String)compileData.getCodeName(), (boolean)true);
        }
        throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported target hash: ", (Object)sdkVersion));
    }
}

