/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.SdkHandler;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.OptionalLibrary;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012J\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0012J\b\u0010 \u001a\u0004\u0018\u00010\u0012J\u0012\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020%H\u0002J\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014J\b\u0010'\u001a\u0004\u0018\u00010\u0012J\b\u0010(\u001a\u0004\u0018\u00010\u0012J\b\u0010)\u001a\u0004\u0018\u00010\u0012J\b\u0010*\u001a\u0004\u0018\u00010\u0012J\u0010\u0010+\u001a\u0004\u0018\u00010\u00122\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014J\b\u0010.\u001a\u0004\u0018\u00010/J\b\u00100\u001a\u00020\tH\u0002J\u0006\u00101\u001a\u000202R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/build/gradle/internal/SdkFullLoadingStrategy;", "", "sdkHandler", "Lcom/android/build/gradle/internal/SdkHandler;", "platformTargetHashSupplier", "", "buildToolRevisionSupplier", "Lcom/android/repository/Revision;", "useAndroidX", "", "(Lcom/android/build/gradle/internal/SdkHandler;Ljava/lang/String;Lcom/android/repository/Revision;Z)V", "sdkInfo", "Lcom/android/builder/sdk/SdkInfo;", "sdkInitResult", "Ljava/lang/Boolean;", "targetInfo", "Lcom/android/builder/sdk/TargetInfo;", "getAdbExecutable", "Ljava/io/File;", "getAdditionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "getAidlExecutable", "getAidlFramework", "getAndroidJar", "getAnnotationsJar", "getApiVersionsFile", "getBuildToolsInfo", "Lcom/android/sdklib/BuildToolInfo;", "getBuildToolsRevision", "getCoreForSystemModulesJar", "getCoreLambaStubs", "getEmulatorLibFolder", "getFileFromBuildTool", "component", "Lcom/android/sdklib/BuildToolInfo$PathId;", "getFileFromTarget", "", "getOptionalLibraries", "getRenderScriptSupportJar", "getSplitSelectExecutable", "getSupportBlasLibFolder", "getSupportNativeLibFolder", "getSystemImageLibFolder", "imageHash", "getTargetBootClasspath", "getTargetPlatformVersion", "Lcom/android/sdklib/AndroidVersion;", "init", "reset", "", "gradle-core"})
public final class SdkFullLoadingStrategy {
    @NotNull
    private final SdkHandler sdkHandler;
    @Nullable
    private final String platformTargetHashSupplier;
    @Nullable
    private final Revision buildToolRevisionSupplier;
    private final boolean useAndroidX;
    @Nullable
    private Boolean sdkInitResult;
    private SdkInfo sdkInfo;
    private TargetInfo targetInfo;

    public SdkFullLoadingStrategy(@NotNull SdkHandler sdkHandler, @Nullable String platformTargetHashSupplier, @Nullable Revision buildToolRevisionSupplier, boolean useAndroidX) {
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        this.sdkHandler = sdkHandler;
        this.platformTargetHashSupplier = platformTargetHashSupplier;
        this.buildToolRevisionSupplier = buildToolRevisionSupplier;
        this.useAndroidX = useAndroidX;
    }

    private final synchronized boolean init() {
        if (this.sdkInitResult != null) {
            Boolean bl = this.sdkInitResult;
            Intrinsics.checkNotNull((Object)bl);
            return bl;
        }
        String string = this.platformTargetHashSupplier;
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "Extension not initialized yet, couldn't access compileSdkVersion.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String platformHash = string;
        Revision revision = this.buildToolRevisionSupplier;
        bl2 = false;
        boolean bl4 = false;
        if (revision == null) {
            boolean bl5 = false;
            String string3 = "Extension not initialized yet, couldn't access buildToolsVersion.";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        Revision buildToolRevision = revision;
        Pair<SdkInfo, TargetInfo> result2 = this.sdkHandler.initTarget(platformHash, buildToolRevision);
        if (result2 == null) {
            this.sdkInitResult = false;
            return false;
        }
        this.sdkHandler.ensurePlatformToolsIsInstalledWarnOnFailure();
        this.sdkInitResult = true;
        Object object = result2.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.first");
        this.sdkInfo = (SdkInfo)object;
        object = result2.getSecond();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.second");
        this.targetInfo = (TargetInfo)object;
        return true;
    }

    @Nullable
    public final File getAdbExecutable() {
        File file;
        if (this.init()) {
            SdkInfo sdkInfo;
            SdkInfo sdkInfo2 = this.sdkInfo;
            if (sdkInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sdkInfo");
                sdkInfo = null;
            } else {
                sdkInfo = sdkInfo2;
            }
            file = sdkInfo.getAdb();
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAnnotationsJar() {
        File file;
        if (this.init()) {
            SdkInfo sdkInfo;
            SdkInfo sdkInfo2 = this.sdkInfo;
            if (sdkInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sdkInfo");
                sdkInfo = null;
            } else {
                sdkInfo = sdkInfo2;
            }
            file = sdkInfo.getAnnotationsJar();
        } else {
            file = null;
        }
        return file;
    }

    private final File getFileFromTarget(int component2) {
        File file;
        if (this.init()) {
            TargetInfo targetInfo;
            TargetInfo targetInfo2 = this.targetInfo;
            if (targetInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
                targetInfo = null;
            } else {
                targetInfo = targetInfo2;
            }
            file = targetInfo.getTarget().getPath(component2).toFile();
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAidlFramework() {
        return this.getFileFromTarget(2);
    }

    @Nullable
    public final File getAndroidJar() {
        return this.getFileFromTarget(1);
    }

    @Nullable
    public final List<OptionalLibrary> getAdditionalLibraries() {
        List list;
        if (this.init()) {
            TargetInfo targetInfo;
            TargetInfo targetInfo2 = this.targetInfo;
            if (targetInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
                targetInfo = null;
            } else {
                targetInfo = targetInfo2;
            }
            list = targetInfo.getTarget().getAdditionalLibraries();
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final List<OptionalLibrary> getOptionalLibraries() {
        List list;
        if (this.init()) {
            TargetInfo targetInfo;
            TargetInfo targetInfo2 = this.targetInfo;
            if (targetInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
                targetInfo = null;
            } else {
                targetInfo = targetInfo2;
            }
            list = targetInfo.getTarget().getOptionalLibraries();
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final File getApiVersionsFile() {
        File file;
        if (this.init()) {
            File file2 = this.getFileFromTarget(7);
            if (file2 == null) {
                file = null;
            } else {
                File file3 = FilesKt.resolve((File)file2, (String)"api-versions.xml");
                if (file3 == null) {
                    file = null;
                } else {
                    File file4 = file3;
                    boolean bl = false;
                    boolean bl2 = false;
                    File it = file4;
                    boolean bl3 = false;
                    file = it.exists() ? file4 : null;
                }
            }
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final AndroidVersion getTargetPlatformVersion() {
        AndroidVersion androidVersion;
        if (this.init()) {
            TargetInfo targetInfo;
            TargetInfo targetInfo2 = this.targetInfo;
            if (targetInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
                targetInfo = null;
            } else {
                targetInfo = targetInfo2;
            }
            androidVersion = targetInfo.getTarget().getVersion();
        } else {
            androidVersion = null;
        }
        return androidVersion;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<File> getTargetBootClasspath() {
        List list;
        if (this.init()) {
            void $this$mapTo$iv$iv;
            TargetInfo targetInfo;
            TargetInfo targetInfo2 = this.targetInfo;
            if (targetInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
                targetInfo = null;
            } else {
                targetInfo = targetInfo2;
            }
            List list2 = targetInfo.getTarget().getBootClasspath();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"targetInfo.target.bootClasspath");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file = new File((String)it);
                collection.add(file);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final BuildToolInfo getBuildToolsInfo() {
        BuildToolInfo buildToolInfo;
        if (this.init()) {
            TargetInfo targetInfo;
            TargetInfo targetInfo2 = this.targetInfo;
            if (targetInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
                targetInfo = null;
            } else {
                targetInfo = targetInfo2;
            }
            buildToolInfo = targetInfo.getBuildTools();
        } else {
            buildToolInfo = null;
        }
        return buildToolInfo;
    }

    @Nullable
    public final Revision getBuildToolsRevision() {
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        return buildToolInfo == null ? null : buildToolInfo.getRevision();
    }

    private final File getFileFromBuildTool(BuildToolInfo.PathId component2) {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo == null) {
            file = null;
        } else {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            file = new File(it.getPath(component2));
        }
        return file;
    }

    @Nullable
    public final File getAidlExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.AIDL);
    }

    @Nullable
    public final File getCoreLambaStubs() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.CORE_LAMBDA_STUBS);
    }

    @Nullable
    public final File getSplitSelectExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.SPLIT_SELECT);
    }

    @Nullable
    public final File getRenderScriptSupportJar() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo == null) {
            file = null;
        } else {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.location.toFile()");
            file = RenderScriptProcessor.Companion.getSupportJar(file2, this.useAndroidX);
        }
        return file;
    }

    @Nullable
    public final File getSupportNativeLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo == null) {
            file = null;
        } else {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.location.toFile()");
            file = RenderScriptProcessor.Companion.getSupportNativeLibFolder(file2);
        }
        return file;
    }

    @Nullable
    public final File getSupportBlasLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo == null) {
            file = null;
        } else {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.location.toFile()");
            file = RenderScriptProcessor.Companion.getSupportBlasLibFolder(file2);
        }
        return file;
    }

    @Nullable
    public final File getSystemImageLibFolder(@NotNull String imageHash) {
        Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
        return this.sdkHandler.installSystemImageWarnOnFailure(imageHash);
    }

    @Nullable
    public final File getEmulatorLibFolder() {
        return this.sdkHandler.getLocalEmulator();
    }

    @Nullable
    public final File getCoreForSystemModulesJar() {
        return this.getFileFromTarget(28);
    }

    public final synchronized void reset() {
        this.sdkInitResult = null;
    }
}

