/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NdkMetaPlatforms;", "", "min", "", "max", "aliases", "", "", "(IILjava/util/Map;)V", "getAliases", "()Ljava/util/Map;", "getMax", "()I", "getMin", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "gradle-core"})
public final class NdkMetaPlatforms {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int min;
    private final int max;
    @NotNull
    private final Map<String, Integer> aliases;
    @NotNull
    private static final IntRange potentialPlatforms = RangesKt.until((int)0, (int)64);

    public NdkMetaPlatforms(int min, int max, @NotNull Map<String, Integer> aliases) {
        Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
        this.min = min;
        this.max = max;
        this.aliases = aliases;
        if (!potentialPlatforms.contains(this.min)) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_CORRUPTED, Intrinsics.stringPlus((String)"potentialPlatforms range needs to include ", (Object)this.min), new Object[0]);
        }
        if (!potentialPlatforms.contains(this.max)) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_CORRUPTED, Intrinsics.stringPlus((String)"potentialPlatforms range needs to include ", (Object)this.max), new Object[0]);
        }
    }

    public /* synthetic */ NdkMetaPlatforms(int n, int n2, Map map, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = potentialPlatforms.getFirst();
        }
        if ((n3 & 2) != 0) {
            n2 = potentialPlatforms.getLast();
        }
        if ((n3 & 4) != 0) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        this(n, n2, map);
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    @NotNull
    public final Map<String, Integer> getAliases() {
        return this.aliases;
    }

    public final int component1() {
        return this.min;
    }

    public final int component2() {
        return this.max;
    }

    @NotNull
    public final Map<String, Integer> component3() {
        return this.aliases;
    }

    @NotNull
    public final NdkMetaPlatforms copy(int min, int max, @NotNull Map<String, Integer> aliases) {
        Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
        return new NdkMetaPlatforms(min, max, aliases);
    }

    public static /* synthetic */ NdkMetaPlatforms copy$default(NdkMetaPlatforms ndkMetaPlatforms, int n, int n2, Map map, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = ndkMetaPlatforms.min;
        }
        if ((n3 & 2) != 0) {
            n2 = ndkMetaPlatforms.max;
        }
        if ((n3 & 4) != 0) {
            map = ndkMetaPlatforms.aliases;
        }
        return ndkMetaPlatforms.copy(n, n2, map);
    }

    @NotNull
    public String toString() {
        return "NdkMetaPlatforms(min=" + this.min + ", max=" + this.max + ", aliases=" + this.aliases + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.min);
        result2 = result2 * 31 + Integer.hashCode(this.max);
        result2 = result2 * 31 + ((Object)this.aliases).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NdkMetaPlatforms)) {
            return false;
        }
        NdkMetaPlatforms ndkMetaPlatforms = (NdkMetaPlatforms)other;
        if (this.min != ndkMetaPlatforms.min) {
            return false;
        }
        if (this.max != ndkMetaPlatforms.max) {
            return false;
        }
        return Intrinsics.areEqual(this.aliases, ndkMetaPlatforms.aliases);
    }

    public NdkMetaPlatforms() {
        this(0, 0, null, 7, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NdkMetaPlatforms$Companion;", "", "()V", "potentialPlatforms", "Lkotlin/ranges/IntRange;", "getPotentialPlatforms", "()Lkotlin/ranges/IntRange;", "fromReader", "Lcom/android/build/gradle/internal/cxx/configure/NdkMetaPlatforms;", "reader", "Ljava/io/Reader;", "jsonFile", "Ljava/io/File;", "ndkRoot", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRange getPotentialPlatforms() {
            return potentialPlatforms;
        }

        @NotNull
        public final File jsonFile(@NotNull File ndkRoot) {
            Intrinsics.checkNotNullParameter((Object)ndkRoot, (String)"ndkRoot");
            return new File(ndkRoot, "meta/platforms.json");
        }

        @NotNull
        public final NdkMetaPlatforms fromReader(@NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Type mapTypeToken2 = new TypeToken<NdkMetaPlatforms>(){}.getType();
            Object object = new Gson().fromJson(reader, mapTypeToken2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(reader, mapTypeToken)");
            return (NdkMetaPlatforms)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

