/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.VariantType;
import com.android.utils.StringHelper;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ%\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\"\u00020+\u00a2\u0006\u0002\u0010,J+\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010.\u001a\u00020+2\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*H\u0002\u00a2\u0006\u0002\u0010/J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u00101\u001a\u00020+J\u000e\u00102\u001a\u00020\u00112\u0006\u00101\u001a\u00020+J\u0010\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020+H\u0002J%\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\"\u00020+\u00a2\u0006\u0002\u0010,J%\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\"\u00020+\u00a2\u0006\u0002\u0010,J%\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\"\u00020+\u00a2\u0006\u0002\u0010,R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001b\u0010\rR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000f\u001a\u0004\b\u001e\u0010\rR!\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u000f\u001a\u0004\b!\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\rR!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000f\u001a\u0004\b&\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/build/gradle/internal/variant/VariantPathHelper;", "", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "variantDslInfo", "Lcom/android/build/gradle/internal/core/VariantDslInfo;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "(Lorg/gradle/api/file/DirectoryProperty;Lcom/android/build/gradle/internal/core/VariantDslInfo;Lcom/android/build/gradle/internal/services/DslServices;)V", "aarLocation", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getAarLocation", "()Lorg/gradle/api/provider/Provider;", "aarLocation$delegate", "Lkotlin/Lazy;", "apkLocation", "Ljava/io/File;", "getApkLocation", "()Ljava/io/File;", "apkLocation$delegate", "buildConfigSourceOutputDir", "getBuildConfigSourceOutputDir", "buildConfigSourceOutputDir$delegate", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "coverageReportDir", "getCoverageReportDir", "coverageReportDir$delegate", "defaultApkLocation", "getDefaultApkLocation", "defaultApkLocation$delegate", "deploymentApkLocation", "getDeploymentApkLocation", "deploymentApkLocation$delegate", "manifestOutputDirectory", "getManifestOutputDirectory", "renderscriptObjOutputDir", "getRenderscriptObjOutputDir", "renderscriptObjOutputDir$delegate", "generatedDir", "subDirs", "", "", "([Ljava/lang/String;)Lorg/gradle/api/provider/Provider;", "getBuildSubDir", "childDir", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/gradle/api/provider/Provider;", "getGeneratedResourcesDir", "name", "getIncrementalDir", "intermediate", "directoryName", "intermediatesDir", "outputDir", "reportsDir", "gradle-core"})
public final class VariantPathHelper {
    @NotNull
    private final DirectoryProperty buildDirectory;
    @NotNull
    private final VariantDslInfo variantDslInfo;
    @NotNull
    private final DslServices dslServices;
    @NotNull
    private final Lazy buildConfigSourceOutputDir$delegate;
    @NotNull
    private final Lazy renderscriptObjOutputDir$delegate;
    @NotNull
    private final Lazy coverageReportDir$delegate;
    @NotNull
    private final Lazy apkLocation$delegate;
    @NotNull
    private final Lazy defaultApkLocation$delegate;
    @NotNull
    private final Lazy deploymentApkLocation$delegate;
    @NotNull
    private final Lazy aarLocation$delegate;

    public VariantPathHelper(@NotNull DirectoryProperty buildDirectory, @NotNull VariantDslInfo variantDslInfo, @NotNull DslServices dslServices2) {
        Intrinsics.checkNotNullParameter((Object)buildDirectory, (String)"buildDirectory");
        Intrinsics.checkNotNullParameter((Object)variantDslInfo, (String)"variantDslInfo");
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        this.buildDirectory = buildDirectory;
        this.variantDslInfo = variantDslInfo;
        this.dslServices = dslServices2;
        this.buildConfigSourceOutputDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"source", "buildConfig", VariantPathHelper.access$getVariantDslInfo$p(this.this$0).getDirName()};
                return this.this$0.generatedDir(stringArray);
            }
        }));
        this.renderscriptObjOutputDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                Object[] objectArray = new Object[]{"rs", VariantPathHelper.access$getVariantDslInfo$p(this.this$0).getDirectorySegments(), "obj"};
                Collection $this$toTypedArray$iv = StringHelper.toStrings((Object[])objectArray);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return VariantPathHelper.access$getBuildSubDir(this.this$0, "intermediates", stringArray);
            }
        }));
        this.coverageReportDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"coverage", VariantPathHelper.access$getVariantDslInfo$p(this.this$0).getDirName()};
                return this.this$0.reportsDir(stringArray);
            }
        }));
        this.apkLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                String override = VariantPathHelper.access$getDslServices$p(this.this$0).getProjectOptions().get(StringOption.IDE_APK_LOCATION);
                boolean customBuild = VariantPathHelper.access$getDslServices$p(this.this$0).getProjectOptions().get(StringOption.IDE_BUILD_TARGET_DENSITY) != null || VariantPathHelper.access$getDslServices$p(this.this$0).getProjectOptions().get(StringOption.IDE_BUILD_TARGET_ABI) != null || VariantPathHelper.access$getDslServices$p(this.this$0).getProjectOptions().get(IntegerOption.IDE_TARGET_DEVICE_API) != null;
                File baseDirectory = override != null ? VariantPathHelper.access$getDslServices$p(this.this$0).file(override) : (customBuild ? ((Directory)VariantPathHelper.access$getDeploymentApkLocation(this.this$0).get()).getAsFile() : ((Directory)VariantPathHelper.access$getDefaultApkLocation(this.this$0).get()).getAsFile());
                return new File(baseDirectory, VariantPathHelper.access$getVariantDslInfo$p(this.this$0).getDirName());
            }
        }));
        this.defaultApkLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"apk"};
                return this.this$0.outputDir(stringArray);
            }
        }));
        this.deploymentApkLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"apk"};
                return this.this$0.intermediatesDir(stringArray);
            }
        }));
        this.aarLocation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ VariantPathHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Provider<Directory> invoke() {
                String[] stringArray = new String[]{"aar"};
                return this.this$0.outputDir(stringArray);
            }
        }));
    }

    @NotNull
    public final DirectoryProperty getBuildDirectory() {
        return this.buildDirectory;
    }

    @NotNull
    public final Provider<Directory> intermediatesDir(String ... subDirs) {
        Intrinsics.checkNotNullParameter((Object)subDirs, (String)"subDirs");
        return this.getBuildSubDir("intermediates", subDirs);
    }

    @NotNull
    public final Provider<Directory> outputDir(String ... subDirs) {
        Intrinsics.checkNotNullParameter((Object)subDirs, (String)"subDirs");
        return this.getBuildSubDir("outputs", subDirs);
    }

    @NotNull
    public final Provider<Directory> generatedDir(String ... subDirs) {
        Intrinsics.checkNotNullParameter((Object)subDirs, (String)"subDirs");
        return this.getBuildSubDir("generated", subDirs);
    }

    @NotNull
    public final Provider<Directory> reportsDir(String ... subDirs) {
        Intrinsics.checkNotNullParameter((Object)subDirs, (String)"subDirs");
        return this.getBuildSubDir("reports", subDirs);
    }

    @NotNull
    public final Provider<Directory> getBuildConfigSourceOutputDir() {
        Lazy lazy = this.buildConfigSourceOutputDir$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getRenderscriptObjOutputDir() {
        Lazy lazy = this.renderscriptObjOutputDir$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getCoverageReportDir() {
        Lazy lazy = this.coverageReportDir$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final File getApkLocation() {
        Lazy lazy = this.apkLocation$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    private final Provider<Directory> getDefaultApkLocation() {
        Lazy lazy = this.defaultApkLocation$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    private final Provider<Directory> getDeploymentApkLocation() {
        Lazy lazy = this.deploymentApkLocation$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getAarLocation() {
        Lazy lazy = this.aarLocation$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getManifestOutputDirectory() {
        VariantType variantType = this.variantDslInfo.getVariantType();
        if (variantType.isTestComponent()) {
            if (variantType.isApk()) {
                String[] stringArray = new String[]{"manifest", this.variantDslInfo.getDirName()};
                return this.intermediatesDir(stringArray);
            }
        } else {
            String[] stringArray = new String[]{"manifests", "full", this.variantDslInfo.getDirName()};
            return this.intermediatesDir(stringArray);
        }
        throw new RuntimeException("getManifestOutputDirectory called for an unexpected variant.");
    }

    @NotNull
    public final File getIncrementalDir(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{"incremental", name};
        File file = ((Directory)this.intermediatesDir(stringArray).get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"intermediatesDir(\"incremental\", name).get().asFile");
        return file;
    }

    @NotNull
    public final Provider<Directory> getGeneratedResourcesDir(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object[] objectArray = new String[]{"res", name};
        List dirs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)CollectionsKt.filterNotNull((Iterable)this.variantDslInfo.getDirectorySegments()));
        Collection $this$toTypedArray$iv = dirs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = stringArray;
        return this.generatedDir((String[])Arrays.copyOf(objectArray, objectArray.length));
    }

    private final Provider<Directory> getBuildSubDir(String childDir, String[] subDirs) {
        if (ArraysKt.any((Object[])subDirs) && StringsKt.contains$default((CharSequence)((CharSequence)ArraysKt.last((Object[])subDirs)), (char)'.', (boolean)false, (int)2, null)) {
            throw new IllegalStateException("Directory should not contain '.'.");
        }
        Provider provider2 = this.buildDirectory.dir(Intrinsics.stringPlus((String)childDir, (Object)ArraysKt.joinToString$default((Object[])subDirs, (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null)));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildDirectory.dir(\"$chi\u2026r = \"/\", prefix = \"/\")}\")");
        return provider2;
    }

    private final File intermediate(String directoryName) {
        String[] stringArray = new String[]{directoryName, this.variantDslInfo.getDirName()};
        File file = ((Directory)this.intermediatesDir(stringArray).get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"intermediatesDir(directo\u2026nfo.dirName).get().asFile");
        return file;
    }

    public static final /* synthetic */ VariantDslInfo access$getVariantDslInfo$p(VariantPathHelper $this) {
        return $this.variantDslInfo;
    }

    public static final /* synthetic */ Provider access$getBuildSubDir(VariantPathHelper $this, String childDir, String[] subDirs) {
        return $this.getBuildSubDir(childDir, subDirs);
    }

    public static final /* synthetic */ DslServices access$getDslServices$p(VariantPathHelper $this) {
        return $this.dslServices;
    }

    public static final /* synthetic */ Provider access$getDeploymentApkLocation(VariantPathHelper $this) {
        return $this.getDeploymentApkLocation();
    }

    public static final /* synthetic */ Provider access$getDefaultApkLocation(VariantPathHelper $this) {
        return $this.getDefaultApkLocation();
    }
}

