/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.model;

import com.android.build.gradle.internal.cxx.configure.BuildSystemCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.CmakeProperty;
import com.android.build.gradle.internal.cxx.configure.CommandLineArgument;
import com.android.build.gradle.internal.cxx.configure.NdkBuildProperty;
import com.android.build.gradle.internal.cxx.configure.NdkMetaPlatforms;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 \u001a\u0018\u0010!\u001a\u00020\u001e*\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\"0 \u001a\u0018\u0010#\u001a\u00020\u001e*\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\"0 \u001a\u0018\u0010$\u001a\u00020\u001e*\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\"0 \"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0015\u0010\r\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0004\"\u0015\u0010\u000f\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\"\u0015\u0010\u0011\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0004\"\u0015\u0010\u0013\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\"\u0015\u0010\u0015\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\b\"\u0015\u0010\u0017\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\b\"\u0015\u0010\u0019\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\b\"\u0015\u0010\u001b\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\b\u00a8\u0006%"}, d2={"buildSettingsFile", "Ljava/io/File;", "Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;", "getBuildSettingsFile", "(Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;)Ljava/io/File;", "buildSystemNameForTasks", "", "getBuildSystemNameForTasks", "(Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;)Ljava/lang/String;", "buildSystemTag", "getBuildSystemTag", "cmakeGenerator", "getCmakeGenerator", "cmakeSettingsFile", "getCmakeSettingsFile", "intermediatesParentDirSuffix", "getIntermediatesParentDirSuffix", "makeFileFolder", "getMakeFileFolder", "moduleName", "getModuleName", "ndkMajorVersion", "getNdkMajorVersion", "ndkMaxPlatform", "getNdkMaxPlatform", "ndkMinPlatform", "getNdkMinPlatform", "ndkMinorVersion", "getNdkMinorVersion", "determineUsedStl", "Lcom/android/build/gradle/internal/ndk/Stl;", "arguments", "", "determineUsedStlForCmake", "Lcom/android/build/gradle/internal/cxx/configure/CommandLineArgument;", "determineUsedStlForNdkBuild", "determineUsedStlFromArguments", "gradle-core"})
public final class CxxModuleModelKt {
    @NotNull
    public static final File getCmakeSettingsFile(@NotNull CxxModuleModel $this$cmakeSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)$this$cmakeSettingsFile, (String)"<this>");
        String[] stringArray = new String[]{"CMakeSettings.json"};
        File file = FileUtils.join((File)$this$cmakeSettingsFile.getMakeFile().getParentFile(), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(makeFile.parentFile, \"CMakeSettings.json\")");
        return file;
    }

    @NotNull
    public static final File getBuildSettingsFile(@NotNull CxxModuleModel $this$buildSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)$this$buildSettingsFile, (String)"<this>");
        String[] stringArray = new String[]{"BuildSettings.json"};
        File file = FileUtils.join((File)$this$buildSettingsFile.getMakeFile().getParentFile(), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(makeFile.parentFile, \"BuildSettings.json\")");
        return file;
    }

    @NotNull
    public static final File getMakeFileFolder(@NotNull CxxModuleModel $this$makeFileFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$makeFileFolder, (String)"<this>");
        File file = $this$makeFileFolder.getMakeFile().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"makeFile.parentFile");
        return file;
    }

    @NotNull
    public static final String getModuleName(@NotNull CxxModuleModel $this$moduleName) {
        Intrinsics.checkNotNullParameter((Object)$this$moduleName, (String)"<this>");
        return StringsKt.substringAfterLast$default((String)$this$moduleName.getGradleModulePathName(), (String)":", null, (int)2, null);
    }

    @NotNull
    public static final String getNdkMinPlatform(@NotNull CxxModuleModel $this$ndkMinPlatform) {
        Integer n;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$ndkMinPlatform, (String)"<this>");
        NdkMetaPlatforms ndkMetaPlatforms = $this$ndkMinPlatform.getNdkMetaPlatforms();
        return ndkMetaPlatforms == null ? "" : ((string = (n = Integer.valueOf(ndkMetaPlatforms.getMin())).toString()) == null ? "" : string);
    }

    @NotNull
    public static final String getNdkMaxPlatform(@NotNull CxxModuleModel $this$ndkMaxPlatform) {
        Integer n;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$ndkMaxPlatform, (String)"<this>");
        NdkMetaPlatforms ndkMetaPlatforms = $this$ndkMaxPlatform.getNdkMetaPlatforms();
        return ndkMetaPlatforms == null ? "" : ((string = (n = Integer.valueOf(ndkMetaPlatforms.getMax())).toString()) == null ? "" : string);
    }

    @NotNull
    public static final String getNdkMajorVersion(@NotNull CxxModuleModel $this$ndkMajorVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$ndkMajorVersion, (String)"<this>");
        return String.valueOf($this$ndkMajorVersion.getNdkVersion().getMajor());
    }

    @NotNull
    public static final String getNdkMinorVersion(@NotNull CxxModuleModel $this$ndkMinorVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$ndkMinorVersion, (String)"<this>");
        return String.valueOf($this$ndkMinorVersion.getNdkVersion().getMinor());
    }

    @NotNull
    public static final String getCmakeGenerator(@NotNull CxxModuleModel $this$cmakeGenerator) {
        Intrinsics.checkNotNullParameter((Object)$this$cmakeGenerator, (String)"<this>");
        return $this$cmakeGenerator.getCmake() == null ? "" : (CmakeLocatorKt.isCmakeForkVersion($this$cmakeGenerator.getCmake().getMinimumCmakeVersion()) ? "Android Gradle - Ninja" : "Ninja");
    }

    @NotNull
    public static final Stl determineUsedStlForCmake(@NotNull CxxModuleModel $this$determineUsedStlForCmake, @NotNull List<? extends CommandLineArgument> arguments) {
        Intrinsics.checkNotNullParameter((Object)$this$determineUsedStlForCmake, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        String stlFromArgument = BuildSystemCommandLineKt.getCmakeProperty(arguments, CmakeProperty.ANDROID_STL);
        if (stlFromArgument != null) {
            Stl result2 = Stl.Companion.fromArgumentName(stlFromArgument);
            if (result2 != null) {
                return result2;
            }
            LoggingEnvironmentKt.warnln(Intrinsics.stringPlus((String)"Unable to parse STL from build.gradle arguments: ", (Object)stlFromArgument), new Object[0]);
        }
        return $this$determineUsedStlForCmake.getNdkDefaultStl();
    }

    @NotNull
    public static final Stl determineUsedStlForNdkBuild(@NotNull CxxModuleModel $this$determineUsedStlForNdkBuild, @NotNull List<? extends CommandLineArgument> arguments) {
        Intrinsics.checkNotNullParameter((Object)$this$determineUsedStlForNdkBuild, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        String stlFromArgument = BuildSystemCommandLineKt.getNdkBuildProperty(arguments, NdkBuildProperty.APP_STL);
        if (stlFromArgument != null) {
            Stl result2 = Stl.Companion.fromArgumentName(stlFromArgument);
            if (result2 != null) {
                return result2;
            }
            LoggingEnvironmentKt.warnln(Intrinsics.stringPlus((String)"Unable to parse STL from build.gradle arguments: ", (Object)stlFromArgument), new Object[0]);
        }
        String appStl = null;
        File applicationMk = FilesKt.resolveSibling((File)$this$determineUsedStlForNdkBuild.getMakeFile(), (String)"Application.mk");
        if (applicationMk.exists()) {
            Iterator iterator2 = StringsKt.lines((CharSequence)FilesKt.readText$default((File)applicationMk, null, (int)1, null)).iterator();
            while (iterator2.hasNext()) {
                String line;
                String string = line = (String)iterator2.next();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                MatchResult matchResult = Regex.find$default((Regex)new Regex("^APP_STL\\s*:?=\\s*(.*)$"), (CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (int)0, (int)2, null);
                if (matchResult == null) continue;
                MatchResult match2 = matchResult;
                MatchGroup appStlMatch = match2.getGroups().get(1);
                boolean bl2 = appStlMatch != null;
                bl = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String string3 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
                string = appStlMatch.getValue();
                bl = false;
                bl3 = false;
                String it = string;
                boolean bl6 = false;
                CharSequence charSequence = it;
                boolean bl7 = false;
                appStl = charSequence.length() > 0 ? string : null;
            }
            if (appStl != null) {
                Stl result3 = Stl.Companion.fromArgumentName(appStl);
                if (result3 != null) {
                    return result3;
                }
                LoggingEnvironmentKt.warnln("Unable to parse APP_STL from " + applicationMk + ": " + appStl, new Object[0]);
            }
        }
        return $this$determineUsedStlForNdkBuild.getNdkDefaultStl();
    }

    @NotNull
    public static final Stl determineUsedStlFromArguments(@NotNull CxxModuleModel $this$determineUsedStlFromArguments, @NotNull List<? extends CommandLineArgument> arguments) {
        Stl stl;
        Intrinsics.checkNotNullParameter((Object)$this$determineUsedStlFromArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        NativeBuildSystem nativeBuildSystem = $this$determineUsedStlFromArguments.getBuildSystem();
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                stl = CxxModuleModelKt.determineUsedStlForCmake($this$determineUsedStlFromArguments, arguments);
                break;
            }
            case 2: {
                stl = CxxModuleModelKt.determineUsedStlForNdkBuild($this$determineUsedStlFromArguments, arguments);
                break;
            }
            case 3: {
                stl = Stl.UNKNOWN;
                break;
            }
            default: {
                String string = String.valueOf((Object)$this$determineUsedStlFromArguments.getBuildSystem());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return stl;
    }

    @NotNull
    public static final Stl determineUsedStl(@NotNull CxxModuleModel $this$determineUsedStl, @NotNull List<String> arguments) {
        Stl stl;
        Intrinsics.checkNotNullParameter((Object)$this$determineUsedStl, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        NativeBuildSystem nativeBuildSystem = $this$determineUsedStl.getBuildSystem();
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                stl = CxxModuleModelKt.determineUsedStlForCmake($this$determineUsedStl, BuildSystemCommandLineKt.toCmakeArguments(arguments));
                break;
            }
            case 2: {
                stl = CxxModuleModelKt.determineUsedStlForNdkBuild($this$determineUsedStl, BuildSystemCommandLineKt.toNdkBuildArguments(arguments));
                break;
            }
            case 3: {
                stl = Stl.UNKNOWN;
                break;
            }
            default: {
                String string = String.valueOf((Object)$this$determineUsedStl.getBuildSystem());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return stl;
    }

    @NotNull
    public static final String getBuildSystemTag(@NotNull CxxModuleModel $this$buildSystemTag) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$buildSystemTag, (String)"<this>");
        NativeBuildSystem nativeBuildSystem = $this$buildSystemTag.getBuildSystem();
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                string = "cmake";
                break;
            }
            case 3: {
                string = "ninja";
                break;
            }
            case 2: {
                string = "ndkBuild";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String getBuildSystemNameForTasks(@NotNull CxxModuleModel $this$buildSystemNameForTasks) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$buildSystemNameForTasks, (String)"<this>");
        NativeBuildSystem nativeBuildSystem = $this$buildSystemNameForTasks.getBuildSystem();
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                string = "CMake";
                break;
            }
            case 3: {
                string = "Ninja";
                break;
            }
            case 2: {
                string = "NdkBuild";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String getIntermediatesParentDirSuffix(@NotNull CxxModuleModel $this$intermediatesParentDirSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$intermediatesParentDirSuffix, (String)"<this>");
        NativeBuildSystem nativeBuildSystem = $this$intermediatesParentDirSuffix.getBuildSystem();
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        return n == 2 ? "obj/local" : "obj";
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            nArray[NativeBuildSystem.CMAKE.ordinal()] = 1;
            nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 2;
            nArray[NativeBuildSystem.NINJA.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

